/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.metadata.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.RelaxedPropertyNames;
import org.apereo.cas.metadata.CasConfigurationMetadataRepository;
import org.apereo.cas.metadata.rest.ConfigurationMetadataSearchResult;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Endpoint(id="configurationMetadata", defaultAccess=Access.NONE)
public class CasConfigurationMetadataServerEndpoint
extends BaseCasRestActuatorEndpoint {
    private final CasConfigurationMetadataRepository repository;

    public CasConfigurationMetadataServerEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, CasConfigurationMetadataRepository repository) {
        super(casProperties, applicationContext);
        this.repository = repository;
    }

    @GetMapping
    @Operation(summary="Get all properties from the repository")
    public Map<String, ConfigurationMetadataProperty> properties() {
        return this.repository.getRepository().getAllProperties();
    }

    @GetMapping(value={"/{term}"})
    @Operation(summary="Get all properties from the repository that match the name or description", parameters={@Parameter(name="term", required=true, description="The search term to search for")})
    public List<ConfigurationMetadataSearchResult> search(@PathVariable String term) {
        Map allProps = this.repository.getRepository().getAllProperties();
        String names = StreamSupport.stream(RelaxedPropertyNames.forCamelCase((String)term).spliterator(), false).map(Object::toString).collect(Collectors.joining("|"));
        Pattern pattern = RegexUtils.createPattern((String)names);
        return allProps.entrySet().parallelStream().filter(entry -> RegexUtils.find((Pattern)pattern, (String)((String)entry.getKey())) || RegexUtils.find((Pattern)pattern, (String)StringUtils.defaultString((String)((ConfigurationMetadataProperty)entry.getValue()).getDescription()))).map(entry -> new ConfigurationMetadataSearchResult((ConfigurationMetadataProperty)entry.getValue())).sorted().toList();
    }
}

