/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces;

import com.sun.faces.facelets.tag.MetaRulesetImpl;
import com.sun.faces.facelets.tag.faces.ComponentSupport;
import com.sun.faces.facelets.tag.faces.CompositeComponentTagHandler;
import com.sun.faces.util.Util;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.Behavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.AttachedObjectTarget;
import jakarta.faces.view.BehaviorHolderAttachedObjectTarget;
import jakarta.faces.view.facelets.BehaviorHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandlerDelegate;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.List;

class BehaviorTagHandlerDelegateImpl
extends TagHandlerDelegate
implements AttachedObjectHandler {
    private BehaviorHandler owner;

    public BehaviorTagHandlerDelegateImpl(BehaviorHandler owner) {
        this.owner = owner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null || parent.getParent() != null) {
            return;
        }
        ComponentSupport.copyPassthroughAttributes(ctx, parent, this.owner.getTag());
        if (UIComponent.isCompositeComponent(parent)) {
            BeanInfo componentBeanInfo = (BeanInfo)parent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY");
            if (null == componentBeanInfo) {
                throw new TagException(this.owner.getTag(), "Error: enclosing composite component does not have BeanInfo attribute");
            }
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            if (null == componentDescriptor) {
                throw new TagException(this.owner.getTag(), "Error: enclosing composite component BeanInfo does not have BeanDescriptor");
            }
            List targetList = (List)componentDescriptor.getValue("jakarta.faces.view.AttachedObjectTargets");
            if (null == targetList) {
                throw new TagException(this.owner.getTag(), "Error: enclosing composite component does not support behavior events");
            }
            String eventName = this.owner.getEventName();
            boolean supportedEvent = false;
            for (AttachedObjectTarget target : targetList) {
                if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                supportedEvent = true;
                break;
            }
            if (!supportedEvent) throw new TagException(this.owner.getTag(), "Error: enclosing composite component does not support event " + eventName);
            CompositeComponentTagHandler.getAttachedObjectHandlers(parent).add(this.owner);
            return;
        } else {
            if (!(parent instanceof ClientBehaviorHolder)) throw new TagException(this.owner.getTag(), "Parent not an instance of ClientBehaviorHolder: " + parent);
            this.owner.applyAttachedObject(ctx.getFacesContext(), parent);
        }
    }

    @Override
    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)((Object)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
        ClientBehaviorHolder behaviorHolder = (ClientBehaviorHolder)((Object)parent);
        ValueExpression bindingExpr = null;
        Behavior behavior = null;
        if (null != this.owner.getBinding()) {
            bindingExpr = this.owner.getBinding().getValueExpression(ctx, Behavior.class);
            behavior = (Behavior)bindingExpr.getValue((ELContext)ctx);
        }
        if (null == behavior) {
            if (null != this.owner.getBehaviorId()) {
                behavior = ctx.getFacesContext().getApplication().createBehavior(this.owner.getBehaviorId());
                if (null == behavior) {
                    throw new TagException(this.owner.getTag(), "No Faces behavior defined for Id " + this.owner.getBehaviorId());
                }
                if (null != bindingExpr) {
                    bindingExpr.setValue((ELContext)ctx, (Object)behavior);
                }
            } else {
                throw new TagException(this.owner.getTag(), "No behaviorId defined");
            }
        }
        this.owner.setAttributes(ctx, behavior);
        if (behavior instanceof ClientBehavior) {
            behaviorHolder.addClientBehavior(this.getEventName(behaviorHolder), (ClientBehavior)behavior);
        }
    }

    @Override
    public MetaRuleset createMetaRuleset(Class type) {
        Util.notNull("type", type);
        MetaRuleset m = new MetaRulesetImpl(this.owner.getTag(), type);
        m = m.ignore("event");
        return m.ignore("binding").ignore("for");
    }

    @Override
    public String getFor() {
        String result = null;
        TagAttribute attr = this.owner.getTagAttribute("for");
        if (null != attr) {
            result = attr.getValue();
        }
        return result;
    }

    private String getEventName(ClientBehaviorHolder holder) {
        String eventName = null != this.owner.getEvent() ? this.owner.getEvent().getValue() : holder.getDefaultEventName();
        if (null == eventName) {
            throw new TagException(this.owner.getTag(), "The event name is not defined");
        }
        return eventName;
    }
}

