/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.managed;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ObjectInputStreamFiltered;
import org.apache.openejb.core.managed.PassivationStrategy;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class SimplePassivater
implements PassivationStrategy {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private File sessionDirectory;

    public SimplePassivater() throws SystemException {
        this.init(null);
    }

    @Override
    public void init(Properties props) throws SystemException {
        if (props == null) {
            props = new Properties();
        }
        String dir = props.getProperty("org/openejb/core/InstanceManager/PASSIVATOR_PATH_PREFIX");
        try {
            this.sessionDirectory = dir != null ? SystemInstance.get().getBase().getDirectory(dir).getAbsoluteFile() : new File(JavaSecurityManagers.getSystemProperty("java.io.tmpdir", File.separator + "tmp")).getAbsoluteFile();
            if (!this.sessionDirectory.exists() && !this.sessionDirectory.mkdirs()) {
                throw new IOException("Failed to create directory: " + this.sessionDirectory.getAbsolutePath());
            }
            logger.info("Using directory " + String.valueOf(this.sessionDirectory) + " for stateful session passivation");
        }
        catch (IOException e) {
            throw new SystemException(this.getClass().getName() + ".init(): can't use directory prefix " + dir + ":" + String.valueOf(e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate(Object primaryKey, Object state) throws SystemException {
        try {
            String filename = primaryKey.toString().replace(':', '=');
            File sessionFile = new File(this.sessionDirectory, filename);
            if (!sessionFile.exists() && !sessionFile.createNewFile()) {
                throw new Exception("Failed to create passivation file: " + sessionFile.getAbsolutePath());
            }
            logger.info("Passivating to file " + String.valueOf(sessionFile));
            try (OutputStream os = IO.write(sessionFile);
                 ObjectOutputStream oos = new ObjectOutputStream(os);){
                oos.writeObject(state);
            }
            finally {
                sessionFile.deleteOnExit();
            }
        }
        catch (NotSerializableException nse) {
            logger.error("Passivation failed ", nse);
            throw (SystemException)new SystemException("The type " + nse.getMessage() + " is not serializable as mandated by the EJB specification.").initCause(nse);
        }
        catch (Exception t) {
            logger.error("Passivation failed ", t);
            throw new SystemException(t);
        }
    }

    @Override
    public void passivate(Map hash) throws SystemException {
        for (Map.Entry o : hash.entrySet()) {
            this.passivate(o.getKey(), o.getValue());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object activate(Object primaryKey) throws SystemException {
        try {
            String filename = primaryKey.toString().replace(':', '=');
            File sessionFile = new File(this.sessionDirectory, filename);
            if (sessionFile.exists()) {
                logger.info("Activating from file " + String.valueOf(sessionFile));
                try (InputStream source = IO.read(sessionFile);){
                    Object object;
                    try (ObjectInputStreamFiltered ois = new ObjectInputStreamFiltered(source);){
                        Object state = ois.readObject();
                        if (!sessionFile.delete()) {
                            sessionFile.deleteOnExit();
                        }
                        object = state;
                    }
                    return object;
                }
            }
            logger.info("Activation failed: file not found " + String.valueOf(sessionFile));
            return null;
        }
        catch (Exception t) {
            logger.info("Activation failed ", t);
            throw new SystemException(t);
        }
    }
}

