/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.csp;

import org.apache.wicket.csp.CSPRenderable;
import org.apache.wicket.csp.ContentSecurityPolicySettings;
import org.apache.wicket.request.cycle.RequestCycle;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CSPDirectiveSrcValue implements CSPRenderable
{
    NONE("'none'"),
    WILDCARD("*"),
    SELF("'self'"),
    UNSAFE_INLINE("'unsafe-inline'"),
    UNSAFE_EVAL("'unsafe-eval'"),
    STRICT_DYNAMIC("'strict-dynamic'"),
    NONCE("'nonce-%1$s'"){

        @Override
        public String render(ContentSecurityPolicySettings settings, RequestCycle cycle) {
            return String.format(this.getValue(), settings.getNonce(cycle));
        }
    };

    private final String value;

    private CSPDirectiveSrcValue(String value) {
        this.value = value;
    }

    @Override
    public String render(ContentSecurityPolicySettings settings, RequestCycle cycle) {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }
}

