/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketParseException;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.internal.Enclosure;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.string.Strings;

public final class EnclosureHandler
extends AbstractMarkupFilter
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private static final ComponentTag.IAutoComponentFactory FACTORY = new ComponentTag.IAutoComponentFactory(){

        @Override
        public Component newComponent(MarkupContainer container, ComponentTag tag) {
            return new Enclosure(tag.getId(), tag.getAttribute(EnclosureHandler.CHILD_ATTRIBUTE));
        }
    };
    public static final String ENCLOSURE = "enclosure";
    public static final String CHILD_ATTRIBUTE = "child";
    private Deque<ComponentTag> stack;
    private String childId;

    public EnclosureHandler() {
        this(null);
    }

    public EnclosureHandler(MarkupResourceStream resourceStream) {
        super(resourceStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        boolean isEnclosureTag;
        boolean isWicketTag = tag instanceof WicketTag;
        boolean bl = isEnclosureTag = isWicketTag && ((WicketTag)tag).isEnclosureTag();
        if (isEnclosureTag) {
            if (tag.isOpen()) {
                tag.setId(tag.getId() + this.getRequestUniqueId());
                tag.setModified(true);
                tag.setAutoComponentFactory(FACTORY);
                if (this.stack == null) {
                    this.stack = new ArrayDeque<ComponentTag>();
                }
                this.stack.push(tag);
                return tag;
            } else {
                if (!tag.isClose()) throw new WicketParseException("Open-close tag not allowed for Enclosure:", tag);
                if (this.stack == null) {
                    throw new WicketParseException("Missing open tag for Enclosure:", tag);
                }
                ComponentTag lastEnclosure = this.stack.pop();
                if (this.childId != null) {
                    lastEnclosure.put(CHILD_ATTRIBUTE, this.childId);
                    lastEnclosure.setModified(true);
                    this.childId = null;
                }
                if (this.stack.size() != 0) return tag;
                this.stack = null;
            }
            return tag;
        } else {
            String id;
            ComponentTag lastEnclosure;
            if (this.stack == null || !Strings.isEmpty((String)(lastEnclosure = this.stack.getFirst()).getAttribute(CHILD_ATTRIBUTE)) || (id = tag.getAttribute(this.getWicketNamespace() + ":id")) == null) return tag;
            if (this.childId != null) {
                throw new WicketParseException("Use <" + this.getWicketNamespace() + ":enclosure child='xxx'> to name the child component:", tag);
            }
            this.childId = id;
        }
        return tag;
    }

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag instanceof WicketTag && ((WicketTag)tag).isEnclosureTag()) {
            return new Enclosure(tag.getId(), tag.getAttribute(CHILD_ATTRIBUTE));
        }
        return null;
    }
}

