/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.bean.validation;

import jakarta.validation.Validator;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ConstraintDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.wicket.bean.validation.Property;

class ConstraintIterator
implements Iterator<ConstraintDescriptor<?>> {
    private ConstraintDescriptor<?> next;
    private List<Iterator<ConstraintDescriptor<?>>> stack = new ArrayList();

    public ConstraintIterator(Validator validator, Property property, Class<?> ... groups) {
        Set constraints;
        PropertyDescriptor propDesc;
        BeanDescriptor beanDesc = validator.getConstraintsForClass(property.getOwner());
        if (beanDesc != null && (propDesc = beanDesc.getConstraintsForProperty(property.getName())) != null && (constraints = propDesc.findConstraints().unorderedAndMatchingGroups((Class[])groups).getConstraintDescriptors()) != null) {
            this.stack.add(constraints.iterator());
            this.findNext();
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void findNext() {
        this.next = null;
        while (!this.stack.isEmpty()) {
            Iterator<ConstraintDescriptor<?>> top = this.stack.get(this.stack.size() - 1);
            if (top.hasNext()) {
                this.next = top.next();
                Set composing = this.next.getComposingConstraints();
                if (composing.isEmpty()) break;
                this.stack.add(composing.iterator());
                break;
            }
            this.stack.remove(this.stack.size() - 1);
        }
    }

    @Override
    public ConstraintDescriptor<?> next() {
        ConstraintDescriptor<?> ret = this.next;
        this.findNext();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

