/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request;

import java.util.Locale;
import org.apache.wicket.core.request.ClientInfo;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.cycle.RequestCycle;

public class WebClientInfo
extends ClientInfo {
    private static final long serialVersionUID = 1L;
    private final String userAgent;
    private final ClientProperties properties;

    public WebClientInfo(RequestCycle requestCycle) {
        this(requestCycle, new ClientProperties());
    }

    public WebClientInfo(RequestCycle requestCycle, ClientProperties properties) {
        this(requestCycle, ((ServletWebRequest)requestCycle.getRequest()).getContainerRequest().getHeader("User-Agent"), properties);
    }

    public WebClientInfo(RequestCycle requestCycle, String userAgent) {
        this(requestCycle, userAgent, new ClientProperties());
    }

    public WebClientInfo(RequestCycle requestCycle, String userAgent, ClientProperties properties) {
        this.userAgent = userAgent;
        this.properties = properties;
        properties.setRemoteAddress(this.getRemoteAddr(requestCycle));
    }

    public final ClientProperties getProperties() {
        return this.properties;
    }

    public final String getUserAgent() {
        return this.userAgent;
    }

    private String getUserAgentStringLc() {
        return this.getUserAgent() != null ? this.getUserAgent().toLowerCase(Locale.ROOT) : "";
    }

    protected String getRemoteAddr(RequestCycle requestCycle) {
        ServletWebRequest request = (ServletWebRequest)requestCycle.getRequest();
        return request.getContainerRequest().getRemoteAddr();
    }
}

