/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.time;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.StringValueConversionException;
import org.apache.wicket.util.thread.ICode;
import org.apache.wicket.util.time.AbstractTimeValue;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;

@Deprecated
public class Duration
extends AbstractTimeValue {
    private static final long serialVersionUID = 1L;
    public static final Duration MAXIMUM = Duration.milliseconds(Long.MAX_VALUE);
    public static final Duration NONE = Duration.milliseconds(0L);
    public static final Duration ONE_DAY = Duration.days(1);
    public static final Duration ONE_HOUR = Duration.hours(1);
    public static final Duration ONE_MINUTE = Duration.minutes(1);
    public static final Duration ONE_SECOND = Duration.seconds(1);
    public static final Duration ONE_WEEK = Duration.days(7);
    private static final Pattern pattern = Pattern.compile("([0-9]+([.,][0-9]+)?)\\s+(millisecond|second|minute|hour|day)s?", 2);

    public static Duration benchmark(ICode code, Logger log) {
        Time start = Time.now();
        code.run(log);
        return Time.now().subtract(start);
    }

    public static Duration benchmark(Runnable code) {
        Time start = Time.now();
        code.run();
        return Time.now().subtract(start);
    }

    public static Duration days(double days) {
        return Duration.hours(24.0 * days);
    }

    public static Duration days(int days) {
        return Duration.hours(24 * days);
    }

    public static Duration elapsed(Time start) {
        return start.elapsedSince();
    }

    public static Duration hours(double hours) {
        return Duration.minutes(60.0 * hours);
    }

    public static Duration hours(int hours) {
        return Duration.minutes(60 * hours);
    }

    public static Duration milliseconds(double milliseconds) {
        return Duration.milliseconds(Math.round(milliseconds));
    }

    public static Duration milliseconds(long milliseconds) {
        return new Duration(milliseconds);
    }

    public static Duration minutes(double minutes) {
        return Duration.seconds(60.0 * minutes);
    }

    public static Duration minutes(int minutes) {
        return Duration.seconds(60 * minutes);
    }

    public static Duration seconds(double seconds) {
        return Duration.milliseconds(seconds * 1000.0);
    }

    public static Duration seconds(int seconds) {
        return Duration.milliseconds((long)seconds * 1000L);
    }

    public static Duration valueOf(long time) {
        return new Duration(time);
    }

    public static Duration valueOf(String string) throws StringValueConversionException {
        return Duration.valueOf(string, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static Duration valueOf(String string, Locale locale) throws StringValueConversionException {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            double value = StringValue.valueOf(matcher.group(1), locale).toDouble();
            String units = matcher.group(3);
            if (units.equalsIgnoreCase("millisecond")) {
                return Duration.milliseconds(value);
            }
            if (units.equalsIgnoreCase("second")) {
                return Duration.seconds(value);
            }
            if (units.equalsIgnoreCase("minute")) {
                return Duration.minutes(value);
            }
            if (units.equalsIgnoreCase("hour")) {
                return Duration.hours(value);
            }
            if (units.equalsIgnoreCase("day")) {
                return Duration.days(value);
            }
            throw new StringValueConversionException("Unrecognized units: " + string);
        }
        throw new StringValueConversionException("Unable to parse duration: " + string);
    }

    protected Duration(long milliseconds) {
        super(milliseconds);
    }

    public Duration add(Duration duration) {
        return Duration.valueOf(this.getMilliseconds() + duration.getMilliseconds());
    }

    public final double days() {
        return this.hours() / 24.0;
    }

    public final double hours() {
        return this.minutes() / 60.0;
    }

    public final double minutes() {
        return this.seconds() / 60.0;
    }

    public final double seconds() {
        return (double)this.getMilliseconds() / 1000.0;
    }

    public final void sleep() {
        if (this.getMilliseconds() > 0L) {
            try {
                Thread.sleep(this.getMilliseconds());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Duration subtract(Duration that) {
        return Duration.valueOf(this.getMilliseconds() - that.getMilliseconds());
    }

    public void wait(Object object) {
        try {
            object.wait(this.getMilliseconds());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault(Locale.Category.FORMAT));
    }

    public String toString(Locale locale) {
        if (this.getMilliseconds() >= 0L) {
            if (this.days() >= 1.0) {
                return this.unitString(this.days(), "day", locale);
            }
            if (this.hours() >= 1.0) {
                return this.unitString(this.hours(), "hour", locale);
            }
            if (this.minutes() >= 1.0) {
                return this.unitString(this.minutes(), "minute", locale);
            }
            if (this.seconds() >= 1.0) {
                return this.unitString(this.seconds(), "second", locale);
            }
            return this.unitString(this.getMilliseconds(), "millisecond", locale);
        }
        return "N/A";
    }

    public java.time.Duration toJavaDuration() {
        return java.time.Duration.ofMillis(this.getMilliseconds());
    }

    private String unitString(double value, String units, Locale locale) {
        return String.valueOf(StringValue.valueOf(value, locale)) + " " + units + (value > 1.0 ? "s" : "");
    }
}

