/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableIconInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.output.Output;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JELIB
extends Output {
    private boolean oldRevision;
    private Version version;
    private HashMap<Setting, Object> projectSettings = new HashMap();
    private static Comparator<PortProtoId> PORTS_BY_EXTERNAL_ID = new Comparator<PortProtoId>(){

        @Override
        public int compare(PortProtoId pp1, PortProtoId pp2) {
            return TextUtils.STRING_NUMBER_ORDER.compare(pp1.externalId, pp2.externalId);
        }
    };

    JELIB() {
    }

    protected boolean writeLib(Snapshot snapshot, LibId libId, Map<LibId, URL> libFiles, boolean oldRevision) {
        this.oldRevision = oldRevision;
        this.version = oldRevision ? Version.parseVersion("8.03") : Version.getVersion();
        this.writeTheLibrary(snapshot, libId);
        return false;
    }

    private void writeTheLibrary(Snapshot snapshot, LibId libId) {
        LibraryBackup libBackup = snapshot.getLib(libId);
        HashSet<CellId> usedCells = new HashSet<CellId>();
        TreeMap<CellName, CellRevision> sortedCells = new TreeMap<CellName, CellRevision>();
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null) continue;
            CellRevision cellRevision = cellBackup.cellRevision;
            if (cellRevision.d.getLibId() != libId) continue;
            CellId cellId = cellRevision.d.cellId;
            sortedCells.put(cellId.cellName, cellRevision);
            int[] instCounts = cellRevision.getInstCounts();
            for (int i = 0; i < instCounts.length; ++i) {
                int instCount = instCounts[i];
                if (instCount == 0) continue;
                CellUsage u = cellId.getUsageIn(i);
                usedCells.add(u.protoId);
            }
        }
        HashSet<LibId> usedLibs = new HashSet<LibId>();
        for (CellId cellId : usedCells) {
            usedLibs.add(cellId.libId);
        }
        this.printWriter.println("# header information:");
        this.printWriter.print("H" + JELIB.convertString(libBackup.d.libId.libName) + "|" + this.version);
        this.printlnVars(libBackup.d);
        boolean viewHeaderPrinted = false;
        HashSet<View> usedViews = new HashSet<View>();
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null) continue;
            CellRevision cellRevision = cellBackup.cellRevision;
            if (cellRevision.d.getLibId() != libId && !usedCells.contains(cellRevision.d.cellId)) continue;
            usedViews.add(cellRevision.d.cellId.cellName.getView());
        }
        Iterator<View> it = View.getViews();
        while (it.hasNext()) {
            View view = it.next();
            if (!usedViews.contains(view)) continue;
            if (!viewHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# Views:");
                viewHeaderPrinted = true;
            }
            this.printWriter.println("V" + JELIB.convertString(view.getFullName()) + "|" + JELIB.convertString(view.getAbbreviation()));
        }
        this.writeExternalLibraryInfo(libId, usedLibs);
        Map<Setting, Object> snapshotSettings = snapshot.getSettings();
        boolean toolHeaderPrinted = false;
        Iterator<Tool> it2 = Tool.getTools();
        while (it2.hasNext()) {
            Tool tool = it2.next();
            Map<Setting, Object> settings = tool.getProjectSettings().getDiskSettings(snapshotSettings);
            if (settings.isEmpty()) continue;
            if (!toolHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# Tools:");
                toolHeaderPrinted = true;
            }
            this.printWriter.print("O" + JELIB.convertString(tool.getName()));
            this.printlnSettings(settings);
        }
        boolean technologyHeaderPrinted = false;
        Iterator<Technology> it3 = Technology.getTechnologies();
        while (it3.hasNext()) {
            Technology tech = it3.next();
            Map<Setting, Object> settings = tech.getProjectSettings().getDiskSettings(snapshotSettings);
            if (settings.isEmpty()) continue;
            if (!technologyHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# Technologies:");
                technologyHeaderPrinted = true;
            }
            this.printWriter.print("T" + JELIB.convertString(tech.getTechName()));
            this.printlnSettings(settings);
        }
        ArrayList<CellRevision> sortedCellsList = new ArrayList<CellRevision>(sortedCells.values());
        snapshot.techPool.correctSizesToDisk(sortedCellsList, this.version, this.projectSettings, true, false);
        for (CellRevision cellRevision : sortedCellsList) {
            this.writeCell(cellRevision);
        }
    }

    void writeCell(CellRevision cellRevision) {
        ImmutableCell d = cellRevision.d;
        LibId libId = d.getLibId();
        this.printWriter.println();
        this.printWriter.println("# Cell " + d.cellId.cellName);
        this.printWriter.print("C" + JELIB.convertString(d.cellId.cellName.toString()));
        if (!this.oldRevision) {
            this.printWriter.print("|");
            String cellGroupName = d.groupName.getName();
            if (!cellGroupName.equals(d.cellId.cellName.getName())) {
                this.printWriter.print(JELIB.convertString(cellGroupName));
            }
        }
        this.printWriter.print("|" + JELIB.convertString(d.techId.techName));
        this.printWriter.print("|" + d.creationDate);
        this.printWriter.print("|" + d.revisionDate);
        StringBuilder cellBits = new StringBuilder();
        if ((d.flags & 0x400000) != 0) {
            cellBits.append("C");
        }
        if ((d.flags & 2) != 0 || d.cellId.isIcon()) {
            cellBits.append("E");
        }
        if ((d.flags & 0x200000) != 0) {
            cellBits.append("I");
        }
        if ((d.flags & 0x100000) != 0) {
            cellBits.append("L");
        }
        if ((d.flags & 0x800000) != 0) {
            cellBits.append("T");
        }
        this.printWriter.print("|" + cellBits.toString());
        this.printlnVars(d);
        ArrayList<String> nodeNames = new ArrayList<String>();
        Name prevNodeName = null;
        int duplicate = 0;
        for (ImmutableNodeInst n : cellRevision.nodes) {
            byte ts;
            int angle;
            String diskNodeName;
            NodeProtoId np = n.protoId;
            if (np instanceof CellId) {
                CellId subCellId = (CellId)np;
                String subCellName = subCellId.libId == libId ? subCellId.cellName.toString() : subCellId.toString();
                this.printWriter.print("I" + JELIB.convertString(subCellName));
            } else {
                PrimitiveNodeId primId = (PrimitiveNodeId)np;
                if (d.techId == primId.techId) {
                    this.printWriter.print("N" + JELIB.convertString(primId.name));
                } else {
                    this.printWriter.print("N" + JELIB.convertString(primId.fullName));
                }
            }
            if (n.name != prevNodeName) {
                prevNodeName = n.name;
                duplicate = 0;
                diskNodeName = JELIB.convertString(n.name.toString());
            } else {
                diskNodeName = "\"" + JELIB.convertQuotedString(n.name.toString()) + "\"" + ++duplicate;
            }
            int nodeId = n.nodeId;
            while (nodeId >= nodeNames.size()) {
                nodeNames.add(null);
            }
            nodeNames.set(nodeId, diskNodeName);
            this.printWriter.print("|" + diskNodeName + "|");
            if (!n.name.isTempname()) {
                this.printWriter.print(this.describeDescriptor(n.nameDescriptor));
            }
            this.printWriter.print("|" + TextUtils.formatDouble(n.anchor.getX(), 0));
            this.printWriter.print("|" + TextUtils.formatDouble(n.anchor.getY(), 0));
            if (!(np instanceof CellId)) {
                double lambdaWidth = n.size.getLambdaX();
                double lambdaHeight = n.size.getLambdaY();
                this.printWriter.print("|");
                if (lambdaWidth != 0.0) {
                    this.printWriter.print(TextUtils.formatDouble(lambdaWidth, 0));
                }
                this.printWriter.print("|");
                if (lambdaHeight != 0.0) {
                    this.printWriter.print(TextUtils.formatDouble(lambdaHeight, 0));
                }
            }
            this.printWriter.print('|');
            if (n.orient.isXMirrored()) {
                this.printWriter.print('X');
            }
            if (n.orient.isYMirrored()) {
                this.printWriter.print('Y');
            }
            if ((angle = n.orient.getAngle() % 3600) == 900 || angle == -2700) {
                this.printWriter.print("R");
            } else if (angle == 1800 || angle == -1800) {
                this.printWriter.print("RR");
            } else if (angle == 2700 || angle == -900) {
                this.printWriter.print("RRR");
            } else if (angle != 0) {
                this.printWriter.print(angle);
            }
            StringBuilder nodeBits = new StringBuilder();
            if (n.is(ImmutableNodeInst.HARD_SELECT)) {
                nodeBits.append("A");
            }
            if (n.is(ImmutableNodeInst.LOCKED)) {
                nodeBits.append("L");
            }
            if (n.is(ImmutableNodeInst.VIS_INSIDE)) {
                nodeBits.append("V");
            }
            if ((ts = n.techBits) != 0) {
                nodeBits.append(ts);
            }
            this.printWriter.print("|" + nodeBits.toString());
            if (np instanceof CellId) {
                String tdString = this.describeDescriptor(n.protoDescriptor);
                this.printWriter.print("|" + tdString);
            }
            this.printlnVars(n);
        }
        for (ImmutableArcInst a : cellRevision.arcs) {
            ArcProtoId apId = a.protoId;
            if (cellRevision.d.techId == apId.techId) {
                this.printWriter.print("A" + JELIB.convertString(apId.name));
            } else {
                this.printWriter.print("A" + JELIB.convertString(apId.fullName));
            }
            this.printWriter.print("|" + JELIB.convertString(a.name.toString()) + "|");
            if (!a.name.isTempname()) {
                this.printWriter.print(this.describeDescriptor(a.nameDescriptor));
            }
            long arcWidth = a.getGridExtendOverMin() * 2L;
            this.printWriter.print("|");
            if (arcWidth != 0L) {
                this.printWriter.print(TextUtils.formatDouble(DBMath.gridToLambda(arcWidth), 0));
            }
            StringBuilder arcBits = new StringBuilder();
            if (a.is(ImmutableArcInst.HARD_SELECT)) {
                arcBits.append("A");
            }
            if (a.is(ImmutableArcInst.BODY_ARROWED)) {
                arcBits.append("B");
            }
            if (!a.is(ImmutableArcInst.FIXED_ANGLE)) {
                arcBits.append("F");
            }
            if (a.is(ImmutableArcInst.HEAD_NEGATED)) {
                arcBits.append("G");
            }
            if (!a.is(ImmutableArcInst.HEAD_EXTENDED)) {
                arcBits.append("I");
            }
            if (!a.is(ImmutableArcInst.TAIL_EXTENDED)) {
                arcBits.append("J");
            }
            if (a.is(ImmutableArcInst.TAIL_NEGATED)) {
                arcBits.append("N");
            }
            if (a.is(ImmutableArcInst.RIGID)) {
                arcBits.append("R");
            }
            if (a.is(ImmutableArcInst.SLIDABLE)) {
                arcBits.append("S");
            }
            if (a.is(ImmutableArcInst.HEAD_ARROWED)) {
                arcBits.append("X");
            }
            if (a.is(ImmutableArcInst.TAIL_ARROWED)) {
                arcBits.append("Y");
            }
            this.printWriter.print("|" + arcBits.toString() + a.getAngle());
            this.printWriter.print("|" + (String)nodeNames.get(a.headNodeId) + "|" + this.getPortName(a.headPortId));
            this.printWriter.print("|" + TextUtils.formatDouble(a.headLocation.getX(), 0));
            this.printWriter.print("|" + TextUtils.formatDouble(a.headLocation.getY(), 0));
            this.printWriter.print("|" + (String)nodeNames.get(a.tailNodeId) + "|" + this.getPortName(a.tailPortId));
            this.printWriter.print("|" + TextUtils.formatDouble(a.tailLocation.getX(), 0));
            this.printWriter.print("|" + TextUtils.formatDouble(a.tailLocation.getY(), 0));
            this.printlnVars(a);
        }
        for (ImmutableExport e : cellRevision.exports) {
            this.printWriter.print("E" + JELIB.convertString(e.exportId.externalId));
            if (!this.oldRevision) {
                this.printWriter.print("|");
                if (!e.name.toString().equals(e.exportId.externalId)) {
                    this.printWriter.print(JELIB.convertString(e.name.toString()));
                }
            }
            this.printWriter.print("|" + this.describeDescriptor(e.nameDescriptor));
            this.printWriter.print("|" + (String)nodeNames.get(e.originalNodeId) + "|" + this.getPortName(e.originalPortId));
            this.printWriter.print("|" + e.characteristic.getShortName());
            if (e.alwaysDrawn) {
                this.printWriter.print("/A");
            }
            if (e.bodyOnly) {
                this.printWriter.print("/B");
            }
            this.printlnVars(e);
        }
        this.printWriter.println("X");
    }

    void writeExternalLibraryInfo(LibId thisLib, Set<LibId> usedLibs) {
        boolean libraryHeaderPrinted = false;
        TreeMap<String, LibId> sortedLibraries = new TreeMap<String, LibId>(TextUtils.STRING_NUMBER_ORDER);
        for (LibId libId : usedLibs) {
            sortedLibraries.put(libId.libName, libId);
        }
        for (LibId libId : sortedLibraries.values()) {
            if (libId == thisLib) continue;
            if (!libraryHeaderPrinted) {
                this.printWriter.println();
                this.printWriter.println("# External Libraries:");
                libraryHeaderPrinted = true;
            }
            String libFile = libId.libName;
            this.printWriter.println();
            this.printWriter.println("L" + JELIB.convertString(libId.libName) + "|" + JELIB.convertString(libFile));
        }
    }

    private String describeDescriptor(TextDescriptor td) {
        return JELIB.describeDescriptor(null, td, false);
    }

    public static String describeDescriptor(Variable var, TextDescriptor td, boolean isParam) {
        AbstractTextDescriptor.Unit unit;
        StringBuilder ret = new StringBuilder();
        AbstractTextDescriptor.Display display = td.getDisplay();
        if (var == null) {
            display = AbstractTextDescriptor.Display.SHOWN;
        }
        if (display != AbstractTextDescriptor.Display.NONE) {
            int color;
            AbstractTextDescriptor.Size size = td.getSize();
            if (size.isAbsolute()) {
                ret.append("A" + (int)size.getSize() + ";");
            }
            if (td.isBold()) {
                ret.append("B");
            }
            if ((color = td.getColorIndex()) != 0) {
                ret.append("C" + color + ";");
            }
            ret.append(display == AbstractTextDescriptor.Display.SHOWN ? "D" : "d");
            AbstractTextDescriptor.Position pos = td.getPos();
            if (pos == AbstractTextDescriptor.Position.UP) {
                ret.append("8");
            } else if (pos == AbstractTextDescriptor.Position.DOWN) {
                ret.append("2");
            } else if (pos == AbstractTextDescriptor.Position.LEFT) {
                ret.append("4");
            } else if (pos == AbstractTextDescriptor.Position.RIGHT) {
                ret.append("6");
            } else if (pos == AbstractTextDescriptor.Position.UPLEFT) {
                ret.append("7");
            } else if (pos == AbstractTextDescriptor.Position.UPRIGHT) {
                ret.append("9");
            } else if (pos == AbstractTextDescriptor.Position.DOWNLEFT) {
                ret.append("1");
            } else if (pos == AbstractTextDescriptor.Position.DOWNRIGHT) {
                ret.append("3");
            } else if (pos == AbstractTextDescriptor.Position.BOXED) {
                ret.append("0");
            } else {
                ret.append("5");
            }
            int font = td.getFace();
            if (font != 0) {
                AbstractTextDescriptor.ActiveFont af = AbstractTextDescriptor.ActiveFont.findActiveFont(font);
                ret.append("F" + JELIB.convertString(af.toString()) + ";");
            }
            if (!size.isAbsolute()) {
                ret.append("G" + TextUtils.formatDouble(size.getSize()) + ";");
            }
        }
        if (td.isInherit()) {
            ret.append("H");
        }
        if (display != AbstractTextDescriptor.Display.NONE) {
            AbstractTextDescriptor.DispPos dispPos;
            if (td.isItalic()) {
                ret.append("I");
            }
            if (td.isUnderline()) {
                ret.append("L");
            }
            if ((dispPos = td.getDispPart()) == AbstractTextDescriptor.DispPos.NAMEVALUE) {
                ret.append("N");
            }
        }
        if (var != null) {
            switch (var.getCode()) {
                case JAVA: {
                    ret.append("OJ");
                    break;
                }
                case SPICE: {
                    ret.append("OL");
                    break;
                }
                case TCL: {
                    ret.append("OT");
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (isParam) {
            ret.append("P");
        }
        if (display != AbstractTextDescriptor.Display.NONE) {
            AbstractTextDescriptor.Rotation rot = td.getRotation();
            if (rot == AbstractTextDescriptor.Rotation.ROT90) {
                ret.append("R");
            } else if (rot == AbstractTextDescriptor.Rotation.ROT180) {
                ret.append("RR");
            } else if (rot == AbstractTextDescriptor.Rotation.ROT270) {
                ret.append("RRR");
            }
        }
        if (td.isInterior()) {
            ret.append("T");
        }
        if ((unit = td.getUnit()) == AbstractTextDescriptor.Unit.RESISTANCE) {
            ret.append("UR");
        } else if (unit == AbstractTextDescriptor.Unit.CAPACITANCE) {
            ret.append("UC");
        } else if (unit == AbstractTextDescriptor.Unit.INDUCTANCE) {
            ret.append("UI");
        } else if (unit == AbstractTextDescriptor.Unit.CURRENT) {
            ret.append("UA");
        } else if (unit == AbstractTextDescriptor.Unit.VOLTAGE) {
            ret.append("UV");
        } else if (unit == AbstractTextDescriptor.Unit.DISTANCE) {
            ret.append("UD");
        } else if (unit == AbstractTextDescriptor.Unit.TIME) {
            ret.append("UT");
        }
        if (display != AbstractTextDescriptor.Display.NONE) {
            double offY;
            double offX = td.getXOff();
            if (offX != 0.0) {
                ret.append("X" + TextUtils.formatDouble(offX, 0) + ";");
            }
            if ((offY = td.getYOff()) != 0.0) {
                ret.append("Y" + TextUtils.formatDouble(offY, 0) + ";");
            }
        }
        return ret.toString();
    }

    private void printlnVars(ImmutableElectricObject d) {
        if (d instanceof ImmutableNodeInst) {
            if (d instanceof ImmutableIconInst) {
                Iterator<Variable> it = ((ImmutableIconInst)d).getDefinedParameters();
                while (it.hasNext()) {
                    this.printVar(null, it.next());
                }
            }
            ImmutableNodeInst nid = (ImmutableNodeInst)d;
            this.printVars(null, nid);
            if (nid.hasPortInstVariables()) {
                ArrayList<PortProtoId> portsWithVariables = new ArrayList<PortProtoId>();
                Iterator<PortProtoId> it = nid.getPortsWithVariables();
                while (it.hasNext()) {
                    portsWithVariables.add(it.next());
                }
                Collections.sort(portsWithVariables, PORTS_BY_EXTERNAL_ID);
                for (PortProtoId portProtoId : portsWithVariables) {
                    this.printVars(portProtoId.externalId, nid.getPortInst(portProtoId));
                }
            }
        } else {
            if (d instanceof ImmutableCell) {
                Iterator<Variable> it = ((ImmutableCell)d).getParameters();
                while (it.hasNext()) {
                    this.printVar(null, it.next());
                }
            }
            this.printVars(null, d);
        }
        this.printWriter.println();
    }

    private void printVars(String portName, ImmutableElectricObject d) {
        Iterator<Variable> it = d.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            this.printVar(portName, var);
        }
    }

    private void printVar(String portName, Variable var) {
        Object varObj = var.getObject();
        TextDescriptor td = var.getTextDescriptor();
        boolean isParam = td.isParam();
        String tdString = JELIB.describeDescriptor(var, td, isParam);
        this.printWriter.print("|" + this.convertVariableName(this.diskName(portName, var)) + "(" + tdString + ")");
        String pt = this.makeString(varObj);
        if (pt == null) {
            pt = "";
        }
        this.printWriter.print(pt);
    }

    private void printlnSettings(Map<Setting, Object> settings) {
        for (Map.Entry<Setting, Object> e : settings.entrySet()) {
            Setting setting = e.getKey();
            Object value = e.getValue();
            this.projectSettings.put(setting, value);
            this.printWriter.print("|" + this.convertVariableName(setting.getPrefName()) + "()" + this.makeString(value));
        }
        this.printWriter.println();
    }

    private String makeString(Object obj) {
        StringBuffer infstr = new StringBuffer();
        char type = this.getVarType(obj);
        infstr.append(type);
        if (obj instanceof Object[]) {
            Object[] objArray = (Object[])obj;
            int len = objArray.length;
            infstr.append('[');
            for (int i = 0; i < len; ++i) {
                Object oneObj = objArray[i];
                if (i != 0) {
                    infstr.append(',');
                }
                this.makeStringVar(infstr, type, oneObj, true);
            }
            infstr.append(']');
        } else {
            this.makeStringVar(infstr, type, obj, false);
        }
        return infstr.toString();
    }

    private void makeStringVar(StringBuffer infstr, char type, Object obj, boolean inArray) {
        if (obj == null) {
            return;
        }
        switch (type) {
            case 'B': {
                infstr.append((Boolean)obj != false ? (char)'T' : 'F');
                return;
            }
            case 'C': {
                infstr.append(this.convertString(((CellId)obj).toString(), inArray));
                return;
            }
            case 'D': {
                infstr.append((Double)obj);
                return;
            }
            case 'E': {
                infstr.append(this.convertString(((ExportId)obj).toString(), inArray));
                return;
            }
            case 'F': {
                infstr.append(((Float)obj).floatValue());
                return;
            }
            case 'G': {
                infstr.append((Long)obj);
                return;
            }
            case 'H': {
                infstr.append(((Short)obj).shortValue());
                return;
            }
            case 'I': {
                infstr.append((Integer)obj);
                return;
            }
            case 'L': {
                infstr.append(this.convertString(((LibId)obj).libName, inArray));
                return;
            }
            case 'O': {
                infstr.append(this.convertString(((Tool)obj).getName(), inArray));
                return;
            }
            case 'P': {
                infstr.append(this.convertString(((PrimitiveNodeId)obj).fullName, inArray));
                return;
            }
            case 'R': {
                infstr.append(this.convertString(((ArcProtoId)obj).fullName, inArray));
                return;
            }
            case 'S': {
                infstr.append(this.convertString(obj.toString(), inArray));
                return;
            }
            case 'T': {
                infstr.append(this.convertString(((TechId)obj).techName, inArray));
                return;
            }
            case 'V': {
                EPoint pt2 = (EPoint)obj;
                infstr.append(TextUtils.formatDouble(pt2.getX(), 0) + "/" + TextUtils.formatDouble(pt2.getY(), 0));
                return;
            }
            case 'Y': {
                infstr.append(((Byte)obj).byteValue());
                return;
            }
        }
    }

    private String getPortName(PortProtoId portId) {
        String externalId = portId.externalId;
        if (externalId.length() > 0) {
            externalId = JELIB.convertString(externalId);
        }
        return externalId;
    }

    private char getVarType(Object obj) {
        if (obj instanceof String || obj instanceof String[]) {
            return 'S';
        }
        if (obj instanceof CodeExpression) {
            return 'S';
        }
        if (obj instanceof Boolean || obj instanceof Boolean[]) {
            return 'B';
        }
        if (obj instanceof CellId || obj instanceof CellId[]) {
            return 'C';
        }
        if (obj instanceof Double || obj instanceof Double[]) {
            return 'D';
        }
        if (obj instanceof ExportId || obj instanceof ExportId[]) {
            return 'E';
        }
        if (obj instanceof Float || obj instanceof Float[]) {
            return 'F';
        }
        if (obj instanceof Long || obj instanceof Long[]) {
            return 'G';
        }
        if (obj instanceof Short || obj instanceof Short[]) {
            return 'H';
        }
        if (obj instanceof Integer || obj instanceof Integer[]) {
            return 'I';
        }
        if (obj instanceof LibId || obj instanceof LibId[]) {
            return 'L';
        }
        if (obj instanceof Tool || obj instanceof Tool[]) {
            return 'O';
        }
        if (obj instanceof PrimitiveNodeId || obj instanceof PrimitiveNodeId[]) {
            return 'P';
        }
        if (obj instanceof ArcProtoId || obj instanceof ArcProtoId[]) {
            return 'R';
        }
        if (obj instanceof TechId || obj instanceof TechId[]) {
            return 'T';
        }
        if (obj instanceof EPoint || obj instanceof EPoint[]) {
            return 'V';
        }
        if (obj instanceof Byte || obj instanceof Byte[]) {
            return 'Y';
        }
        throw new AssertionError();
    }

    private static String convertQuotedString(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\n') {
                infstr.append("\\n");
                continue;
            }
            if (ch == '\r') {
                infstr.append("\\r");
                continue;
            }
            if (ch == '\"' || ch == '\\') {
                infstr.append('\\');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    static String convertString(String str) {
        return JELIB.convertString(str, '\u0000', '\u0000');
    }

    private static String convertString(String str, char delim1, char delim2) {
        if (!(str.length() == 0 || str.indexOf(10) >= 0 || str.indexOf(13) >= 0 || str.indexOf(92) >= 0 || str.indexOf(34) >= 0 || str.indexOf(124) >= 0 || delim1 != '\u0000' && str.indexOf(delim1) >= 0 || delim2 != '\u0000' && str.indexOf(delim2) >= 0)) {
            return str;
        }
        return '\"' + JELIB.convertQuotedString(str) + '\"';
    }

    private String convertVariableName(String str) {
        return JELIB.convertString(str, '(', '\u0000');
    }

    private String convertString(String str, boolean inArray) {
        return inArray ? JELIB.convertString(str, ',', ']') : JELIB.convertString(str, '\u0000', '\u0000');
    }
}

