/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.ncc.netlist.NccNetlist;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.NccResults;
import com.sun.electric.tool.ncc.result.equivalence.Equivalence;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemNamesToLay {
    static final long serialVersionUID = 0L;
    private String header;
    private int numArcRenames;
    private int numNodeRenames;
    private int numArcManRenames;
    private int numNodeManRenames;
    private int numNameConflicts;

    private void printHeader() {
        if (this.header != null) {
            this.prln(this.header);
        }
        this.header = null;
    }

    private boolean isAutoGenName(String nm) {
        return nm.indexOf(64) != -1;
    }

    private void prln(String s) {
        System.out.println(s);
    }

    private void copySchematicNamesToLayout(NccResult result) {
        int schNdx;
        Equivalence equivs = result.getEquivalence();
        Cell[] rootCells = result.getRootCells();
        if (rootCells.length != 2) {
            return;
        }
        if (rootCells[0].isSchematic() && rootCells[1].getView() == View.LAYOUT) {
            schNdx = 0;
        } else if (rootCells[0].getView() == View.LAYOUT && rootCells[1].isSchematic()) {
            schNdx = 1;
        } else {
            return;
        }
        int layNdx = schNdx == 0 ? 1 : 0;
        Cell schCell = rootCells[schNdx];
        Cell layCell = rootCells[layNdx];
        VarContext schContext = result.getRootContexts()[schNdx];
        this.copySchematicNamesToLayout(schCell, layCell, schContext, equivs);
    }

    private Map<String, Network> namesToNetworks(Cell c) {
        HashMap<String, Network> nmsToNets = new HashMap<String, Network>();
        Netlist nets = c.getNetlist(NccNetlist.SHORT_RESISTORS);
        for (Network net : new For<Network>(nets.getNetworks())) {
            for (String nm : new For<String>(net.getNames())) {
                nmsToNets.put(nm, net);
            }
        }
        return nmsToNets;
    }

    private boolean reportNetNameConflicts(Network schNet, Network layNet, Map<String, Network> layNmsToNets) {
        String prefSchNm = schNet.getName();
        LayoutLib.error(this.isAutoGenName(prefSchNm), "missing preferred name");
        boolean prefNameConflict = false;
        for (String schNm : new For<String>(schNet.getNames())) {
            Network layNetWithSameName;
            if (this.isAutoGenName(schNm) || (layNetWithSameName = layNmsToNets.get(schNm)) == null || layNetWithSameName == layNet) continue;
            prefNameConflict |= schNm.equals(prefSchNm);
            this.printHeader();
            this.prln("    Schematic and layout each have a Network named: " + schNm + " but those networks don't match topologically.");
            ++this.numNameConflicts;
        }
        return prefNameConflict;
    }

    private ArcInst getLongestArc(Network net) {
        double longestDist = Double.NEGATIVE_INFINITY;
        ArcInst longest = null;
        for (ArcInst ai : new For<ArcInst>(net.getArcs())) {
            double length = ai.getGridLength();
            if (length <= longestDist) continue;
            longest = ai;
            longestDist = length;
        }
        return longest;
    }

    private List<ArcAndName> buildArcNameList(Cell schCell, Cell layCell, VarContext schCtxt, Equivalence equivs) {
        Map<String, Network> layNmsToNets = this.namesToNetworks(layCell);
        ArrayList<ArcAndName> arcAndNms = new ArrayList<ArcAndName>();
        Netlist nets = schCell.getNetlist(NccNetlist.SHORT_RESISTORS);
        for (Network schNet : new For<Network>(nets.getNetworks())) {
            String layName;
            boolean prefNameConflict;
            String schName;
            Network layNet;
            HierarchyEnumerator.NetNameProxy layProx = equivs.findEquivalentNet(schCtxt, schNet);
            if (layProx == null || (layNet = layProx.getNet()).getParent() != layCell || this.isAutoGenName(schName = schNet.getName()) || layNet.isExported() || (prefNameConflict = this.reportNetNameConflicts(schNet, layNet, layNmsToNets)) || (layName = layNet.getName()).equals(schName)) continue;
            if (!this.isAutoGenName(layName)) {
                this.printHeader();
                this.prln("    The layout Network named: " + layName + " should, instead, be named: " + schName);
                ++this.numArcManRenames;
                continue;
            }
            ArcInst ai = this.getLongestArc(layNet);
            if (ai == null) continue;
            this.printHeader();
            this.prln("    Renaming arc from: " + ai.getName() + " to: " + schName);
            arcAndNms.add(new ArcAndName(ai, schName));
            ++this.numArcRenames;
        }
        return arcAndNms;
    }

    private void renameArcs(List<ArcAndName> arcAndNms) {
        for (ArcAndName an : arcAndNms) {
            an.arc.setName(an.name);
        }
    }

    private boolean reportNodeNameConflicts(Nodable schNode, NodeInst layNode, Map<String, NodeInst> layNmsToNodes) {
        String schNm = schNode.getName();
        NodeInst ni = layNmsToNodes.get(schNm);
        if (ni == null) {
            return false;
        }
        if (ni != layNode) {
            this.printHeader();
            this.prln("    Schematic and layout each have a Nodable named: " + schNm + " but those Nodables don't match topologically.");
            ++this.numNameConflicts;
            return true;
        }
        return false;
    }

    private Map<String, NodeInst> namesToNodes(Cell c) {
        HashMap<String, NodeInst> nmsToNodes = new HashMap<String, NodeInst>();
        for (Nodable no : new For<Nodable>(c.getNodables())) {
            if (!(no instanceof NodeInst)) continue;
            nmsToNodes.put(no.getName(), (NodeInst)no);
        }
        return nmsToNodes;
    }

    private List<NodeAndName> buildNodeNameList(Cell schCell, Cell layCell, VarContext schCtxt, Equivalence equivs) {
        Map<String, NodeInst> layNmsToNodes = this.namesToNodes(layCell);
        ArrayList<NodeAndName> nodeAndNms = new ArrayList<NodeAndName>();
        for (Nodable schNode : new For<Nodable>(schCell.getNodables())) {
            String layName;
            boolean nameConflict;
            Nodable layNode;
            HierarchyEnumerator.NodableNameProxy layProx = equivs.findEquivalentNode(schCtxt, schNode);
            if (layProx == null || (layNode = layProx.getNodable()).getParent() != layCell || !(layNode instanceof NodeInst)) continue;
            NodeInst layNodeInst = (NodeInst)layNode;
            String schName = schNode.getName();
            if (this.isAutoGenName(schName) || (nameConflict = this.reportNodeNameConflicts(schNode, layNodeInst, layNmsToNodes)) || (layName = layNodeInst.getName()).equals(schName)) continue;
            if (!this.isAutoGenName(layName)) {
                this.printHeader();
                this.prln("    The layout NodeInst named: " + layName + " should, instead, be named: " + schName);
                ++this.numNodeManRenames;
                continue;
            }
            this.printHeader();
            this.prln("    Renaming NodeInst from: " + layNodeInst.getName() + " to: " + schName);
            nodeAndNms.add(new NodeAndName(layNodeInst, schName));
            ++this.numNodeRenames;
        }
        return nodeAndNms;
    }

    private void renameNodes(List<NodeAndName> nodeAndNms) {
        for (NodeAndName an : nodeAndNms) {
            an.node.setName(an.name);
        }
    }

    private void copySchematicNamesToLayout(Cell schCell, Cell layCell, VarContext schCtxt, Equivalence equivs) {
        this.header = "  Copy from: " + schCell.describe(false) + " to " + layCell.describe(false);
        if (!schCell.isSchematic()) {
            this.printHeader();
            this.prln("    First Cell isn't schematic: " + schCell.describe(false));
            return;
        }
        if (layCell.getView() != View.LAYOUT) {
            this.printHeader();
            this.prln("    Second Cell isn't layout: " + layCell.describe(false));
            return;
        }
        List<ArcAndName> arcAndNms = this.buildArcNameList(schCell, layCell, schCtxt, equivs);
        List<NodeAndName> nodeAndNms = this.buildNodeNameList(schCell, layCell, schCtxt, equivs);
        this.renameArcs(arcAndNms);
        this.renameNodes(nodeAndNms);
    }

    private SchemNamesToLay(NccResults results) {
        this.prln("Begin copying Network and Instance names from Schematic to Layout");
        if (results == null) {
            this.prln("  No saved NCC results. Please run NCC first.");
            return;
        }
        EDatabase database = EDatabase.currentDatabase();
        HashMap<CellId, NccResult> resultsByLayout = new HashMap<CellId, NccResult>();
        for (NccResult r : results) {
            Cell layout = r.getRootLayoutCell();
            if (layout == null) continue;
            assert (layout.getDatabase() == database);
            resultsByLayout.put(layout.getId(), r);
        }
        ArrayList<NccResult> resultsTopDown = new ArrayList<NccResult>();
        for (CellId cellId : database.backup().getCellsDownTop()) {
            NccResult r = (NccResult)resultsByLayout.get(cellId);
            if (r == null) continue;
            resultsTopDown.add(r);
        }
        Collections.reverse(resultsTopDown);
        for (NccResult r : resultsTopDown) {
            if (!r.match()) continue;
            this.copySchematicNamesToLayout(r);
        }
        this.prln("Done");
    }

    RenameResult getResult() {
        return new RenameResult(this.numArcRenames, this.numNodeRenames, this.numArcManRenames, this.numNodeManRenames, this.numNameConflicts);
    }

    public static RenameResult copyNames(NccResults r) {
        SchemNamesToLay sntl = new SchemNamesToLay(r);
        return sntl.getResult();
    }

    private static class NodeAndName {
        public final NodeInst node;
        public final String name;

        NodeAndName(NodeInst no, String na) {
            this.node = no;
            this.name = na;
        }
    }

    private static class ArcAndName {
        public final ArcInst arc;
        public final String name;

        ArcAndName(ArcInst a, String n) {
            this.arc = a;
            this.name = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class For<T>
    implements Iterable<T> {
        Iterator<T> it;

        For(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public Iterator<T> iterator() {
            return this.it;
        }
    }

    public static class RenameJob
    extends Job {
        static final long serialVersionUID = 0L;
        private final NccResults results;

        public boolean doIt() throws JobException {
            SchemNamesToLay.copyNames(this.results);
            return true;
        }

        public void terminateOK() {
            NccJob.invalidateLastNccResult();
        }

        public RenameJob(NccResults r) {
            super("SchemNamesToLayJob", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.results = r;
            this.startJob();
        }

        public RenameJob() {
            this(NccJob.getLastNccResults());
        }
    }

    public static class RenameResult {
        public final int numArcRenames;
        public final int numNodeRenames;
        public final int numArcManRenames;
        public final int numNodeManRenames;
        public final int numNameConflicts;

        RenameResult(int numArcRenames, int numNodeRenames, int numArcManRenames, int numNodeManRenames, int numNameConflicts) {
            this.numArcRenames = numArcRenames;
            this.numNodeRenames = numNodeRenames;
            this.numArcManRenames = numArcManRenames;
            this.numNodeManRenames = numNodeManRenames;
            this.numNameConflicts = numNameConflicts;
        }
    }
}

