/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.kawa.functions.IntegerFormat;
import gnu.kawa.functions.LispFormat;
import gnu.kawa.functions.ObjectFormat;
import gnu.lists.FString;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Procedure1;
import gnu.text.CompoundFormat;
import gnu.text.LineBufferedReader;
import gnu.text.LiteralFormat;
import gnu.text.PadFormat;
import gnu.text.ReportFormat;
import java.io.IOException;
import java.text.Format;
import java.text.ParseException;
import java.util.Vector;

public class ParseFormat
extends Procedure1 {
    public static final ParseFormat parseFormat = new ParseFormat(false);
    boolean emacsStyle = true;
    public static final int PARAM_UNSPECIFIED = -1073741824;
    public static final int PARAM_FROM_LIST = -1610612736;
    public static final int SEEN_MINUS = 1;
    public static final int SEEN_PLUS = 2;
    public static final int SEEN_SPACE = 4;
    public static final int SEEN_ZERO = 8;
    public static final int SEEN_HASH = 16;

    public ParseFormat(boolean emacsStyle) {
        this.emacsStyle = emacsStyle;
    }

    public ReportFormat parseFormat(LineBufferedReader fmt) throws ParseException, IOException {
        return ParseFormat.parseFormat(fmt, this.emacsStyle ? (char)'?' : '~');
    }

    public static ReportFormat parseFormat(LineBufferedReader fmt, char magic) throws ParseException, IOException {
        Object f;
        StringBuffer fbuf = new StringBuffer(100);
        int position = 0;
        Vector<ReportFormat> formats = new Vector<ReportFormat>();
        while (true) {
            Format format;
            int len;
            int ch;
            if ((ch = fmt.read()) >= 0) {
                if (ch != magic) {
                    fbuf.append((char)ch);
                    continue;
                }
                ch = fmt.read();
                if (ch == magic) {
                    fbuf.append((char)ch);
                    continue;
                }
            }
            if ((len = fbuf.length()) > 0) {
                char[] text = new char[len];
                fbuf.getChars(0, len, text, 0);
                fbuf.setLength(0);
                formats.addElement(new LiteralFormat(text));
            }
            if (ch < 0) break;
            if (ch == 36) {
                int digit;
                ch = fmt.read();
                position = Character.digit((char)ch, 10);
                if (position < 0) {
                    throw new ParseException("missing number (position) after '%$'", -1);
                }
                while ((digit = Character.digit((char)(ch = fmt.read()), 10)) >= 0) {
                    position = 10 * position + digit;
                }
                --position;
            }
            int flags = 0;
            block14: while (true) {
                switch ((char)ch) {
                    case '-': {
                        flags |= 1;
                        break;
                    }
                    case '+': {
                        flags |= 2;
                        break;
                    }
                    case ' ': {
                        flags |= 4;
                        break;
                    }
                    case '0': {
                        flags |= 8;
                        break;
                    }
                    case '#': {
                        flags |= 0x10;
                        break;
                    }
                    default: {
                        break block14;
                    }
                }
                ch = fmt.read();
            }
            int width = -1073741824;
            int digit = Character.digit((char)ch, 10);
            if (digit >= 0) {
                width = digit;
                while ((digit = Character.digit((char)(ch = fmt.read()), 10)) >= 0) {
                    width = 10 * width + digit;
                }
            } else if (ch == 42) {
                width = -1610612736;
            }
            int precision = -1073741824;
            if (ch == 46) {
                if (ch == 42) {
                    precision = -1610612736;
                } else {
                    precision = 0;
                    while ((digit = Character.digit((char)(ch = fmt.read()), 10)) >= 0) {
                        precision = 10 * precision + digit;
                    }
                }
            }
            switch (ch) {
                case 83: 
                case 115: {
                    format = new ObjectFormat(ch == 83, precision);
                    break;
                }
                case 88: 
                case 100: 
                case 105: 
                case 111: 
                case 120: {
                    int padChar;
                    int base;
                    int fflags = 0;
                    if (ch == 100 || ch == 105) {
                        base = 10;
                    } else if (ch == 111) {
                        base = 8;
                    } else {
                        base = 16;
                        if (ch == 88) {
                            fflags = 32;
                        }
                    }
                    boolean seenColon = false;
                    boolean seenAt = false;
                    int n = padChar = (flags & 9) == 8 ? 48 : 32;
                    if ((flags & 0x10) != 0) {
                        fflags |= 8;
                    }
                    if ((flags & 2) != 0) {
                        fflags |= 2;
                    }
                    if ((flags & 1) != 0) {
                        fflags |= 0x10;
                    }
                    if ((flags & 4) != 0) {
                        fflags |= 4;
                    }
                    if (precision != -1073741824) {
                        flags &= 0xFFFFFFF7;
                        format = IntegerFormat.getInstance(base, precision, 48, -1073741824, -1073741824, fflags |= 0x40);
                        break;
                    }
                    format = IntegerFormat.getInstance(base, width, padChar, -1073741824, -1073741824, fflags);
                    break;
                }
                case 101: 
                case 102: 
                case 103: {
                    format = new ObjectFormat(false);
                    break;
                }
                default: {
                    throw new ParseException("unknown format character '" + ch + "'", -1);
                }
            }
            if (width > 0) {
                char padChar;
                char c = padChar = (flags & 8) != 0 ? (char)'0' : ' ';
                int where = (flags & 1) != 0 ? 100 : (padChar == '0' ? -1 : 0);
                format = new PadFormat(format, width, padChar, where);
            }
            formats.addElement((ReportFormat)format);
            ++position;
        }
        int fcount = formats.size();
        if (fcount == 1 && (f = formats.elementAt(0)) instanceof ReportFormat) {
            return (ReportFormat)f;
        }
        Object[] farray = new Format[fcount];
        formats.copyInto(farray);
        return new CompoundFormat((Format[])farray);
    }

    public Object apply1(Object arg) {
        return ParseFormat.asFormat(arg, this.emacsStyle ? (char)'?' : '~');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportFormat asFormat(Object arg, char style) {
        ReportFormat reportFormat;
        CharArrayInPort iport;
        if (arg instanceof ReportFormat) {
            return (ReportFormat)arg;
        }
        if (style == '~') {
            return new LispFormat(arg.toString());
        }
        if (arg instanceof FString) {
            FString str = (FString)arg;
            iport = new CharArrayInPort(str.data, str.size);
        } else {
            iport = new CharArrayInPort(arg.toString());
        }
        try {
            reportFormat = ParseFormat.parseFormat(iport, style);
        }
        catch (Throwable throwable) {
            try {
                iport.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Error parsing format (" + ex + ")");
            }
            catch (ParseException ex) {
                throw new RuntimeException("Invalid format (" + ex + ")");
            }
            catch (IndexOutOfBoundsException ex) {
                throw new RuntimeException("End while parsing format");
            }
        }
        iport.close();
        return reportFormat;
    }
}

