/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.kawa.xml.KNode;
import gnu.lists.AbstractSequence;
import gnu.lists.Consumer;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.lists.TreeList;
import gnu.mapping.Values;
import gnu.xml.NodeTree;
import gnu.xml.XMLFilter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Nodes
extends Values
implements NodeList {
    static final int POS_SIZE = 5;
    int count;
    int nesting = 0;
    boolean inAttribute;
    NodeTree curNode;
    XMLFilter curFragment;

    public void writePosition(AbstractSequence seq, int ipos) {
        ++this.count;
        super.writePosition(seq, ipos);
    }

    public int find(Object seq) {
        int oindex;
        if (this.gapStart > 0 && this.objects[oindex = this.getIntN(this.gapStart - 5 + 1)] == seq) {
            return oindex;
        }
        if (this.gapEnd < this.data.length && this.objects[oindex = this.getIntN(this.gapEnd + 1)] == seq) {
            return oindex;
        }
        return super.find(seq);
    }

    public void writeObject(Object v) {
        if (this.curFragment != null) {
            if (this.nesting == 0 && (v instanceof SeqPosition || v instanceof TreeList)) {
                this.finishFragment();
            } else {
                this.curFragment.writeObject(v);
                return;
            }
        }
        if (v instanceof SeqPosition) {
            SeqPosition seq = (SeqPosition)v;
            this.writePosition(seq.sequence, seq.ipos);
            return;
        }
        if (v instanceof TreeList) {
            TreeList tlist = (TreeList)v;
            this.writePosition(tlist, 0);
            return;
        }
        this.handleNonNode();
        this.curFragment.writeObject(v);
    }

    void maybeStartTextNode() {
        if (this.curFragment == null) {
            throw new IllegalArgumentException("non-node where node required");
        }
    }

    void handleNonNode() {
        if (this.curFragment == null) {
            throw new ClassCastException("atomic value where node is required");
        }
    }

    public void writeFloat(float v) {
        this.handleNonNode();
        this.curFragment.writeFloat(v);
    }

    public void writeDouble(double v) {
        this.handleNonNode();
        this.curFragment.writeDouble(v);
    }

    public void writeLong(long v) {
        this.handleNonNode();
        this.curFragment.writeLong(v);
    }

    public void writeInt(int v) {
        this.handleNonNode();
        this.curFragment.writeInt(v);
    }

    public void writeBoolean(boolean v) {
        this.handleNonNode();
        this.curFragment.writeBoolean(v);
    }

    public void write(int v) {
        this.maybeStartTextNode();
        this.curFragment.write(v);
    }

    public Consumer append(CharSequence csq, int start, int end) {
        this.maybeStartTextNode();
        this.curFragment.write(csq, start, end);
        return this;
    }

    public void write(char[] buf, int off, int len) {
        this.maybeStartTextNode();
        this.curFragment.write(buf, off, len);
    }

    public void write(CharSequence str, int start, int length) {
        this.maybeStartTextNode();
        this.curFragment.write(str, start, length);
    }

    public void write(String str) {
        this.maybeStartTextNode();
        this.curFragment.write(str);
    }

    private void maybeStartNonTextNode() {
        if (this.curFragment != null && this.nesting == 0) {
            this.finishFragment();
        }
        if (this.curFragment == null) {
            this.startFragment();
        }
        ++this.nesting;
    }

    private void maybeEndNonTextNode() {
        if (--this.nesting == 0) {
            this.finishFragment();
        }
    }

    public void startElement(Object type) {
        this.maybeStartNonTextNode();
        this.curFragment.startElement(type);
    }

    public void endElement() {
        this.curFragment.endElement();
        this.maybeEndNonTextNode();
    }

    public void startAttribute(Object attrType) {
        this.maybeStartNonTextNode();
        this.curFragment.startAttribute(attrType);
        this.inAttribute = true;
    }

    public void endAttribute() {
        if (!this.inAttribute) {
            return;
        }
        this.inAttribute = false;
        this.curFragment.endAttribute();
        this.maybeEndNonTextNode();
    }

    public void writeComment(char[] chars, int offset, int length) {
        this.maybeStartNonTextNode();
        this.curFragment.writeComment(chars, offset, length);
        this.maybeEndNonTextNode();
    }

    public void writeCDATA(char[] chars, int offset, int length) {
        this.maybeStartNonTextNode();
        this.curFragment.writeCDATA(chars, offset, length);
    }

    public void writeProcessingInstruction(String target, char[] content, int offset, int length) {
        this.maybeStartNonTextNode();
        this.curFragment.writeProcessingInstruction(target, content, offset, length);
        this.maybeEndNonTextNode();
    }

    public void startDocument() {
        this.maybeStartNonTextNode();
        this.curFragment.startDocument();
    }

    public void endDocument() {
        this.curFragment.endDocument();
        this.maybeEndNonTextNode();
    }

    public void beginEntity(Object base) {
        this.maybeStartNonTextNode();
        this.curFragment.beginEntity(base);
    }

    public void endEntity() {
        this.curFragment.endEntity();
        this.maybeEndNonTextNode();
    }

    void startFragment() {
        this.curNode = new NodeTree();
        this.curFragment = new XMLFilter(this.curNode);
        this.writePosition(this.curNode, 0);
    }

    void finishFragment() {
        this.curNode = null;
        this.curFragment = null;
    }

    public int size() {
        return this.count;
    }

    public int getLength() {
        return this.count;
    }

    public Object get(int index) {
        int i = 5 * index;
        if (i >= this.gapStart) {
            i += this.gapEnd - this.gapStart;
        }
        if (i < 0 || i >= this.data.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.data[i] != '\uf10f') {
            throw new RuntimeException("internal error - unexpected data");
        }
        return KNode.make((NodeTree)this.objects[this.getIntN(i + 1)], this.getIntN(i + 3));
    }

    public Node item(int index) {
        if (index >= this.count) {
            return null;
        }
        return (Node)this.get(index);
    }

    public Object getPosNext(int ipos) {
        int index = this.posToDataIndex(ipos);
        if (index == this.data.length) {
            return Sequence.eofValue;
        }
        if (this.data[index] != '\uf10f') {
            throw new RuntimeException("internal error - unexpected data");
        }
        return KNode.make((NodeTree)this.objects[this.getIntN(index + 1)], this.getIntN(index + 3));
    }

    public AbstractSequence getSeq(int index) {
        int i = 5 * index;
        if (i >= this.gapStart) {
            i += this.gapEnd - this.gapStart;
        }
        if (i < 0 || i >= this.data.length) {
            return null;
        }
        if (this.data[i] != '\uf10f') {
            throw new RuntimeException("internal error - unexpected data");
        }
        return (AbstractSequence)this.objects[this.getIntN(i + 1)];
    }

    public int getPos(int index) {
        int i = 5 * index;
        if (i >= this.gapStart) {
            i += this.gapEnd - this.gapStart;
        }
        if (this.data[i] != '\uf10f') {
            throw new RuntimeException("internal error - unexpected data");
        }
        return this.getIntN(i + 3);
    }

    public static KNode root(NodeTree seq, int ipos) {
        int root = seq.gapStart > 5 && seq.data[0] == '\uf112' ? 10 : 0;
        return KNode.make(seq, root);
    }
}

