/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.lists.FString;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongType;
import gnu.text.FilePath;
import gnu.text.Path;
import gnu.text.URIStringPath;
import gnu.text.URLPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIPath
extends Path
implements Comparable<URIPath> {
    final URI uri;

    URIPath(URI uri) {
        this.uri = uri;
    }

    public static URIPath coerceToURIPathOrNull(Object path) {
        String str;
        if (path instanceof URIPath) {
            return (URIPath)path;
        }
        if (path instanceof URL) {
            return URLPath.valueOf((URL)path);
        }
        if (path instanceof URI) {
            return URIPath.valueOf((URI)path);
        }
        if (path instanceof File || path instanceof Path || path instanceof FString) {
            str = path.toString();
        } else if (path instanceof String) {
            str = (String)path;
        } else {
            return null;
        }
        return URIPath.valueOf(str);
    }

    public static URIPath makeURI(Object arg) {
        URIPath path = URIPath.coerceToURIPathOrNull(arg);
        if (path == null) {
            throw new WrongType((String)null, -4, arg, "URI");
        }
        return path;
    }

    public static URIPath valueOf(URI uri) {
        return new URIPath(uri);
    }

    public static URIPath valueOf(String uri) {
        try {
            return new URIStringPath(new URI(URIPath.encodeForUri(uri, 'I')), uri);
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
    }

    @Override
    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    @Override
    public boolean exists() {
        try {
            URLConnection conn = this.toURL().openConnection();
            if (conn instanceof HttpURLConnection) {
                return ((HttpURLConnection)conn).getResponseCode() == 200;
            }
            return conn.getLastModified() != 0L;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public long getLastModified() {
        return URLPath.getLastModified(this.toURL());
    }

    @Override
    public long getContentLength() {
        return URLPath.getContentLength(this.toURL());
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public String toURIString() {
        return this.uri.toString();
    }

    @Override
    public Path resolve(String rstr) {
        URI resolved;
        if (Path.uriSchemeSpecified(rstr)) {
            return URIPath.valueOf(rstr);
        }
        char fileSep = File.separatorChar;
        if (fileSep != '/') {
            if (rstr.length() >= 2 && (rstr.charAt(1) == ':' && Character.isLetter(rstr.charAt(0)) || rstr.charAt(0) == fileSep && rstr.charAt(1) == fileSep)) {
                return FilePath.valueOf(new File(rstr));
            }
            rstr = rstr.replace(fileSep, '/');
        }
        try {
            resolved = this.uri.resolve(new URI(null, rstr, null));
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
        return URIPath.valueOf(resolved);
    }

    @Override
    public int compareTo(URIPath path) {
        return this.uri.compareTo(path.uri);
    }

    public boolean equals(Object obj) {
        return obj instanceof URIPath && this.uri.equals(((URIPath)obj).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.toURIString();
    }

    @Override
    public URL toURL() {
        return Path.toURL(this.uri.toString());
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return URLPath.openInputStream(this.toURL());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return URLPath.openOutputStream(this.toURL());
    }

    @Override
    public String getScheme() {
        return this.uri.getScheme();
    }

    @Override
    public String getHost() {
        return this.uri.getHost();
    }

    @Override
    public String getAuthority() {
        return this.uri.getAuthority();
    }

    @Override
    public String getUserInfo() {
        return this.uri.getUserInfo();
    }

    @Override
    public int getPort() {
        return this.uri.getPort();
    }

    @Override
    public String getPath() {
        return this.uri.getPath();
    }

    @Override
    public String getQuery() {
        return this.uri.getQuery();
    }

    @Override
    public String getFragment() {
        return this.uri.getFragment();
    }

    @Override
    public Path getCanonical() {
        if (this.isAbsolute()) {
            URI norm = this.uri.normalize();
            if (norm == this.uri) {
                return this;
            }
            return URIPath.valueOf(norm);
        }
        return this.getAbsolute().getCanonical();
    }

    public static String encodeForUri(String str, char mode) {
        StringBuffer sbuf = new StringBuffer();
        int len = str.length();
        int i = 0;
        while (i < len) {
            int ch;
            if ((ch = str.charAt(i++)) >= 55296 && ch < 56320 && i < len) {
                ch = (ch - 55296) * 1024 + (str.charAt(i++) - 56320) + 65536;
            }
            if (mode == 'H' ? ch >= 32 && ch <= 126 : ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57 || ch == 45 || ch == 95 || ch == 46 || ch == 126 || mode == 'I' && (ch == 59 || ch == 47 || ch == 63 || ch == 58 || ch == 42 || ch == 39 || ch == 40 || ch == 41 || ch == 64 || ch == 38 || ch == 61 || ch == 43 || ch == 36 || ch == 44 || ch == 91 || ch == 93 || ch == 35 || ch == 33 || ch == 37)) {
                sbuf.append((char)ch);
                continue;
            }
            int pos = sbuf.length();
            int nbytes = 0;
            int needed = ch < 128 ? 1 : (ch < 2048 ? 2 : (ch < 65536 ? 3 : 4));
            do {
                int b;
                int availbits;
                int n = availbits = nbytes == 0 ? 7 : 6 - nbytes;
                if (ch < 1 << availbits) {
                    b = ch;
                    if (nbytes > 0) {
                        b |= 65408 >> nbytes & 0xFF;
                    }
                    ch = 0;
                } else {
                    b = 0x80 | ch & 0x3F;
                    ch >>= 6;
                }
                ++nbytes;
                for (int j = 0; j <= 1; ++j) {
                    int hex = b & 0xF;
                    sbuf.insert(pos, (char)(hex <= 9 ? hex + 48 : hex - 10 + 65));
                    b >>= 4;
                }
                sbuf.insert(pos, '%');
            } while (ch != 0);
        }
        return sbuf.toString();
    }
}

