/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.StackTarget;
import gnu.expr.Target;

public class SeriesTarget
extends Target {
    public Declaration param;
    public Label function;
    public Label done;
    public Scope scope;

    public void compileFromStackSimple(Compilation compilation, Type type) {
        CodeAttr codeAttr = compilation.getCode();
        StackTarget.convert(compilation, type, this.param.getType());
        this.param.compileStore(compilation);
        codeAttr.emitJsr(this.function);
        codeAttr.locals.preserveVariablesUpto(this.scope);
    }

    public void compileFromStack(Compilation compilation, Type type) {
        CodeAttr codeAttr = compilation.getCode();
        if (SeriesTarget.isSingletonType(type)) {
            this.compileFromStackSimple(compilation, type);
            return;
        }
        Variable variable = codeAttr.addLocal(Type.int_type);
        Variable variable2 = codeAttr.addLocal(Type.pointer_type);
        Variable variable3 = codeAttr.addLocal(Type.int_type);
        StackTarget.convert(compilation, type, Type.pointer_type);
        codeAttr.emitStore(variable2);
        codeAttr.emitPushInt(0);
        codeAttr.emitStore(variable);
        Label label = new Label(codeAttr);
        label.define(codeAttr);
        codeAttr.emitLoad(variable2);
        codeAttr.emitLoad(variable);
        codeAttr.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("nextIndex", 2));
        codeAttr.emitDup(Type.int_type);
        codeAttr.emitStore(variable3);
        codeAttr.emitGotoIfIntLtZero(this.done);
        codeAttr.emitLoad(variable2);
        codeAttr.emitLoad(variable);
        codeAttr.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("nextValue", 2));
        this.compileFromStackSimple(compilation, Type.pointer_type);
        codeAttr.emitLoad(variable3);
        codeAttr.emitStore(variable);
        codeAttr.emitGoto(label);
    }

    public Type getType() {
        return Type.pointer_type;
    }

    public static boolean isSingletonType(Type type) {
        int n;
        if (type instanceof PrimType) {
            return !type.isVoid();
        }
        if (type instanceof ArrayType) {
            return true;
        }
        return type instanceof ClassType && (n = type.compare(Compilation.typeValues)) == -3;
    }
}

