/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.CancelledException;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.EMenu;
import gnu.jemacs.swing.SwingMenu;
import gnu.jemacs.swing.SwingWindow;
import gnu.lists.LList;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SwingFrame
extends EFrame {
    JFrame jframe;
    JMenuBar menuBar;
    JPanel contents;

    public SwingFrame() {
    }

    public SwingFrame(Buffer buffer) {
        this(new SwingWindow(buffer, true));
    }

    public SwingFrame(SwingWindow swingWindow) {
        super(swingWindow);
        this.contents = swingWindow.wrap();
        this.jframe = new JFrame(SwingFrame.defaultName());
        this.jframe.getContentPane().add(this.contents);
        this.jframe.setSize(600, 400);
        this.jframe.setVisible(true);
        this.jframe.setTitle("JEmacs");
        this.menuBar = new JMenuBar();
        this.jframe.setJMenuBar(this.menuBar);
    }

    public boolean isLive() {
        return this.contents != null;
    }

    public void validate() {
        this.jframe.validate();
    }

    public void delete() {
        super.delete();
        this.contents = null;
        this.jframe.dispose();
    }

    public String ask(String string) {
        String string2 = JOptionPane.showInputDialog(this.jframe, (Object)string);
        if (string2 == null) {
            throw new CancelledException();
        }
        return string2;
    }

    public void setMenuBar(EMenu eMenu) {
        SwingMenu swingMenu = (SwingMenu)eMenu;
        this.menuBar.removeAll();
        while (swingMenu.getMenuComponentCount() > 0) {
            this.menuBar.add(swingMenu.getMenuComponent(0));
        }
        this.menuBar.updateUI();
    }

    public void setMenu(LList lList) {
        SwingMenu swingMenu = new SwingMenu(lList);
        this.setMenuBar(swingMenu);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#<frame #");
        stringBuffer.append(this.id);
        if (this.jframe != null) {
            stringBuffer.append(" size: ");
            stringBuffer.append(this.jframe.getSize());
            stringBuffer.append(" preferred: ");
            stringBuffer.append(this.jframe.getPreferredSize());
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

