/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.lists.LList;
import gnu.lists.SeqPosition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CGIServletWrapper
extends ServletOutputStream
implements HttpServletRequest,
HttpServletResponse,
ServletConfig,
ServletContext {
    byte[] buffer = null;
    int bufpos = 0;
    PrintStream out = System.out;
    Vector headers = new Vector();
    String sawContentType;
    int statusCode = 0;
    String statusString;
    String servletName;
    private static final int defaultBufferSize = 2048;
    PrintWriter writer;
    Hashtable attributes;
    boolean committed;
    String characterEncoding;
    static final Enumeration nullEnumeration = new SeqPosition(LList.Empty, 0, false);

    public static void main(String[] stringArray) {
        try {
            CGIServletWrapper cGIServletWrapper = new CGIServletWrapper();
            Class<?> clazz = Class.forName(stringArray[0]);
            cGIServletWrapper.servletName = stringArray[0];
            HttpServlet httpServlet = (HttpServlet)clazz.newInstance();
            httpServlet.init((ServletConfig)cGIServletWrapper);
            httpServlet.service((ServletRequest)cGIServletWrapper, (ServletResponse)cGIServletWrapper);
            cGIServletWrapper.flushBuffer();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    private void allocateBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[2048];
        }
    }

    public void write(int n) throws IOException {
        this.allocateBuffer();
        int n2 = this.buffer.length;
        if (this.buffer.length == 0) {
            this.committ();
            this.out.write(n);
        } else {
            if (this.bufpos >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.bufpos++] = (byte)n;
        }
    }

    public String getCgiEnvVar(String string) {
        return System.getProperty(string);
    }

    public ServletOutputStream getOutputStream() {
        return this;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter(this.out);
        }
        return this.writer;
    }

    public Map getParameterMap() {
        return null;
    }

    public void setBufferSize(int n) {
        if (this.bufpos > 0 || this.committed) {
            throw new IllegalStateException();
        }
        this.buffer = new byte[n];
    }

    public int getBufferSize() {
        return this.buffer == null ? 2048 : this.buffer.length;
    }

    public void setLocale(Locale locale) {
    }

    private void committ() throws IOException {
        if (!this.committed) {
            this.printHeaders();
            this.committed = true;
        }
    }

    public void flushBuffer() throws IOException {
        this.committ();
        if (this.bufpos > 0) {
            this.out.write(this.buffer, 0, this.bufpos);
        }
        this.bufpos = 0;
    }

    public void resetBuffer() {
        this.bufpos = 0;
    }

    public void reset() {
        this.resetBuffer();
    }

    public Object getAttribute(String string) {
        return this.attributes == null ? null : this.attributes.get(string);
    }

    public void setAttribute(String string, Object object2) {
        if (object2 == null) {
            this.removeAttribute(string);
        } else {
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
            this.attributes.put(string, object2);
        }
    }

    public void removeAttribute(String string) {
        if (this.attributes != null) {
            this.attributes.remove(string);
        }
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getContentType() {
        return this.getCgiEnvVar("CONTENT_TYPE");
    }

    public String getPathInfo() {
        return this.getCgiEnvVar("PATH_INFO");
    }

    public String getPathTranslated() {
        return this.getCgiEnvVar("PATH_TRANSLATED");
    }

    public String getRequestURI() {
        String string = this.getServletPath();
        String string2 = this.getPathInfo();
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + '/' + string2;
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = new StringBuffer(100);
        String string = this.getScheme();
        int n = this.getServerPort();
        if (n < 0) {
            n = 80;
        }
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(this.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        stringBuffer.append('/');
        stringBuffer.append(this.getRequestURI());
        return stringBuffer;
    }

    public String getProtocol() {
        return this.getCgiEnvVar("SERVER_PROTOCOL");
    }

    public int getServerPort() {
        String string = this.getCgiEnvVar("SERVER_PORT");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLocalPort() {
        return this.getServerPort();
    }

    public String getLocalAddr() {
        try {
            return InetAddress.getByName(this.getLocalName()).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "127.0.0.1";
        }
    }

    public String getLocalName() {
        return this.getServerName();
    }

    public int getRemotePort() {
        return -1;
    }

    public boolean isSecure() {
        return this.getServerPort() == 443;
    }

    public String getServerName() {
        return this.getCgiEnvVar("SERVER_NAME");
    }

    public String getMethod() {
        String string = this.getCgiEnvVar("REQUEST_METHOD");
        return string == null ? "GET" : string;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public void setContentType(String string) {
        this.setHeader("Content-Type", string);
    }

    public void setContentLength(int n) {
        this.setIntHeader("Content-Length", n);
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String string) {
        int n = this.headers.size();
        for (int i = 0; i < n; i += 2) {
            if (!this.headers.elementAt(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    public String encodeURL(String string) {
        return null;
    }

    public String encodeUrl(String string) {
        return null;
    }

    public String encodeRedirectURL(String string) {
        return null;
    }

    public String encodeRedirectUrl(String string) {
        return null;
    }

    public void sendError(int n, String string) {
        this.statusCode = n;
        this.statusString = string;
    }

    public void sendError(int n) {
        this.statusCode = n;
        this.statusString = null;
    }

    public void sendRedirect(String string) {
    }

    private void printHeader(String string, String string2) {
        this.out.print(string);
        this.out.print(": ");
        this.out.println(string2);
    }

    private void printHeaders() {
        if (this.statusCode != 0) {
            this.out.print("Status: ");
            this.out.print(this.statusCode);
            if (this.statusString != null) {
                this.out.print(' ');
                this.out.print(this.statusString);
            }
            this.out.println();
        }
        if (this.sawContentType == null) {
            this.setContentType("text/html");
        }
        int n = this.headers.size();
        for (int i = 0; i < n; i += 2) {
            this.printHeader(this.headers.elementAt(i).toString(), this.headers.elementAt(i + 1).toString());
        }
        this.out.println();
    }

    public void setDateHeader(String string, long l) {
    }

    public void addDateHeader(String string, long l) {
    }

    public void setHeader(String string, String string2) {
        int n = this.headers.size();
        for (int i = 0; i < n; i += 2) {
            if (!this.headers.elementAt(i).equals(string)) continue;
            if (string.equalsIgnoreCase("Content-type")) {
                this.sawContentType = string2;
            }
            this.headers.setElementAt(string2, i + 1);
            break;
        }
        this.addHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    public void addHeader(String string, String string2) {
        if (string.equalsIgnoreCase("Content-type")) {
            this.sawContentType = string2;
        }
        this.headers.addElement(string);
        this.headers.addElement(string2);
    }

    public void addIntHeader(String string, int n) {
        this.addHeader(string, Integer.toString(n));
    }

    public void setStatus(int n) {
        this.statusCode = n;
        this.statusString = null;
    }

    public void setStatus(int n, String string) {
        this.statusCode = n;
        this.statusString = string;
    }

    public String getScheme() {
        return this.getServerPort() == 443 ? "https" : "http";
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getRealPath(String string) {
        return null;
    }

    public Locale getLocale() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return null;
    }

    public String getRemoteAddr() {
        return this.getCgiEnvVar("REMOTE_ADDR");
    }

    public String getRemoteHost() {
        String string = this.getCgiEnvVar("REMOTE_HOST");
        return string != null ? string : this.getRemoteAddr();
    }

    public BufferedReader getReader() {
        return null;
    }

    public ServletInputStream getInputStream() {
        return null;
    }

    public String getParameter(String string) {
        return null;
    }

    public Enumeration getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String string) {
        return null;
    }

    public int getContentLength() {
        String string = this.getCgiEnvVar("CONTENT_LENGTH");
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getAuthType() {
        return this.getCgiEnvVar("AUTH_TYPE");
    }

    public long getDateHeader(String string) {
        return -1L;
    }

    public String getHeader(String string) {
        return null;
    }

    public Enumeration getHeaders(String string) {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.getCgiEnvVar("SCRIPT_NAME");
    }

    public HttpSession getSession(boolean bl) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public String getRemoteUser() {
        return this.getCgiEnvVar("REMOTE_USER");
    }

    public boolean isUserInRole(String string) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getContextPath() {
        return "";
    }

    public String getQueryString() {
        return this.getCgiEnvVar("QUERY_STRING");
    }

    public Enumeration getHeaderNames() {
        return null;
    }

    public int getIntHeader(String string) {
        return -1;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public String getInitParameter(String string) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return nullEnumeration;
    }

    public ServletContext getServletContext() {
        return this;
    }

    public String getServletName() {
        return this.servletName;
    }

    public ServletContext getContext(String string) {
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    public String getMimeType(String string) {
        return null;
    }

    public Set getResourcePaths(String string) {
        return null;
    }

    public URL getResource(String string) {
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        return null;
    }

    public Servlet getServlet(String string) {
        return null;
    }

    public Enumeration getServlets() {
        return nullEnumeration;
    }

    public Enumeration getServletNames() {
        return nullEnumeration;
    }

    public void log(String string) {
    }

    public void log(Exception exception, String string) {
    }

    public void log(String string, Throwable throwable) {
    }

    public String getServerInfo() {
        return "Kawa CGI/servlet wrapper";
    }

    public String getServletContextName() {
        return null;
    }
}

