/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import kawa.Telnet;

public class TelnetInputStream
extends FilterInputStream {
    Telnet connection;
    protected byte[] buf = new byte[512];
    int pos;
    int count;
    int state = 0;
    int subCommandLength = 0;
    static final int SB_IAC = 400;

    public TelnetInputStream(InputStream inputStream, Telnet telnet) throws IOException {
        super(inputStream);
        this.connection = telnet;
    }

    public int read() throws IOException {
        while (true) {
            int n;
            if (this.pos >= this.count) {
                n = this.in.available();
                if (n <= 0) {
                    n = 1;
                } else if (n > this.buf.length - this.subCommandLength) {
                    n = this.buf.length - this.subCommandLength;
                }
                n = this.in.read(this.buf, this.subCommandLength, n);
                this.pos = this.subCommandLength;
                this.count = n;
                if (n <= 0) {
                    return -1;
                }
            }
            n = this.buf[this.pos++] & 0xFF;
            if (this.state == 0) {
                if (n != 255) {
                    return n;
                }
                this.state = 255;
                continue;
            }
            if (this.state == 255) {
                if (n == 255) {
                    this.state = 0;
                    return 255;
                }
                if (n == 251 || n == 252 || n == 253 || n == 254 || n == 250) {
                    this.state = n;
                    continue;
                }
                if (n == 244) {
                    System.err.println("Interrupt Process");
                    this.state = 0;
                    continue;
                }
                if (n == 236) {
                    return -1;
                }
                this.state = 0;
                continue;
            }
            if (this.state == 251 || this.state == 252 || this.state == 253 || this.state == 254) {
                this.connection.handle(this.state, n);
                this.state = 0;
                continue;
            }
            if (this.state == 250) {
                if (n == 255) {
                    this.state = 400;
                    continue;
                }
                this.buf[this.subCommandLength++] = (byte)n;
                continue;
            }
            if (this.state == 400) {
                if (n == 255) {
                    this.buf[this.subCommandLength++] = (byte)n;
                    this.state = 250;
                    continue;
                }
                if (n == 240) {
                    this.connection.subCommand(this.buf, 0, this.subCommandLength);
                    this.state = 0;
                    this.subCommandLength = 0;
                    continue;
                }
                this.state = 0;
                this.subCommandLength = 0;
                continue;
            }
            System.err.println("Bad state " + this.state);
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 <= 0) {
            return 0;
        }
        int n4 = 0;
        if (this.state != 0 || this.pos >= this.count) {
            n3 = this.read();
            if (n3 < 0) {
                return n3;
            }
            byArray[n++] = (byte)n3;
            ++n4;
        }
        if (this.state == 0) {
            while (this.pos < this.count && n4 < n2 && (n3 = this.buf[this.pos]) != -1) {
                byArray[n++] = n3;
                ++n4;
                ++this.pos;
            }
        }
        return n4;
    }
}

