/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.iggy;

public final class IggyConstants {

    public static final String MESSAGE_ID = "CamelIggyMessageId";
    public static final String MESSAGE_OFFSET = "CamelIggyMessageOffset";
    public static final String MESSAGE_TIMESTAMP = "CamelIggyMessageTimestamp";
    public static final String MESSAGE_ORIGIN_TIMESTAMP = "CamelIggyMessageOriginTimestamp";
    public static final String MESSAGE_CHECKSUM = "CamelIggyMessageChecksum";
    public static final String MESSAGE_LENGTH = "CamelIggyMessageLength";
    public static final String MESSAGE_SIZE = "CamelIggyMessageSize";
    public static final String TOPIC_OVERRIDE = "CamelIggyTopicOverride";
    public static final String STREAM_OVERRIDE = "CamelIggyStreamOverride";

    private IggyConstants() {
        // Constants class
    }
}
