/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processor.tdml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.api.Daffodil;
import org.apache.daffodil.api.DaffodilParseXMLReader;
import org.apache.daffodil.api.DataProcessor;
import org.apache.daffodil.api.InputSourceDataInputStream;
import org.apache.daffodil.api.debugger.Debugger;
import org.apache.daffodil.api.infoset.InfosetInputter;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.externalvars.Binding;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.lib.xml.DaffodilSAXParserFactory$;
import org.apache.daffodil.lib.xml.XMLUtils;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.processor.tdml.DaffodilTDMLParseResult;
import org.apache.daffodil.processor.tdml.DaffodilTDMLSAXErrorHandler;
import org.apache.daffodil.processor.tdml.DaffodilTDMLUnparseResult;
import org.apache.daffodil.processor.tdml.TDMLInfosetInputter;
import org.apache.daffodil.processor.tdml.TDMLInfosetOutputter;
import org.apache.daffodil.processor.tdml.TDMLInfosetOutputterAll$;
import org.apache.daffodil.processor.tdml.TDMLInfosetOutputterScala$;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetInputter;
import org.apache.daffodil.runtime1.infoset.TeeInfosetOutputter;
import org.apache.daffodil.runtime1.processors.DaffodilParseOutputStreamContentHandler;
import org.apache.daffodil.runtime1.processors.UnparseResult;
import org.apache.daffodil.tdml.TDMLException$;
import org.apache.daffodil.tdml.VerifyTestCase$;
import org.apache.daffodil.tdml.processor.TDMLDFDLProcessor;
import org.apache.daffodil.tdml.processor.TDMLParseResult;
import org.apache.daffodil.tdml.processor.TDMLUnparseResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public class DaffodilTDMLDFDLProcessor
implements TDMLDFDLProcessor {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DaffodilTDMLDFDLProcessor.class.getDeclaredField("tdmlApiInfosetsEnv$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DaffodilTDMLDFDLProcessor.class.getDeclaredField("blobDir$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DaffodilTDMLDFDLProcessor.class.getDeclaredField("builtInTracer$lzy1"));
    private DataProcessor dp;
    private final URI schemaURI;
    private volatile Object builtInTracer$lzy1;
    private volatile Object blobDir$lzy1;
    private volatile Object tdmlApiInfosetsEnv$lzy1;

    public DaffodilTDMLDFDLProcessor(DataProcessor dp, URI schemaURI) {
        this.dp = dp;
        this.schemaURI = schemaURI;
    }

    private DataProcessor dp() {
        return this.dp;
    }

    private void dp_$eq(DataProcessor x$0) {
        this.dp = x$0;
    }

    private DaffodilTDMLDFDLProcessor copy(DataProcessor dp) {
        return new DaffodilTDMLDFDLProcessor(dp, this.schemaURI);
    }

    private DataProcessor copy$default$1() {
        return this.dp();
    }

    private Debugger builtInTracer() {
        Object object = this.builtInTracer$lzy1;
        if (object instanceof Debugger) {
            return (Debugger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Debugger)this.builtInTracer$lzyINIT1();
    }

    private Object builtInTracer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.builtInTracer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Debugger debugger = null;
                    try {
                        debugger = Daffodil.newTraceDebugger((PrintStream)System.out);
                        object2 = debugger == null ? LazyVals.NullValue$.MODULE$ : debugger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.builtInTracer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return debugger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Path blobDir() {
        Object object = this.blobDir$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.blobDir$lzyINIT1();
    }

    private Object blobDir$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.blobDir$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        path = Paths.get(System.getProperty("java.io.tmpdir"), "daffodil-tdml", "blobs");
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.blobDir$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private String blobPrefix() {
        return "";
    }

    private String blobSuffix() {
        return ".bin";
    }

    private String tdmlApiInfosetsEnv() {
        Object object = this.tdmlApiInfosetsEnv$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.tdmlApiInfosetsEnv$lzyINIT1();
    }

    private Object tdmlApiInfosetsEnv$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.tdmlApiInfosetsEnv$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"DAFFODIL_TDML_API_INFOSETS", DaffodilTDMLDFDLProcessor::tdmlApiInfosetsEnv$lzyINIT1$$anonfun$1);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.tdmlApiInfosetsEnv$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DaffodilTDMLDFDLProcessor withTracing(boolean bool) {
        return this.copy(this.newTracing(bool));
    }

    private DataProcessor newTracing(boolean bool) {
        if (bool) {
            return this.dp().withDebugger(this.builtInTracer());
        }
        return this.dp().withDebugger(null);
    }

    public DaffodilTDMLDFDLProcessor withDebugger(Object debugger) {
        Debugger d = (Debugger)debugger;
        return this.copy(this.dp().withDebugger(d));
    }

    public DaffodilTDMLDFDLProcessor withValidation(String validation) {
        String string = validation;
        String validatorName = "on".equals(string) ? "xerces" : ("limited".equals(string) ? "daffodil" : validation);
        return this.copy(this.dp().withValidation(validatorName, this.schemaURI.toURL()));
    }

    public DaffodilTDMLDFDLProcessor withExternalDFDLVariables(Seq<Binding> externalVarBindings) {
        scala.collection.immutable.Map map = ((IterableOnceOps)externalVarBindings.map((Function1 & Serializable)b -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)b.varQName().toString());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)b.varValue());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return this.copy(this.dp().withExternalVariables(CollectionConverters$.MODULE$.MapHasAsJava((Map)map).asJava()));
    }

    public TDMLParseResult parse(InputStream is, long lengthLimitInBits) {
        Tuple2 tuple2;
        String string = this.tdmlApiInfosetsEnv();
        String string2 = "all";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            byte[] arr = IOUtils.toByteArray((InputStream)is);
            ByteArrayInputStream saxInputStream = new ByteArrayInputStream(arr);
            ByteArrayInputStream dpInputStream = new ByteArrayInputStream(arr);
            tuple2 = Tuple2$.MODULE$.apply((Object)dpInputStream, (Object)Some$.MODULE$.apply((Object)saxInputStream));
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)is, (Object)None$.MODULE$);
        }
        Tuple2 tuple22 = tuple2;
        InputStream dpInputStream = (InputStream)tuple22._1();
        Option optSaxInputStream = (Option)tuple22._2();
        return this.doParse(dpInputStream, (Option<InputStream>)optSaxInputStream, lengthLimitInBits);
    }

    public TDMLUnparseResult unparse(Node infosetXML, OutputStream outStream) {
        ScalaXMLInfosetInputter scalaInputter = new ScalaXMLInfosetInputter(infosetXML);
        Seq otherInputters = (Seq)package$.MODULE$.Seq().empty();
        TDMLInfosetInputter inputter = new TDMLInfosetInputter(scalaInputter, (Seq<InfosetInputter>)otherInputters);
        return this.unparse(inputter, infosetXML, outStream);
    }

    public TDMLUnparseResult unparse(TDMLParseResult parseResult, OutputStream outStream) {
        DaffodilTDMLParseResult dafpr = (DaffodilTDMLParseResult)parseResult;
        TDMLInfosetInputter inputter = dafpr.inputter();
        Node resNode = dafpr.getResult();
        return this.unparse(inputter, resNode, outStream);
    }

    public TDMLUnparseResult unparse(TDMLInfosetInputter inputter, Node infosetXML, OutputStream outStream) {
        None$ none$;
        String string = this.tdmlApiInfosetsEnv();
        String string2 = "all";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
            XML$.MODULE$.write((Writer)osw, infosetXML, "UTF-8", true, null, XML$.MODULE$.write$default$6());
            osw.flush();
            osw.close();
            ByteArrayInputStream sis = new ByteArrayInputStream(bos.toByteArray());
            none$ = Some$.MODULE$.apply((Object)sis);
        } else {
            none$ = None$.MODULE$;
        }
        None$ optSaxInstream = none$;
        return this.doUnparse(inputter, (Option<InputStream>)optSaxInstream, outStream);
    }

    public TDMLParseResult doParse(InputStream dpInputStream, Option<InputStream> optSaxInputStream, long lengthLimitInBits) {
        String string = this.tdmlApiInfosetsEnv();
        String string2 = "all";
        TeeInfosetOutputter outputter = !(string != null ? !string.equals(string2) : string2 != null) ? TDMLInfosetOutputterAll$.MODULE$.apply() : TDMLInfosetOutputterScala$.MODULE$.apply();
        outputter.setBlobAttributes(this.blobDir(), this.blobPrefix(), this.blobSuffix());
        return (TDMLParseResult)Using$.MODULE$.resource((Object)InputSourceDataInputStream$.MODULE$.apply(dpInputStream), (Function1 & Serializable)dis -> {
            if (lengthLimitInBits % 8L != 0L) {
                if (lengthLimitInBits < 0L) {
                    throw Assert$.MODULE$.usageError("lengthLimitInBits.>=(0)");
                }
                dis.setBitLimit0b(MaybeULong$.MODULE$.apply(lengthLimitInBits));
            }
            DFDL.ParseResult actual = (DFDL.ParseResult)this.dp().parse((InputSourceDataInputStream)dis, (InfosetOutputter)outputter);
            String string = this.tdmlApiInfosetsEnv();
            String string2 = "all";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                InputStream saxInputStream = (InputStream)optSaxInputStream.get();
                Using$.MODULE$.resource((Object)InputSourceDataInputStream$.MODULE$.apply(saxInputStream), (Function1)(JProcedure1 & Serializable)sis -> {
                    if (lengthLimitInBits % 8L != 0L) {
                        if (lengthLimitInBits < 0L) {
                            throw Assert$.MODULE$.usageError("lengthLimitInBits.>=(0)");
                        }
                        sis.setBitLimit0b(MaybeULong$.MODULE$.apply(lengthLimitInBits));
                    }
                    DaffodilParseXMLReader xri = this.dp().newXMLReaderInstance();
                    DaffodilTDMLSAXErrorHandler errorHandler = new DaffodilTDMLSAXErrorHandler();
                    ByteArrayOutputStream saxOutputStream = new ByteArrayOutputStream();
                    DaffodilParseOutputStreamContentHandler saxHandler = new DaffodilParseOutputStreamContentHandler((OutputStream)saxOutputStream, false);
                    xri.setContentHandler((ContentHandler)saxHandler);
                    xri.setErrorHandler((ErrorHandler)errorHandler);
                    xri.setProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBDIRECTORY(), (Object)this.blobDir());
                    xri.setProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBPREFIX(), (Object)this.blobPrefix());
                    xri.setProperty(XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBSUFFIX(), (Object)this.blobSuffix());
                    xri.parse((InputSourceDataInputStream)sis);
                    if (!((DFDL.Result)actual).isError() && !errorHandler.isError()) {
                        this.verifySameParseOutput(((TDMLInfosetOutputter)outputter).xmlStream(), saxOutputStream);
                    }
                    Seq dpParseDiag = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((DFDL.Result)actual).getDiagnostics()).asScala().map((Function1 & Serializable)_$2 -> _$2.toString())).toSeq();
                    Seq saxParseDiag = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(errorHandler.getDiagnostics()).asScala().map((Function1 & Serializable)_$3 -> _$3.toString())).toSeq();
                    this.verifySameDiagnostics((Seq<String>)dpParseDiag, (Seq<String>)saxParseDiag);
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            }
            return new DaffodilTDMLParseResult(actual, (TDMLInfosetOutputter)outputter);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public Option<InputStream> doParse$default$2() {
        return None$.MODULE$;
    }

    public DaffodilTDMLUnparseResult doUnparse(TDMLInfosetInputter dpInputter, Option<InputStream> optSaxInputStream, OutputStream dpOutputStream) {
        WritableByteChannel dpOutputChannel = Channels.newChannel(dpOutputStream);
        UnparseResult actualDP = (UnparseResult)this.dp().unparse((InfosetInputter)dpInputter, dpOutputChannel);
        dpOutputChannel.close();
        String string = this.tdmlApiInfosetsEnv();
        String string2 = "all";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            InputStream saxInputStream = (InputStream)optSaxInputStream.get();
            ByteArrayOutputStream saxOutputStream = new ByteArrayOutputStream();
            WritableByteChannel saxOutputChannel = Channels.newChannel(saxOutputStream);
            DFDL.DaffodilUnparseContentHandler unparseContentHandler = (DFDL.DaffodilUnparseContentHandler)this.dp().newContentHandlerInstance(saxOutputChannel);
            unparseContentHandler.enableResolutionOfRelativeInfosetBlobURIs();
            XMLReader xmlReader = DaffodilSAXParserFactory$.MODULE$.apply().newSAXParser().getXMLReader();
            xmlReader.setContentHandler((ContentHandler)unparseContentHandler);
            xmlReader.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACES_FEATURE(), true);
            xmlReader.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE(), true);
            try {
                try {
                    xmlReader.parse(new InputSource(saxInputStream));
                }
                catch (DFDL.DaffodilUnhandledSAXException e) {
                    throw TDMLException$.MODULE$.apply("Unexpected error during SAX Unparse:" + e, (Option)None$.MODULE$);
                }
                catch (DFDL.DaffodilUnparseErrorSAXException daffodilUnparseErrorSAXException) {
                }
            }
            finally {
                unparseContentHandler.finish();
            }
            UnparseResult actualSAX = (UnparseResult)unparseContentHandler.getUnparseResult();
            saxOutputChannel.close();
            if (!actualDP.isError() && !actualSAX.isError()) {
                ByteArrayInputStream dpis = new ByteArrayInputStream(((ByteArrayOutputStream)dpOutputStream).toByteArray());
                if (actualDP.isScannable() && actualSAX.isScannable()) {
                    VerifyTestCase$.MODULE$.verifyTextData((InputStream)dpis, saxOutputStream, actualSAX.encodingName(), (Option)None$.MODULE$);
                } else {
                    VerifyTestCase$.MODULE$.verifyBinaryOrMixedData((InputStream)dpis, saxOutputStream, (Option)None$.MODULE$);
                }
            }
            Seq dpUnparseDiag = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(actualDP.getDiagnostics()).asScala().map((Function1 & Serializable)_$4 -> _$4.toString())).toSeq();
            Seq saxUnparseDiag = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(actualSAX.getDiagnostics()).asScala().map((Function1 & Serializable)_$5 -> _$5.toString())).toSeq();
            this.verifySameDiagnostics((Seq<String>)dpUnparseDiag, (Seq<String>)saxUnparseDiag);
        }
        return new DaffodilTDMLUnparseResult((DFDL.UnparseResult)actualDP, dpOutputStream);
    }

    public Option<InputStream> doUnparse$default$2() {
        return None$.MODULE$;
    }

    public void verifySameParseOutput(ByteArrayOutputStream dpOutputStream, ByteArrayOutputStream saxOutputStream) {
        String dpParseOutputString = dpOutputStream.toString("UTF-8");
        String saxParseOutputString = saxOutputStream.toString("UTF-8");
        Elem dpParseXMLNodeOutput = (Elem)XML$.MODULE$.loadString(dpParseOutputString);
        Elem saxParseXMLNodeOutput = (Elem)XML$.MODULE$.loadString(saxParseOutputString);
        try {
            XMLUtils$.MODULE$.compareAndReport((Node)dpParseXMLNodeOutput, (Node)saxParseXMLNodeOutput, XMLUtils$.MODULE$.compareAndReport$default$3(), true, true, XMLUtils$.MODULE$.compareAndReport$default$6(), XMLUtils$.MODULE$.compareAndReport$default$7());
        }
        catch (XMLUtils.XMLDifferenceException e) {
            throw TDMLException$.MODULE$.apply("SAX parse output (actual) does not match DataProcessor Parse output (expected)\n" + e.getMessage(), (Option)None$.MODULE$);
        }
    }

    private void verifySameDiagnostics(Seq<String> seqDiagExpected, Seq<String> seqDiagActual) {
        Seq expected = (Seq)seqDiagExpected.sorted((Ordering)Ordering.String$.MODULE$);
        Seq actual = (Seq)seqDiagActual.sorted((Ordering)Ordering.String$.MODULE$);
        Seq seq = expected;
        Seq seq2 = actual;
        if (seq == null ? seq2 != null : !seq.equals(seq2)) {
            throw TDMLException$.MODULE$.apply("SAX parse/unparse diagnostics do not match DataProcessor diagnostics\nDataProcessor Parse diagnostics: " + seqDiagExpected + (String)(seqDiagActual.isEmpty() ? "\nNo SAX diagnostics were generated." : "\nSAX Parse diagnostics: " + seqDiagActual), (Option)None$.MODULE$);
        }
    }

    private static final String tdmlApiInfosetsEnv$lzyINIT1$$anonfun$1() {
        return "scala";
    }
}

