/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.network.messages;

import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.network.messages.ClusterStateMessage;
import org.apache.ignite3.internal.cluster.management.network.messages.ClusterStateMessageBuilder;
import org.apache.ignite3.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class ClusterStateMessageDeserializer
implements MessageDeserializer<ClusterStateMessage> {
    private final ClusterStateMessageBuilder msg;

    ClusterStateMessageDeserializer(CmgMessagesFactory messageFactory) {
        this.msg = messageFactory.clusterStateMessage();
    }

    @Override
    public Class<ClusterStateMessage> klass() {
        return ClusterStateMessage.class;
    }

    @Override
    public ClusterStateMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ClusterState tmp = (ClusterState)reader.readMessage("clusterState");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.clusterState(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClusterStateMessage.class);
    }
}

