/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5;

import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.dist.client.PubResult;
import org.apache.bifromq.mqtt.handler.IMQTTProtocolHelper;
import org.apache.bifromq.mqtt.handler.RoutedMessage;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.handler.record.SubTask;
import org.apache.bifromq.mqtt.handler.record.SubTasks;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageBuilders;
import org.apache.bifromq.mqtt.handler.v5.MQTT5MessageUtils;
import org.apache.bifromq.mqtt.handler.v5.ReceiverTopicAliasManager;
import org.apache.bifromq.mqtt.handler.v5.SenderTopicAliasManager;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5DisconnectReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5PubAckReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5PubCompReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5PubRecReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5PubRelReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5SubAckReasonCode;
import org.apache.bifromq.mqtt.handler.v5.reason.MQTT5UnsubAckReasonCode;
import org.apache.bifromq.mqtt.spi.IUserPropsCustomizer;
import org.apache.bifromq.plugin.authprovider.type.CheckResult;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.BadPacket;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ByServer;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ExceedPubRate;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ExceedReceivingLimit;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.Idle;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.InboxTransientError;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.InvalidTopic;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.Kicked;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.MalformedTopic;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.MalformedTopicFilter;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.NoPubPermission;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ProtocolViolation;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.Redirect;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ResourceThrottled;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ServerBusy;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.TooLargeSubscription;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.TooLargeUnsubscription;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.QoS1PubAcked;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.disthandling.QoS2PubReced;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.sysprops.props.SanityCheckMqttUtf8String;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.RetainHandling;
import org.apache.bifromq.type.UserProperties;
import org.apache.bifromq.util.TopicUtil;
import org.apache.bifromq.util.UTF8Util;

public class MQTT5ProtocolHelper
implements IMQTTProtocolHelper {
    private static final boolean SANITY_CHECK = (Boolean)SanityCheckMqttUtf8String.INSTANCE.get();
    private final TenantSettings settings;
    private final ClientInfo clientInfo;
    private final int clientReceiveMaximum;
    private final boolean requestProblemInfo;
    private final ReceiverTopicAliasManager receiverTopicAliasManager;
    private final SenderTopicAliasManager senderTopicAliasManager;
    private final IUserPropsCustomizer userPropertiesCustomizer;

    public MQTT5ProtocolHelper(MqttConnectMessage connMsg, TenantSettings settings, ClientInfo clientInfo, IUserPropsCustomizer userPropertiesCustomizer) {
        this.settings = settings;
        this.clientInfo = clientInfo;
        this.userPropertiesCustomizer = userPropertiesCustomizer;
        this.receiverTopicAliasManager = new ReceiverTopicAliasManager();
        this.senderTopicAliasManager = new SenderTopicAliasManager(MQTT5MessageUtils.topicAliasMaximum(connMsg.variableHeader().properties()).orElse(0), Duration.ofSeconds(60L));
        this.clientReceiveMaximum = Math.max(settings.minSendPerSec, MQTT5MessageUtils.receiveMaximum(connMsg.variableHeader().properties()).orElse(65535));
        this.requestProblemInfo = MQTT5MessageUtils.requestProblemInformation(connMsg.variableHeader().properties());
    }

    @Override
    public UserProperties getUserProps(MqttPublishMessage mqttMessage) {
        return MQTT5MessageUtils.toUserProperties(mqttMessage.variableHeader().properties());
    }

    @Override
    public UserProperties getUserProps(MqttUnsubscribeMessage mqttMessage) {
        return MQTT5MessageUtils.toUserProperties(mqttMessage.idAndPropertiesVariableHeader().properties());
    }

    @Override
    public boolean checkPacketIdUsage() {
        return true;
    }

    @Override
    public ProtocolResponse onInboxTransientError(String reason) {
        return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ImplementationSpecificError).reasonString(reason).build(), new Event[]{((InboxTransientError)ThreadLocalEventPool.getLocal(InboxTransientError.class)).reason(reason).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onInboxBusy(String reason) {
        return ProtocolResponse.farewell((MqttMessage)MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_BUSY).properties(MQTT5MessageBuilders.connAckProperties().build()).build(), new Event[]{((ServerBusy)ThreadLocalEventPool.getLocal(ServerBusy.class)).reason(reason).clientInfo(this.clientInfo)});
    }

    @Override
    public Optional<Integer> sessionExpiryIntervalOnDisconnect(MqttMessage disconnectMessage) {
        MqttReasonCodeAndPropertiesVariableHeader variableHeader = (MqttReasonCodeAndPropertiesVariableHeader)disconnectMessage.variableHeader();
        return Optional.ofNullable((MqttProperties.IntegerProperty)variableHeader.properties().getProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value())).map(MqttProperties.MqttProperty::value);
    }

    @Override
    public ProtocolResponse onServerShuttingDown() {
        return ProtocolResponse.farewellNow(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ServerShuttingDown).build(), new Event[]{((ByServer)ThreadLocalEventPool.getLocal(ByServer.class)).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onResourceExhaustedDisconnect(TenantResourceType resourceType) {
        return ProtocolResponse.farewellNow(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.QuotaExceeded).reasonString(resourceType.name()).build(), new Event[]{((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(resourceType.name()).clientInfo(this.clientInfo), ((ResourceThrottled)ThreadLocalEventPool.getLocal(ResourceThrottled.class)).reason(resourceType.name()).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse respondDisconnectProtocolError() {
        return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MQTT5-3.14.2.2.2").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.14.2.2.2").clientInfo(this.clientInfo)});
    }

    @Override
    public boolean isNormalDisconnect(MqttMessage message) {
        MqttReasonCodeAndPropertiesVariableHeader variableHeader = (MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader();
        return variableHeader.reasonCode() == MQTT5DisconnectReasonCode.Normal.value();
    }

    @Override
    public boolean isDisconnectWithLWT(MqttMessage message) {
        MqttReasonCodeAndPropertiesVariableHeader variableHeader = (MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader();
        return variableHeader.reasonCode() == MQTT5DisconnectReasonCode.DisconnectWithWillMessage.value();
    }

    @Override
    public ProtocolResponse respondDecodeError(MqttMessage message) {
        if (message.decoderResult().cause() instanceof TooLongFrameException) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.PacketTooLarge).build(), new Event[]{((BadPacket)ThreadLocalEventPool.getLocal(BadPacket.class)).cause(message.decoderResult().cause()).clientInfo(this.clientInfo)});
        }
        return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.MalformedPacket).reasonString(message.decoderResult().cause().getMessage()).build(), new Event[]{((BadPacket)ThreadLocalEventPool.getLocal(BadPacket.class)).cause(message.decoderResult().cause()).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse respondDuplicateConnect(MqttConnectMessage message) {
        return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MQTT5-3.1.0-2").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.1.0-2").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse validateSubMessage(MqttSubscribeMessage message) {
        List topicSubscriptions = message.payload().topicSubscriptions();
        if (topicSubscriptions.isEmpty()) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MQTT5-3.8.3-2").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.8.3-2").clientInfo(this.clientInfo)});
        }
        if (topicSubscriptions.size() > this.settings.maxTopicFiltersPerSub) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.AdministrativeAction).build(), new Event[]{((TooLargeSubscription)ThreadLocalEventPool.getLocal(TooLargeSubscription.class)).actual(topicSubscriptions.size()).max(this.settings.maxTopicFiltersPerSub).clientInfo(this.clientInfo)});
        }
        for (MqttTopicSubscription topicSub : topicSubscriptions) {
            if (UTF8Util.isWellFormed((String)topicSub.topicFilter(), (boolean)SANITY_CHECK)) continue;
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.MalformedPacket).reasonString("Malformed topic filter:" + topicSub.topicFilter()).build(), new Event[]{((MalformedTopicFilter)ThreadLocalEventPool.getLocal(MalformedTopicFilter.class)).topicFilter(topicSub.topicFilter()).clientInfo(this.clientInfo)});
        }
        Optional<Integer> subId = Optional.ofNullable((MqttProperties.IntegerProperty)message.idAndPropertiesVariableHeader().properties().getProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value())).map(MqttProperties.MqttProperty::value);
        if (subId.isPresent()) {
            if (subId.get() == 0) {
                return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MQTT5-3.8.2.1.2").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.8.2.1.2").clientInfo(this.clientInfo)});
            }
            if (!this.settings.subscriptionIdentifierEnabled) {
                return ProtocolResponse.response((MqttMessage)MQTT5MessageBuilders.subAck().packetId(message.variableHeader().messageId()).reasonCodes((MQTT5SubAckReasonCode[])topicSubscriptions.stream().map(s -> MQTT5SubAckReasonCode.SubscriptionIdentifierNotSupported).toArray(MQTT5SubAckReasonCode[]::new)).build(), new Event[0]);
            }
        }
        return null;
    }

    @Override
    public SubTasks getSubTask(MqttSubscribeMessage message) {
        Optional<Integer> subId = Optional.ofNullable((MqttProperties.IntegerProperty)message.idAndPropertiesVariableHeader().properties().getProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value())).map(MqttProperties.MqttProperty::value);
        List<SubTask> subTasks = message.payload().topicSubscriptions().stream().map(sub -> new SubTask(sub.topicFilter(), QoS.forNumber((int)sub.option().qos().value()), sub.option().isRetainAsPublished(), sub.option().isNoLocal(), RetainHandling.forNumber((int)sub.option().retainHandling().value()), subId, HLC.INST.get())).toList();
        UserProperties userProps = MQTT5MessageUtils.toUserProperties(message.idAndPropertiesVariableHeader().properties());
        return new SubTasks(subTasks, userProps);
    }

    @Override
    public ProtocolResponse onSubBackPressured(MqttSubscribeMessage subMessage) {
        return ProtocolResponse.response((MqttMessage)MQTT5MessageBuilders.subAck().packetId(subMessage.variableHeader().messageId()).reasonCodes(MQTT5SubAckReasonCode.ImplementationSpecificError).reasonString("Too many subscribe").build(), new Event[]{((ServerBusy)ThreadLocalEventPool.getLocal(ServerBusy.class)).reason("Too many subscribe").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse buildSubAckMessage(MqttSubscribeMessage subMessage, List<IMQTTProtocolHelper.SubResult> results) {
        MQTT5MessageBuilders.SubAckBuilder subAckBuilder = MQTT5MessageBuilders.subAck().packetId(subMessage.variableHeader().messageId());
        MQTT5SubAckReasonCode[] reasonCodes = new MQTT5SubAckReasonCode[results.size()];
        assert (subMessage.payload().topicSubscriptions().size() == results.size());
        for (int i = 0; i < results.size(); ++i) {
            reasonCodes[i] = switch (results.get(i)) {
                case IMQTTProtocolHelper.SubResult.OK, IMQTTProtocolHelper.SubResult.EXISTS -> MQTT5SubAckReasonCode.valueOf(((MqttTopicSubscription)subMessage.payload().topicSubscriptions().get(i)).option().qos().value());
                case IMQTTProtocolHelper.SubResult.EXCEED_LIMIT -> MQTT5SubAckReasonCode.QuotaExceeded;
                case IMQTTProtocolHelper.SubResult.TOPIC_FILTER_INVALID -> MQTT5SubAckReasonCode.TopicFilterInvalid;
                case IMQTTProtocolHelper.SubResult.NOT_AUTHORIZED -> MQTT5SubAckReasonCode.NotAuthorized;
                case IMQTTProtocolHelper.SubResult.WILDCARD_NOT_SUPPORTED -> MQTT5SubAckReasonCode.WildcardSubscriptionsNotSupported;
                case IMQTTProtocolHelper.SubResult.SUBSCRIPTION_IDENTIFIER_NOT_SUPPORTED -> MQTT5SubAckReasonCode.SubscriptionIdentifierNotSupported;
                case IMQTTProtocolHelper.SubResult.SHARED_SUBSCRIPTION_NOT_SUPPORTED -> MQTT5SubAckReasonCode.SharedSubscriptionsNotSupported;
                case IMQTTProtocolHelper.SubResult.TRY_LATER -> {
                    subAckBuilder.reasonString(results.get(i).name());
                    yield MQTT5SubAckReasonCode.ImplementationSpecificError;
                }
                default -> MQTT5SubAckReasonCode.UnspecifiedError;
            };
        }
        return ProtocolResponse.response((MqttMessage)subAckBuilder.reasonCodes(reasonCodes).build(), new Event[0]);
    }

    @Override
    public MqttSubAckMessage respondPacketIdInUse(MqttSubscribeMessage message) {
        return MQTT5MessageBuilders.subAck().packetId(message.variableHeader().messageId()).reasonCodes((MQTT5SubAckReasonCode[])message.payload().topicSubscriptions().stream().map(v -> MQTT5SubAckReasonCode.PacketIdentifierInUse).toArray(MQTT5SubAckReasonCode[]::new)).build();
    }

    @Override
    public ProtocolResponse validateUnsubMessage(MqttUnsubscribeMessage message) {
        List topicFilters = message.payload().topics();
        if (topicFilters.isEmpty()) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MQTT5-3.10.3-2").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.10.3-2").clientInfo(this.clientInfo)});
        }
        if (topicFilters.size() > this.settings.maxTopicFiltersPerSub) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.AdministrativeAction).build(), new Event[]{((TooLargeUnsubscription)ThreadLocalEventPool.getLocal(TooLargeUnsubscription.class)).max(this.settings.maxTopicFiltersPerSub).actual(topicFilters.size()).clientInfo(this.clientInfo)});
        }
        for (String topicFilter : topicFilters) {
            if (UTF8Util.isWellFormed((String)topicFilter, (boolean)SANITY_CHECK)) continue;
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.MalformedPacket).reasonString("Malformed topic filter:" + topicFilter).build(), new Event[]{((MalformedTopicFilter)ThreadLocalEventPool.getLocal(MalformedTopicFilter.class)).topicFilter(topicFilter).clientInfo(this.clientInfo), ((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.8.3-2").clientInfo(this.clientInfo)});
        }
        return null;
    }

    @Override
    public MqttUnsubAckMessage respondPacketIdInUse(MqttUnsubscribeMessage message) {
        return MQTT5MessageBuilders.unsubAck().packetId(message.variableHeader().messageId()).addReasonCodes((MQTT5UnsubAckReasonCode[])message.payload().topics().stream().map(v -> MQTT5UnsubAckReasonCode.PacketIdentifierInUse).toArray(MQTT5UnsubAckReasonCode[]::new)).build();
    }

    @Override
    public ProtocolResponse onUnsubBackPressured(MqttUnsubscribeMessage unsubMessage) {
        return ProtocolResponse.response((MqttMessage)MQTT5MessageBuilders.unsubAck().packetId(unsubMessage.variableHeader().messageId()).addReasonCode(MQTT5UnsubAckReasonCode.ImplementationSpecificError).reasonString("Too many unsubscribe").build(), new Event[]{((ServerBusy)ThreadLocalEventPool.getLocal(ServerBusy.class)).reason("Too many unsubscribe").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse buildUnsubAckMessage(MqttUnsubscribeMessage unsubMessage, List<IMQTTProtocolHelper.UnsubResult> results) {
        MQTT5MessageBuilders.UnsubAckBuilder unsubAckBuilder = MQTT5MessageBuilders.unsubAck().packetId(unsubMessage.variableHeader().messageId());
        MQTT5UnsubAckReasonCode[] reasonCodes = (MQTT5UnsubAckReasonCode[])results.stream().map(result -> switch (result) {
            case IMQTTProtocolHelper.UnsubResult.OK -> MQTT5UnsubAckReasonCode.Success;
            case IMQTTProtocolHelper.UnsubResult.NO_SUB -> MQTT5UnsubAckReasonCode.NoSubscriptionExisted;
            case IMQTTProtocolHelper.UnsubResult.TOPIC_FILTER_INVALID -> MQTT5UnsubAckReasonCode.TopicFilterInvalid;
            case IMQTTProtocolHelper.UnsubResult.NOT_AUTHORIZED -> MQTT5UnsubAckReasonCode.NotAuthorized;
            case IMQTTProtocolHelper.UnsubResult.TRY_LATER -> {
                unsubAckBuilder.reasonString(result.name());
                yield MQTT5UnsubAckReasonCode.ImplementationSpecificError;
            }
            default -> MQTT5UnsubAckReasonCode.UnspecifiedError;
        }).toArray(MQTT5UnsubAckReasonCode[]::new);
        return ProtocolResponse.response((MqttMessage)MQTT5MessageBuilders.unsubAck().packetId(unsubMessage.variableHeader().messageId()).addReasonCodes(reasonCodes).build(), new Event[0]);
    }

    @Override
    public MqttMessage onPubRelReceived(MqttMessage message, boolean packetIdFound) {
        if (packetIdFound) {
            return MQTT5MessageBuilders.pubComp(this.requestProblemInfo).packetId(((MqttMessageIdVariableHeader)message.variableHeader()).messageId()).reasonCode(MQTT5PubCompReasonCode.Success).build();
        }
        return MQTT5MessageBuilders.pubComp(this.requestProblemInfo).packetId(((MqttMessageIdVariableHeader)message.variableHeader()).messageId()).reasonCode(MQTT5PubCompReasonCode.PacketIdentifierNotFound).build();
    }

    @Override
    public boolean isQoS2Received(MqttMessage message) {
        MqttPubReplyMessageVariableHeader variableHeader = (MqttPubReplyMessageVariableHeader)message.variableHeader();
        MQTT5PubRecReasonCode reasonCode = MQTT5PubRecReasonCode.valueOf(variableHeader.reasonCode());
        return reasonCode == MQTT5PubRecReasonCode.Success || reasonCode == MQTT5PubRecReasonCode.NoMatchingSubscribers;
    }

    @Override
    public ProtocolResponse respondPubRecMsg(MqttMessage message, boolean packetIdNotFound) {
        MqttPubReplyMessageVariableHeader variableHeader = (MqttPubReplyMessageVariableHeader)message.variableHeader();
        int packetId = variableHeader.messageId();
        if (packetIdNotFound) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.pubRel(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRelReasonCode.PacketIdentifierNotFound).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-4.3.3-8").clientInfo(this.clientInfo)});
        }
        return ProtocolResponse.response(MQTT5MessageBuilders.pubRel(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRelReasonCode.Success).build(), new Event[0]);
    }

    @Override
    public int clientReceiveMaximum() {
        return this.clientReceiveMaximum;
    }

    @Override
    public ProtocolResponse onKick(ClientInfo killer) {
        return ProtocolResponse.farewellNow(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.SessionTakenOver).reasonString(killer.getMetadataOrDefault("address", "")).build(), new Event[]{((Kicked)ThreadLocalEventPool.getLocal(Kicked.class)).kicker(killer).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onRedirect(boolean isPermanent, String serverReference) {
        return ProtocolResponse.farewellNow(MQTT5MessageBuilders.disconnect().reasonCode(isPermanent ? MQTT5DisconnectReasonCode.ServerMoved : MQTT5DisconnectReasonCode.UseAnotherServer).serverReference(serverReference).build(), new Event[]{((Redirect)ThreadLocalEventPool.getLocal(Redirect.class)).isPermanent(isPermanent).clientInfo(this.clientInfo)});
    }

    @Override
    public MqttPublishMessage buildMqttPubMessage(int packetId, RoutedMessage message, boolean isDup) {
        Optional<SenderTopicAliasManager.AliasCreationResult> aliasCreationResult = this.senderTopicAliasManager.tryAlias(message.topic());
        if (aliasCreationResult.isPresent()) {
            if (aliasCreationResult.get().isFirstTime()) {
                return MQTT5MessageBuilders.pub().packetId(packetId).setupAlias(true).topicAlias(aliasCreationResult.get().alias()).message(message).build();
            }
            return MQTT5MessageBuilders.pub().packetId(packetId).topicAlias(aliasCreationResult.get().alias()).message(message).build();
        }
        Iterable extraUserProps = this.userPropertiesCustomizer.outbound(message.topic(), message.message(), message.publisher(), message.topicFilter(), message.option(), this.clientInfo, message.hlc());
        return MQTT5MessageBuilders.pub().packetId(packetId).message(message).extraUserProps(extraUserProps).build();
    }

    @Override
    public ProtocolResponse respondReceivingMaximumExceeded(MqttPublishMessage message) {
        return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ReceiveMaximumExceeded).build(), new Event[]{((ExceedReceivingLimit)ThreadLocalEventPool.getLocal(ExceedReceivingLimit.class)).limit(this.settings.receiveMaximum).clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse respondPubRateExceeded(MqttPublishMessage message) {
        return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.MessageRateToHigh).build(), new Event[]{((ExceedPubRate)ThreadLocalEventPool.getLocal(ExceedPubRate.class)).limit(this.settings.maxMsgPerSec).clientInfo(this.clientInfo)});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProtocolResponse validatePubMessage(MqttPublishMessage message) {
        if (message.fixedHeader().isRetain() && !this.settings.retainEnabled) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.RetainNotSupported).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.2.2-14").clientInfo(this.clientInfo)});
        }
        if (message.fixedHeader().qosLevel().value() > this.settings.maxQoS.getNumber()) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.QoSNotSupported).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.2.2-11").clientInfo(this.clientInfo)});
        }
        String topic = message.variableHeader().topicName();
        MqttProperties mqttProperties = message.variableHeader().properties();
        if (MQTT5MessageUtils.messageExpiryInterval(mqttProperties).orElse(Integer.MAX_VALUE) < 0) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MessageExpiryInterval must be non-negative integer").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MessageExpiryInterval must be non-negative integer").clientInfo(this.clientInfo)});
        }
        if (MQTT5MessageUtils.subscriptionIdentifier(mqttProperties).isPresent()) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MQTT5-3.3.4-6").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.3.4-6").clientInfo(this.clientInfo)});
        }
        if (!UTF8Util.isWellFormed((String)topic, (boolean)SANITY_CHECK)) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.MalformedPacket).reasonString("Malformed topic:" + topic).build(), new Event[]{((MalformedTopic)ThreadLocalEventPool.getLocal(MalformedTopic.class)).topic(topic).clientInfo(this.clientInfo)});
        }
        if (!topic.isEmpty() && !TopicUtil.isValidTopic((String)topic, (int)this.settings.maxTopicLevelLength, (int)this.settings.maxTopicLevels, (int)this.settings.maxTopicLength)) {
            switch (message.fixedHeader().qosLevel()) {
                case AT_MOST_ONCE: {
                    return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.TopicNameInvalid).reasonString("Invalid topic:" + topic).build(), new Event[]{((InvalidTopic)ThreadLocalEventPool.getLocal(InvalidTopic.class)).topic(topic).clientInfo(this.clientInfo)});
                }
                case AT_LEAST_ONCE: {
                    return ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(message.variableHeader().packetId()).reasonCode(MQTT5PubAckReasonCode.TopicNameInvalid).reasonString("Invalid topic:" + topic).build(), new Event[]{((InvalidTopic)ThreadLocalEventPool.getLocal(InvalidTopic.class)).topic(topic).clientInfo(this.clientInfo)});
                }
                case EXACTLY_ONCE: {
                    return ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(message.variableHeader().packetId()).reasonCode(MQTT5PubRecReasonCode.TopicNameInvalid).reasonString("Invalid topic:" + topic).build(), new Event[]{((InvalidTopic)ThreadLocalEventPool.getLocal(InvalidTopic.class)).topic(topic).clientInfo(this.clientInfo)});
                }
            }
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.MalformedPacket).reasonString("Unexpected QoS").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Unexpected QoS:" + String.valueOf(message.fixedHeader().qosLevel())).clientInfo(this.clientInfo)});
        }
        if (message.fixedHeader().qosLevel() == MqttQoS.AT_MOST_ONCE && message.fixedHeader().isDup()) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MQTT5-3.3.1-2").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.3.1-2").clientInfo(this.clientInfo)});
        }
        Optional<String> responseTopic = MQTT5MessageUtils.responseTopic(mqttProperties);
        if (responseTopic.map(respTopic -> !UTF8Util.isWellFormed((String)respTopic, (boolean)SANITY_CHECK)).orElse(false).booleanValue()) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.MalformedPacket).reasonString("Malformed response topic").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.3.2-13").clientInfo(this.clientInfo)});
        }
        if (responseTopic.map(respTopic -> !TopicUtil.isValidTopic((String)respTopic, (int)this.settings.maxTopicLevelLength, (int)this.settings.maxTopicLevels, (int)this.settings.maxTopicLength)).orElse(false).booleanValue()) {
            switch (message.fixedHeader().qosLevel()) {
                case AT_MOST_ONCE: {
                    return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.TopicNameInvalid).reasonString("Invalid response topic:" + responseTopic.get()).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.3.2-14").clientInfo(this.clientInfo)});
                }
                case AT_LEAST_ONCE: {
                    return ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(message.variableHeader().packetId()).reasonCode(MQTT5PubAckReasonCode.TopicNameInvalid).reasonString("Invalid response topic:" + responseTopic.get()).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.3.2-14").clientInfo(this.clientInfo)});
                }
                case EXACTLY_ONCE: {
                    return ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(message.variableHeader().packetId()).reasonCode(MQTT5PubRecReasonCode.TopicNameInvalid).reasonString("Invalid response topic:" + responseTopic.get()).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.3.2-14").clientInfo(this.clientInfo)});
                }
            }
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.MalformedPacket).reasonString("Unexpected QoS").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Unexpected QoS:" + String.valueOf(message.fixedHeader().qosLevel())).clientInfo(this.clientInfo)});
        }
        if (this.settings.payloadFormatValidationEnabled && MQTT5MessageUtils.isUTF8Payload(mqttProperties) && !UTF8Util.isValidUTF8Payload((ByteBuffer)message.payload().nioBuffer())) {
            ProtocolResponse protocolResponse;
            switch (message.fixedHeader().qosLevel()) {
                case AT_MOST_ONCE: {
                    protocolResponse = ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.PayloadFormatInvalid).reasonString("MQTT5-3.3.2.3.2").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.3.2.3.2").clientInfo(this.clientInfo)});
                    return protocolResponse;
                }
                case AT_LEAST_ONCE: {
                    protocolResponse = ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(message.variableHeader().packetId()).reasonCode(MQTT5PubAckReasonCode.PayloadFormatInvalid).build(), new Event[0]);
                    return protocolResponse;
                }
                case EXACTLY_ONCE: {
                    protocolResponse = ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(message.variableHeader().packetId()).reasonCode(MQTT5PubRecReasonCode.PayloadFormatInvalid).build(), new Event[0]);
                    return protocolResponse;
                }
                default: {
                    protocolResponse = ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("Invalid QoS").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("Invalid QoS").clientInfo(this.clientInfo)});
                }
            }
            return protocolResponse;
        }
        Optional<Integer> topicAlias = MQTT5MessageUtils.topicAlias(mqttProperties);
        if (this.settings.maxTopicAlias == 0 && topicAlias.isPresent()) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.TopicAliasInvalid).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.2.2-18").clientInfo(this.clientInfo)});
        }
        if (this.settings.maxTopicAlias > 0 && topicAlias.orElse(0) > this.settings.maxTopicAlias) {
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.TopicAliasInvalid).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.2.2-17").clientInfo(this.clientInfo)});
        }
        if (topic.isEmpty()) {
            if (!topicAlias.isPresent()) return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MQTT5-3.3.4").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.3.4").clientInfo(this.clientInfo)});
            Optional<String> aliasedTopic = this.receiverTopicAliasManager.getTopic(topicAlias.get());
            if (!aliasedTopic.isEmpty()) return null;
            return ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ProtocolError).reasonString("MQTT5-3.3.4").build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-3.3.4").clientInfo(this.clientInfo)});
        }
        topicAlias.ifPresent(integer -> this.receiverTopicAliasManager.setAlias(topic, (int)integer));
        return null;
    }

    @Override
    public String getTopic(MqttPublishMessage message) {
        String topic = message.variableHeader().topicName();
        if (topic.isEmpty()) {
            MqttProperties pubMsgProperties = message.variableHeader().properties();
            Optional<Integer> topicAlias = MQTT5MessageUtils.topicAlias(pubMsgProperties);
            assert (topicAlias.isPresent());
            Optional<String> aliasedTopic = this.receiverTopicAliasManager.getTopic(topicAlias.get());
            assert (aliasedTopic.isPresent());
            topic = aliasedTopic.get();
        }
        return topic;
    }

    @Override
    public Message buildDistMessage(MqttPublishMessage message, ClientInfo publisher) {
        return MQTT5MessageUtils.toMessage(message, publisher, this.userPropertiesCustomizer);
    }

    @Override
    public ProtocolResponse onQoS0DistDenied(String topic, Message distMessage, CheckResult result) {
        assert (!result.hasGranted());
        return switch (result.getTypeCase()) {
            case CheckResult.TypeCase.DENIED -> ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.NotAuthorized).reasonString(result.getDenied().hasReason() ? result.getDenied().getReason() : null).userProps(result.getDenied().getUserProps()).build(), new Event[]{((NoPubPermission)ThreadLocalEventPool.getLocal(NoPubPermission.class)).topic(topic).qos(QoS.AT_MOST_ONCE).retain(distMessage.getIsRetain()).clientInfo(this.clientInfo)});
            case CheckResult.TypeCase.ERROR -> ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.ImplementationSpecificError).reasonString(result.getError().hasReason() ? result.getError().getReason() : null).userProps(result.getError().getUserProps()).build(), new Event[]{((NoPubPermission)ThreadLocalEventPool.getLocal(NoPubPermission.class)).topic(topic).qos(QoS.AT_MOST_ONCE).retain(distMessage.getIsRetain()).clientInfo(this.clientInfo)});
            default -> ProtocolResponse.farewell(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.UnspecifiedError).build(), new Event[]{((NoPubPermission)ThreadLocalEventPool.getLocal(NoPubPermission.class)).topic(topic).qos(QoS.AT_MOST_ONCE).retain(distMessage.getIsRetain()).clientInfo(this.clientInfo)});
        };
    }

    @Override
    public ProtocolResponse onQoS0PubHandled(PubResult result, MqttPublishMessage message, UserProperties userProps) {
        return ProtocolResponse.responseNothing(new Event[0]);
    }

    @Override
    public ProtocolResponse onQoS1DistDenied(String topic, int packetId, Message distMessage, CheckResult result) {
        assert (!result.hasGranted());
        return switch (result.getTypeCase()) {
            case CheckResult.TypeCase.DENIED -> ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubAckReasonCode.NotAuthorized).reasonString(result.getDenied().hasReason() ? result.getDenied().getReason() : null).userProps(result.getDenied().getUserProps()).build(), new Event[0]);
            case CheckResult.TypeCase.ERROR -> ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubAckReasonCode.ImplementationSpecificError).reasonString(result.getError().hasReason() ? result.getError().getReason() : null).userProps(result.getError().getUserProps()).build(), new Event[0]);
            default -> ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubAckReasonCode.UnspecifiedError).build(), new Event[0]);
        };
    }

    @Override
    public ProtocolResponse respondQoS1PacketInUse(MqttPublishMessage message) {
        return ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(message.variableHeader().packetId()).reasonCode(MQTT5PubAckReasonCode.PacketIdentifierInUse).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT5-2.2.1-4").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onQoS1PubHandled(PubResult result, MqttPublishMessage message, UserProperties userProps) {
        int packetId = message.variableHeader().packetId();
        Event[] debugEvents = this.settings.debugMode ? new Event[]{((QoS1PubAcked)((QoS1PubAcked)((QoS1PubAcked)((QoS1PubAcked)ThreadLocalEventPool.getLocal(QoS1PubAcked.class)).reqId((long)packetId)).isDup(message.fixedHeader().isDup()).topic(message.variableHeader().topicName())).size(message.payload().readableBytes())).clientInfo(this.clientInfo)} : new Event[]{};
        switch (result) {
            case OK: {
                return ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubAckReasonCode.Success).userProps(userProps).build(), debugEvents);
            }
            case NO_MATCH: {
                return ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubAckReasonCode.NoMatchingSubscribers).userProps(userProps).build(), debugEvents);
            }
            case BACK_PRESSURE_REJECTED: {
                return ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubAckReasonCode.ImplementationSpecificError).reasonString("ServerBusy").userProps(userProps).build(), debugEvents);
            }
            case TRY_LATER: {
                return ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubAckReasonCode.ImplementationSpecificError).reasonString(result.name()).userProps(userProps).build(), debugEvents);
            }
        }
        return ProtocolResponse.response(MQTT5MessageBuilders.pubAck(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubAckReasonCode.UnspecifiedError).userProps(userProps).build(), debugEvents);
    }

    @Override
    public ProtocolResponse respondQoS2PacketInUse(MqttPublishMessage message) {
        return ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(message.variableHeader().packetId()).reasonCode(MQTT5PubRecReasonCode.PacketIdentifierInUse).build(), new Event[]{((ProtocolViolation)ThreadLocalEventPool.getLocal(ProtocolViolation.class)).statement("MQTT3-2.2.1-4").clientInfo(this.clientInfo)});
    }

    @Override
    public ProtocolResponse onQoS2DistDenied(String topic, int packetId, Message distMessage, CheckResult result) {
        assert (!result.hasGranted());
        return switch (result.getTypeCase()) {
            case CheckResult.TypeCase.DENIED -> ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRecReasonCode.NotAuthorized).reasonString(result.getDenied().hasReason() ? result.getDenied().getReason() : null).userProps(result.getDenied().getUserProps()).build(), new Event[0]);
            case CheckResult.TypeCase.ERROR -> ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRecReasonCode.ImplementationSpecificError).reasonString(result.getError().hasReason() ? result.getError().getReason() : null).userProps(result.getError().getUserProps()).build(), new Event[0]);
            default -> ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRecReasonCode.UnspecifiedError).build(), new Event[0]);
        };
    }

    @Override
    public ProtocolResponse onQoS2PubHandled(PubResult result, MqttPublishMessage message, UserProperties userProps) {
        int packetId = message.variableHeader().packetId();
        Event[] debugEvents = this.settings.debugMode ? new Event[]{((QoS2PubReced)((QoS2PubReced)((QoS2PubReced)((QoS2PubReced)ThreadLocalEventPool.getLocal(QoS2PubReced.class)).reqId((long)packetId)).isDup(message.fixedHeader().isDup()).topic(message.variableHeader().topicName())).size(message.payload().readableBytes())).clientInfo(this.clientInfo)} : new Event[]{};
        switch (result) {
            case OK: {
                return ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRecReasonCode.Success).userProps(userProps).build(), debugEvents);
            }
            case NO_MATCH: {
                return ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRecReasonCode.NoMatchingSubscribers).userProps(userProps).build(), debugEvents);
            }
            case BACK_PRESSURE_REJECTED: {
                return ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRecReasonCode.ImplementationSpecificError).reasonString("ServerBusy").userProps(userProps).build(), debugEvents);
            }
            case TRY_LATER: {
                return ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRecReasonCode.ImplementationSpecificError).reasonString(result.name()).userProps(userProps).build(), debugEvents);
            }
        }
        return ProtocolResponse.response(MQTT5MessageBuilders.pubRec(this.requestProblemInfo).packetId(packetId).reasonCode(MQTT5PubRecReasonCode.UnspecifiedError).userProps(userProps).build(), debugEvents);
    }

    @Override
    public ProtocolResponse onIdleTimeout(int keepAliveTimeSeconds) {
        return ProtocolResponse.farewellNow(MQTT5MessageBuilders.disconnect().reasonCode(MQTT5DisconnectReasonCode.KeepAliveTimeout).build(), new Event[]{((Idle)ThreadLocalEventPool.getLocal(Idle.class)).keepAliveTimeSeconds(keepAliveTimeSeconds).clientInfo(this.clientInfo)});
    }
}

