/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Ticker;
import com.google.protobuf.ByteString;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.dist.worker.cache.ISubscriptionCache;
import org.apache.bifromq.dist.worker.cache.ITenantRouteCache;
import org.apache.bifromq.dist.worker.cache.ITenantRouteCacheFactory;
import org.apache.bifromq.dist.worker.cache.TenantRouteCacheFactory;
import org.apache.bifromq.dist.worker.cache.task.RefreshEntriesTask;
import org.apache.bifromq.dist.worker.schema.KVSchemaUtil;
import org.apache.bifromq.dist.worker.schema.cache.Matching;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.sysprops.props.DistCachedRoutesFanoutCheckIntervalSeconds;
import org.apache.bifromq.sysprops.props.DistTopicMatchExpirySeconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionCache
implements ISubscriptionCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionCache.class);
    private final ITenantRouteCacheFactory tenantRouteCacheFactory;
    private final LoadingCache<TenantKey, ITenantRouteCache> tenantCache;
    private volatile Boundary boundary;

    public SubscriptionCache(KVRangeId id, Supplier<IKVRangeRefreshableReader> rangeReaderProvider, ISettingProvider settingProvider, IEventCollector eventCollector, Executor matchExecutor) {
        this(id, new TenantRouteCacheFactory(rangeReaderProvider, settingProvider, eventCollector, Duration.ofSeconds(((Integer)DistTopicMatchExpirySeconds.INSTANCE.get()).intValue()), Duration.ofSeconds(((Integer)DistCachedRoutesFanoutCheckIntervalSeconds.INSTANCE.get()).intValue()), matchExecutor, "id", KVRangeIdUtil.toString((KVRangeId)id)), Ticker.systemTicker());
    }

    public SubscriptionCache(KVRangeId id, ITenantRouteCacheFactory tenantRouteCacheFactory, Ticker ticker) {
        this.tenantRouteCacheFactory = tenantRouteCacheFactory;
        final long expiryNanos = tenantRouteCacheFactory.expiry().multipliedBy(2L).toNanos();
        this.tenantCache = Caffeine.newBuilder().ticker(ticker).expireAfter((Expiry)new Expiry<TenantKey, ITenantRouteCache>(){

            public long expireAfterCreate(TenantKey key, ITenantRouteCache value, long currentTime) {
                return expiryNanos;
            }

            public long expireAfterUpdate(TenantKey key, ITenantRouteCache value, long currentTime, long currentDuration) {
                return expiryNanos;
            }

            public long expireAfterRead(TenantKey key, ITenantRouteCache value, long currentTime, long currentDuration) {
                return key.refreshExpiry ? expiryNanos : currentDuration;
            }
        }).scheduler(Scheduler.systemScheduler()).evictionListener((key, cachedTenantRoutes, cause) -> {
            if (cachedTenantRoutes != null) {
                cachedTenantRoutes.destroy();
            }
        }).build(k -> tenantRouteCacheFactory.create(id, k.tenantId));
    }

    @Override
    public CompletableFuture<Set<Matching>> get(String tenantId, String topic) {
        ITenantRouteCache routesCache = (ITenantRouteCache)this.tenantCache.get((Object)TenantKey.refreshExpiry(tenantId));
        ByteString tenantStartKey = KVSchemaUtil.tenantBeginKey((String)tenantId);
        Boundary tenantBoundary = BoundaryUtil.intersect((Boundary)BoundaryUtil.toBoundary((ByteString)tenantStartKey, (ByteString)BoundaryUtil.upperBound((ByteString)tenantStartKey)), (Boundary)this.boundary);
        return routesCache.getMatch(topic, tenantBoundary);
    }

    @Override
    public boolean isCached(String tenantId, List<String> filterLevels) {
        ITenantRouteCache cache = (ITenantRouteCache)this.tenantCache.getIfPresent((Object)TenantKey.noRefreshExpiry(tenantId));
        if (cache != null) {
            return cache.isCached(filterLevels);
        }
        return false;
    }

    @Override
    public void refresh(Map<String, RefreshEntriesTask> topicFiltersByTenant) {
        topicFiltersByTenant.forEach((tenantId, topicFilters) -> {
            ITenantRouteCache cache = (ITenantRouteCache)this.tenantCache.getIfPresent((Object)TenantKey.noRefreshExpiry(tenantId));
            if (cache != null) {
                cache.refresh((RefreshEntriesTask)topicFilters);
            }
        });
    }

    @Override
    public void reset(Boundary boundary) {
        this.boundary = boundary;
    }

    @Override
    public void close() {
        this.tenantCache.invalidateAll();
        this.tenantRouteCacheFactory.close();
    }

    static class TenantKey {
        final String tenantId;
        final boolean refreshExpiry;

        private TenantKey(String tenantId, boolean refreshExpiry) {
            this.tenantId = tenantId;
            this.refreshExpiry = refreshExpiry;
        }

        static TenantKey refreshExpiry(String tenantId) {
            return new TenantKey(tenantId, true);
        }

        static TenantKey noRefreshExpiry(String tenantId) {
            return new TenantKey(tenantId, false);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TenantKey)) {
                return false;
            }
            TenantKey other = (TenantKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tenantId = this.tenantId;
            String other$tenantId = other.tenantId;
            return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TenantKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tenantId = this.tenantId;
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            return result;
        }
    }
}

