/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.auth;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.livy.Logging;
import org.apache.livy.server.auth.LdapAuthenticationHandlerImpl$;
import org.apache.livy.server.auth.LdapUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\tms!\u0002\u0016,\u0011\u00031d!\u0002\u001d,\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007\u0019\u0006\u0001\u000b\u0011\u0002#\t\u000f5\u000b!\u0019!C\u0001\u0007\"1a*\u0001Q\u0001\n\u0011CqaT\u0001C\u0002\u0013\u00051\t\u0003\u0004Q\u0003\u0001\u0006I\u0001\u0012\u0005\b#\u0006\u0011\r\u0011\"\u0001D\u0011\u0019\u0011\u0016\u0001)A\u0005\t\"91+\u0001b\u0001\n\u0003\u0019\u0005B\u0002+\u0002A\u0003%A\tC\u0004V\u0003\t\u0007I\u0011A\"\t\rY\u000b\u0001\u0015!\u0003E\u0011\u001d9\u0016A1A\u0005\u0002\rCa\u0001W\u0001!\u0002\u0013!e\u0001\u0002\u001d,\u0001eCQ\u0001Q\t\u0005\u00021DqA\\\tA\u0002\u0013%1\tC\u0004p#\u0001\u0007I\u0011\u00029\t\rY\f\u0002\u0015)\u0003E\u0011\u001d9\u0018\u00031A\u0005\n\rCq\u0001_\tA\u0002\u0013%\u0011\u0010\u0003\u0004|#\u0001\u0006K\u0001\u0012\u0005\byF\u0001\r\u0011\"\u0003D\u0011\u001di\u0018\u00031A\u0005\nyDq!!\u0001\u0012A\u0003&A\tC\u0005\u0002\u0004E\u0001\r\u0011\"\u0003\u0002\u0006!I\u0011QB\tA\u0002\u0013%\u0011q\u0002\u0005\t\u0003'\t\u0002\u0015)\u0003\u0002\b!I\u0011QC\tA\u0002\u0013%\u0011Q\u0001\u0005\n\u0003/\t\u0002\u0019!C\u0005\u00033A\u0001\"!\b\u0012A\u0003&\u0011q\u0001\u0005\b\u0003?\tB\u0011AA\u0011\u0011\u001d\t9$\u0005C\u0001\u0003sAq!!'\u0012\t\u0003\tY\nC\u0004\u0002\u001eF!\t!a(\t\u000f\u0005e\u0018\u0003\"\u0001\u0002|\"9!\u0011D\t\u0005\n\tm\u0001b\u0002B\u0019#\u0011%!1\u0007\u0005\b\u0005\u000f\nB\u0011\u0002B%\u0003uaE-\u00199BkRDWM\u001c;jG\u0006$\u0018n\u001c8IC:$G.\u001a:J[Bd'B\u0001\u0017.\u0003\u0011\tW\u000f\u001e5\u000b\u00059z\u0013AB:feZ,'O\u0003\u00021c\u0005!A.\u001b<z\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001A\u0011q'A\u0007\u0002W\tiB\nZ1q\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0011\u0006tG\r\\3s\u00136\u0004Hn\u0005\u0002\u0002uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001c\u0002)\u0005+F\u000bS(S\u0013j\u000bE+S(O?N\u001b\u0005*R'F+\u0005!\u0005CA#K\u001b\u00051%BA$I\u0003\u0011a\u0017M\\4\u000b\u0003%\u000bAA[1wC&\u00111J\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002+\u0005+F\u000bS(S\u0013j\u000bE+S(O?N\u001b\u0005*R'FA\u0005!A+\u0017)F\u0003\u0015!\u0016\fU#!\u0003]\u0019ViQ+S\u0013RKv,Q+U\u0011\u0016sE+S\"B)&{e*\u0001\rT\u000b\u000e+&+\u0013+Z?\u0006+F\u000bS#O)&\u001b\u0015\tV%P\u001d\u0002\nA\u0002\u0015*P-&#UIU0V%2\u000bQ\u0002\u0015*P-&#UIU0V%2\u0003\u0013a\u0002\"B'\u0016{FIT\u0001\t\u0005\u0006\u001bVi\u0018#OA\u0005\u0001B\nR!Q?\nKe\nR0E\u001f6\u000b\u0015JT\u0001\u0012\u0019\u0012\u000b\u0005k\u0018\"J\u001d\u0012{FiT'B\u0013:\u0003\u0013\u0001E#O\u0003\ncUiX*U\u0003J#v\f\u0016'T\u0003E)e*\u0011\"M\u000b~\u001bF+\u0011*U?Rc5\u000bI\n\u0005#ik\u0006\u000e\u0005\u0002F7&\u0011AL\u0012\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005y3W\"A0\u000b\u00059\u0002'BA1c\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!a\u00193\u0002\u0011M,7-\u001e:jifT!!Z\u0019\u0002\r!\fGm\\8q\u0013\t9wLA\u000bBkRDWM\u001c;jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0011\u0005%TW\"A\u0018\n\u0005-|#a\u0002'pO\u001eLgn\u001a\u000b\u0002[B\u0011q'E\u0001\u000bY\u0012\f\u0007\u000fR8nC&t\u0017A\u00047eCB$u.\\1j]~#S-\u001d\u000b\u0003cR\u0004\"a\u000f:\n\u0005Md$\u0001B+oSRDq!\u001e\u000b\u0002\u0002\u0003\u0007A)A\u0002yIE\n1\u0002\u001c3ba\u0012{W.Y5oA\u00051!-Y:f\t:\u000b!BY1tK\u0012su\fJ3r)\t\t(\u0010C\u0004v/\u0005\u0005\t\u0019\u0001#\u0002\u000f\t\f7/\u001a#OA\u0005Y\u0001O]8wS\u0012,'/\u0016:m\u0003=\u0001(o\u001c<jI\u0016\u0014XK\u001d7`I\u0015\fHCA9\u0000\u0011\u001d)($!AA\u0002\u0011\u000bA\u0002\u001d:pm&$WM]+sY\u0002\na\"\u001a8bE2,7\u000b^1siRc7/\u0006\u0002\u0002\bA\u00191(!\u0003\n\u0007\u0005-AHA\u0004C_>dW-\u00198\u0002%\u0015t\u0017M\u00197f'R\f'\u000f\u001e+mg~#S-\u001d\u000b\u0004c\u0006E\u0001\u0002C;\u001e\u0003\u0003\u0005\r!a\u0002\u0002\u001f\u0015t\u0017M\u00197f'R\f'\u000f\u001e+mg\u0002\n1\u0004Z5tC\ndW\rS8ti:\u000bW.\u001a,fe&4\u0017nY1uS>t\u0017a\b3jg\u0006\u0014G.\u001a%pgRt\u0015-\\3WKJLg-[2bi&|gn\u0018\u0013fcR\u0019\u0011/a\u0007\t\u0011U\u0004\u0013\u0011!a\u0001\u0003\u000f\tA\u0004Z5tC\ndW\rS8ti:\u000bW.\u001a,fe&4\u0017nY1uS>t\u0007%A\u0004hKR$\u0016\u0010]3\u0015\u0005\u0005\r\u0002\u0003BA\u0013\u0003gqA!a\n\u00020A\u0019\u0011\u0011\u0006\u001f\u000e\u0005\u0005-\"bAA\u0017k\u00051AH]8pizJ1!!\r=\u0003\u0019\u0001&/\u001a3fM&\u00191*!\u000e\u000b\u0007\u0005EB(\u0001\u0003j]&$HcA9\u0002<!9\u0011QH\u0012A\u0002\u0005}\u0012AB2p]\u001aLw\r\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)\u0005S\u0001\u0005kRLG.\u0003\u0003\u0002J\u0005\r#A\u0003)s_B,'\u000f^5fg\"*1%!\u0014\u0002dA)1(a\u0014\u0002T%\u0019\u0011\u0011\u000b\u001f\u0003\rQD'o\\<t!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\nqa]3sm2,GO\u0003\u0002\u0002^\u0005)!.\u0019<bq&!\u0011\u0011MA,\u0005A\u0019VM\u001d<mKR,\u0005pY3qi&|g.M\u0004\u001f\u0003G\t)'a&2\u0013\r\n9'a\u001c\u0002\u000e\u0006ET\u0003BA5\u0003W*\"!a\t\u0005\u000f\u00055\u0004A1\u0001\u0002x\t\tA+\u0003\u0003\u0002r\u0005M\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002vq\na\u0001\u001e5s_^\u001c\u0018\u0003BA=\u0003\u007f\u00022aOA>\u0013\r\ti\b\u0010\u0002\b\u001d>$\b.\u001b8h!\u0011\t\t)a\"\u000f\u0007m\n\u0019)C\u0002\u0002\u0006r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0006-%!\u0003+ie><\u0018M\u00197f\u0015\r\t)\tP\u0019\nG\u0005=\u0015\u0011SAJ\u0003kr1aOAI\u0013\r\t)\bP\u0019\u0006Emb\u0014Q\u0013\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005M\u0013a\u00023fgR\u0014x.\u001f\u000b\u0002c\u0006\u0019R.\u00198bO\u0016lWM\u001c;Pa\u0016\u0014\u0018\r^5p]RA\u0011qAAQ\u0003W\u000bY\fC\u0004\u0002$\u0016\u0002\r!!*\u0002\u000bQ|7.\u001a8\u0011\u0007y\u000b9+C\u0002\u0002*~\u00131#Q;uQ\u0016tG/[2bi&|g\u000eV8lK:Dq!!,&\u0001\u0004\ty+A\u0004sKF,Xm\u001d;\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gSA!!.\u0002X\u0005!\u0001\u000e\u001e;q\u0013\u0011\tI,a-\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003{+\u0003\u0019AA`\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BAY\u0003\u0003LA!a1\u00024\n\u0019\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\u001c\bo\u001c8tK\"*Q%a2\u0002VB)1(a\u0014\u0002JB!\u00111ZAi\u001b\t\tiMC\u0002\u0002P\u0002\faa\u00197jK:$\u0018\u0002BAj\u0003\u001b\u0014q#Q;uQ\u0016tG/[2bi&|g.\u0012=dKB$\u0018n\u001c82\u000fy\t\u0019#a6\u0002^FJ1%a\u001a\u0002p\u0005e\u0017\u0011O\u0019\nG\u0005=\u0015\u0011SAn\u0003k\nTAI\u001e=\u0003+\u000b4AJAeQ\u0015)\u0013\u0011]Ax!\u0015Y\u0014qJAr!\u0011\t)/a;\u000e\u0005\u0005\u001d(bAAu\u0011\u0006\u0011\u0011n\\\u0005\u0005\u0003[\f9OA\u0006J\u001f\u0016C8-\u001a9uS>t\u0017g\u0002\u0010\u0002$\u0005E\u0018q_\u0019\nG\u0005\u001d\u0014qNAz\u0003c\n\u0014bIAH\u0003#\u000b)0!\u001e2\u000b\tZD(!&2\u0007\u0019\n\u0019/\u0001\u0007bkRDWM\u001c;jG\u0006$X\r\u0006\u0004\u0002&\u0006u\u0018q \u0005\b\u0003[3\u0003\u0019AAX\u0011\u001d\tiL\na\u0001\u0003\u007fCSAJAd\u0005\u0007\ttAHA\u0012\u0005\u000b\u0011Y!M\u0005$\u0003O\nyGa\u0002\u0002rEJ1%a$\u0002\u0012\n%\u0011QO\u0019\u0006Emb\u0014QS\u0019\u0004M\u0005%\u0007&\u0002\u0014\u0002b\n=\u0011g\u0002\u0010\u0002$\tE!qC\u0019\nG\u0005\u001d\u0014q\u000eB\n\u0003c\n\u0014bIAH\u0003#\u0013)\"!\u001e2\u000b\tZD(!&2\u0007\u0019\n\u0019/\u0001\tbkRDWM\u001c;jG\u0006$X-V:feR1\u0011Q\u0015B\u000f\u0005CAqAa\b(\u0001\u0004\t\u0019#\u0001\u0005vg\u0016\u0014h*Y7f\u0011\u001d\u0011\u0019c\na\u0001\u0003G\t\u0001\u0002]1tg^|'\u000f\u001a\u0015\u0006O\u0005\u001d'qE\u0019\b=\u0005\r\"\u0011\u0006B\u0018c%\u0019\u0013qMA8\u0005W\t\t(M\u0005$\u0003\u001f\u000b\tJ!\f\u0002vE*!e\u000f\u001f\u0002\u0016F\u001aa%!3\u00029\u0005,H\u000f[3oi&\u001c\u0017\r^3XSRDG\u000b\\:FqR,gn]5p]R)\u0011O!\u000e\u0003:!9!q\u0007\u0015A\u0002\u0005\r\u0012AB;tKJ$e\nC\u0004\u0003$!\u0002\r!a\t)\u000b!\n9M!\u00102\u000fy\t\u0019Ca\u0010\u0003FEJ1%a\u001a\u0002p\t\u0005\u0013\u0011O\u0019\nG\u0005=\u0015\u0011\u0013B\"\u0003k\nTAI\u001e=\u0003+\u000b4AJAe\u0003}\tW\u000f\u001e5f]RL7-\u0019;f/&$\bn\\;u)2\u001cX\t\u001f;f]NLwN\u001c\u000b\u0006c\n-#Q\n\u0005\b\u0005oI\u0003\u0019AA\u0012\u0011\u001d\u0011\u0019#\u000ba\u0001\u0003GAS!KAd\u0005#\ntAHA\u0012\u0005'\u0012I&M\u0005$\u0003O\nyG!\u0016\u0002rEJ1%a$\u0002\u0012\n]\u0013QO\u0019\u0006Emb\u0014QS\u0019\u0004M\u0005%\u0007")
public class LdapAuthenticationHandlerImpl
implements AuthenticationHandler,
Logging {
    private String ldapDomain;
    private String baseDN;
    private String providerUrl;
    private boolean enableStartTls;
    private boolean disableHostNameVerification;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static String ENABLE_START_TLS() {
        return LdapAuthenticationHandlerImpl$.MODULE$.ENABLE_START_TLS();
    }

    public static String LDAP_BIND_DOMAIN() {
        return LdapAuthenticationHandlerImpl$.MODULE$.LDAP_BIND_DOMAIN();
    }

    public static String BASE_DN() {
        return LdapAuthenticationHandlerImpl$.MODULE$.BASE_DN();
    }

    public static String PROVIDER_URL() {
        return LdapAuthenticationHandlerImpl$.MODULE$.PROVIDER_URL();
    }

    public static String SECURITY_AUTHENTICATION() {
        return LdapAuthenticationHandlerImpl$.MODULE$.SECURITY_AUTHENTICATION();
    }

    public static String TYPE() {
        return LdapAuthenticationHandlerImpl$.MODULE$.TYPE();
    }

    public static String AUTHORIZATION_SCHEME() {
        return LdapAuthenticationHandlerImpl$.MODULE$.AUTHORIZATION_SCHEME();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        LdapAuthenticationHandlerImpl ldapAuthenticationHandlerImpl = this;
        synchronized (ldapAuthenticationHandlerImpl) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String ldapDomain() {
        return this.ldapDomain;
    }

    private void ldapDomain_$eq(String x$1) {
        this.ldapDomain = x$1;
    }

    private String baseDN() {
        return this.baseDN;
    }

    private void baseDN_$eq(String x$1) {
        this.baseDN = x$1;
    }

    private String providerUrl() {
        return this.providerUrl;
    }

    private void providerUrl_$eq(String x$1) {
        this.providerUrl = x$1;
    }

    private boolean enableStartTls() {
        return this.enableStartTls;
    }

    private void enableStartTls_$eq(boolean x$1) {
        this.enableStartTls = x$1;
    }

    private boolean disableHostNameVerification() {
        return this.disableHostNameVerification;
    }

    private void disableHostNameVerification_$eq(boolean x$1) {
        this.disableHostNameVerification = x$1;
    }

    public String getType() {
        return LdapAuthenticationHandlerImpl$.MODULE$.TYPE();
    }

    public void init(Properties config) throws ServletException {
        this.baseDN_$eq(config.getProperty(LdapAuthenticationHandlerImpl$.MODULE$.BASE_DN()));
        this.providerUrl_$eq(config.getProperty(LdapAuthenticationHandlerImpl$.MODULE$.PROVIDER_URL()));
        this.ldapDomain_$eq(config.getProperty(LdapAuthenticationHandlerImpl$.MODULE$.LDAP_BIND_DOMAIN()));
        this.enableStartTls_$eq(new StringOps(Predef$.MODULE$.augmentString(config.getProperty(LdapAuthenticationHandlerImpl$.MODULE$.ENABLE_START_TLS(), "false"))).toBoolean());
        Predef$.MODULE$.require(this.providerUrl() != null, (Function0 & Serializable & scala.Serializable)() -> "The LDAP URI can not be null");
        if (this.enableStartTls()) {
            Predef$.MODULE$.require(!this.providerUrl().toLowerCase().startsWith("ldaps"), (Function0 & Serializable & scala.Serializable)() -> "Can not use ldaps and StartTLS option at the same time");
            return;
        }
    }

    public void destroy() {
    }

    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        ObjectRef authorization = ObjectRef.create((Object)request.getHeader("Authorization"));
        if ((String)authorization.elem != null && ((String)authorization.elem).regionMatches(true, 0, LdapAuthenticationHandlerImpl$.MODULE$.AUTHORIZATION_SCHEME(), 0, LdapAuthenticationHandlerImpl$.MODULE$.AUTHORIZATION_SCHEME().length())) {
            authorization.elem = ((String)authorization.elem).substring("Basic".length()).trim();
            Base64 base64 = new Base64(0);
            String[] credentials = new String(base64.decode((String)authorization.elem), StandardCharsets.UTF_8).split(":", 2);
            if (credentials.length == 2) {
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Authenticating [").append(credentials[0]).append("] user").toString());
                token = this.authenticateUser(credentials[0], credentials[1]);
                response.setStatus(200);
            }
        } else {
            response.setHeader("WWW-Authenticate", "Basic");
            response.setStatus(401);
            if ((String)authorization.elem == null) {
                this.trace((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Basic auth starting");
            } else {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Authorization does not start with Basic : ").append((String)authorization$1.elem).append(" ").toString());
            }
        }
        return token;
    }

    private AuthenticationToken authenticateUser(String userName, String password) throws AuthenticationException {
        String bindDN;
        if (userName == null || userName.isEmpty()) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank username has been provided");
        }
        if (password == null || password.isEmpty()) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank password has been provided");
        }
        String principle = userName;
        if (!LdapUtils$.MODULE$.hasDomain(userName) && this.ldapDomain() != null) {
            principle = new StringBuilder(1).append(userName).append("@").append(this.ldapDomain()).toString();
        }
        String string = bindDN = this.baseDN() != null ? new StringBuilder(5).append("uid=").append(principle).append(",").append(this.baseDN()).toString() : principle;
        if (this.enableStartTls()) {
            this.authenticateWithTlsExtension(bindDN, password);
        } else {
            this.authenticateWithoutTlsExtension(bindDN, password);
        }
        return new AuthenticationToken(userName, userName, "ldap");
    }

    private void authenticateWithTlsExtension(String userDN, String password) throws AuthenticationException {
        InitialLdapContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.providerUrl());
        try {
            try {
                ctx = new InitialLdapContext(env, null);
                StartTlsResponse ex = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                if (this.disableHostNameVerification()) {
                    ex.setHostnameVerifier(new HostnameVerifier(null){

                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                }
                ex.negotiate();
                ctx.addToEnvironment("java.naming.security.authentication", LdapAuthenticationHandlerImpl$.MODULE$.SECURITY_AUTHENTICATION());
                ctx.addToEnvironment("java.naming.security.principal", userDN);
                ctx.addToEnvironment("java.naming.security.credentials", password);
                ctx.lookup(userDN);
                this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Authentication successful for ").append(userDN).toString());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException ? true : throwable2 instanceof NamingException) {
                    throw new AuthenticationException("Error validating LDAP user", throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException exception) {}
            }
        }
    }

    private void authenticateWithoutTlsExtension(String userDN, String password) throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.providerUrl());
        env.put("java.naming.security.authentication", LdapAuthenticationHandlerImpl$.MODULE$.SECURITY_AUTHENTICATION());
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", password);
        try {
            InitialDirContext e = new InitialDirContext(env);
            e.close();
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Authentication successful for ").append(userDN).toString());
        }
        catch (NamingException exception) {
            throw new AuthenticationException("Error validating LDAP user", (Throwable)exception);
        }
    }

    public LdapAuthenticationHandlerImpl() {
        Logging.$init$((Logging)this);
        this.ldapDomain = "null";
        this.baseDN = "null";
        this.providerUrl = "null";
        this.enableStartTls = false;
        this.disableHostNameVerification = false;
    }
}

