/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilteredLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.SearchedLogStream;

public class FilterLogEventsPublisher
implements SdkPublisher<FilterLogEventsResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final FilterLogEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public FilterLogEventsPublisher(CloudWatchLogsAsyncClient client, FilterLogEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private FilterLogEventsPublisher(CloudWatchLogsAsyncClient client, FilterLogEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new FilterLogEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super FilterLogEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FilteredLogEvent> events() {
        Function<FilterLogEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new FilterLogEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<SearchedLogStream> searchedLogStreams() {
        Function<FilterLogEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.searchedLogStreams() != null) {
                return response.searchedLogStreams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new FilterLogEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class FilterLogEventsResponseFetcher
    implements AsyncPageFetcher<FilterLogEventsResponse> {
        private FilterLogEventsResponseFetcher() {
        }

        public boolean hasNextPage(FilterLogEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<FilterLogEventsResponse> nextPage(FilterLogEventsResponse previousPage) {
            if (previousPage == null) {
                return FilterLogEventsPublisher.this.client.filterLogEvents(FilterLogEventsPublisher.this.firstRequest);
            }
            return FilterLogEventsPublisher.this.client.filterLogEvents((FilterLogEventsRequest)((Object)FilterLogEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

