/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataScan;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeleteFileIndex;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.metrics.ScanMetricsUtil;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseDistributedDataScan
extends DataScan<BatchScan, ScanTask, ScanTaskGroup<ScanTask>>
implements BatchScan {
    private static final Logger LOG = LoggerFactory.getLogger(BaseDistributedDataScan.class);
    private static final long LOCAL_PLANNING_MAX_SLOT_SIZE = 0x8000000L;
    private static final int MONITOR_POOL_SIZE = 2;
    private final int localParallelism = PLAN_SCANS_WITH_WORKER_POOL ? ThreadPools.WORKER_THREAD_POOL_SIZE : 1;
    private final long localPlanningSizeThreshold = (long)this.localParallelism * 0x8000000L;

    protected BaseDistributedDataScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    protected abstract int remoteParallelism();

    protected PlanningMode dataPlanningMode() {
        Map properties = this.table().properties();
        String modeName = properties.getOrDefault("read.data-planning-mode", TableProperties.PLANNING_MODE_DEFAULT);
        return PlanningMode.fromName(modeName);
    }

    protected boolean shouldCopyRemotelyPlannedDataFiles() {
        return true;
    }

    protected abstract Iterable<CloseableIterable<DataFile>> planDataRemotely(List<ManifestFile> var1, boolean var2);

    protected PlanningMode deletePlanningMode() {
        Map properties = this.table().properties();
        String modeName = properties.getOrDefault("read.delete-planning-mode", TableProperties.PLANNING_MODE_DEFAULT);
        return PlanningMode.fromName(modeName);
    }

    protected abstract DeleteFileIndex planDeletesRemotely(List<ManifestFile> var1);

    @Override
    protected CloseableIterable<ScanTask> doPlanFiles() {
        Snapshot snapshot = this.snapshot();
        List<ManifestFile> deleteManifests = this.findMatchingDeleteManifests(snapshot);
        boolean mayHaveEqualityDeletes = !deleteManifests.isEmpty() && this.mayHaveEqualityDeletes(snapshot);
        boolean planDeletesLocally = this.shouldPlanDeletesLocally(deleteManifests, mayHaveEqualityDeletes);
        List<ManifestFile> dataManifests = this.findMatchingDataManifests(snapshot);
        boolean loadColumnStats = mayHaveEqualityDeletes || this.shouldReturnColumnStats();
        boolean planDataLocally = this.shouldPlanDataLocally(dataManifests, loadColumnStats);
        boolean copyDataFiles = this.shouldCopyDataFiles(planDataLocally, loadColumnStats);
        if (planDataLocally && planDeletesLocally) {
            return this.planFileTasksLocally(dataManifests, deleteManifests);
        }
        ExecutorService monitorPool = this.newMonitorPool();
        CompletableFuture<DeleteFileIndex> deletesFuture = this.newDeletesFuture(deleteManifests, planDeletesLocally, monitorPool);
        CompletableFuture<Iterable<CloseableIterable<DataFile>>> dataFuture = this.newDataFuture(dataManifests, planDataLocally, loadColumnStats, monitorPool);
        try {
            Iterable<CloseableIterable<ScanTask>> fileTasks = this.toFileTasks(dataFuture, deletesFuture, copyDataFiles);
            if (this.shouldPlanWithExecutor() && (planDataLocally || mayHaveEqualityDeletes)) {
                ParallelIterable<ScanTask> parallelIterable = new ParallelIterable<ScanTask>(fileTasks, this.planExecutor());
                return parallelIterable;
            }
            CloseableIterable closeableIterable = CloseableIterable.concat(fileTasks);
            return closeableIterable;
        }
        catch (CompletionException e) {
            deletesFuture.cancel(true);
            dataFuture.cancel(true);
            throw new RuntimeException("Failed to plan files", e);
        }
        finally {
            monitorPool.shutdown();
        }
    }

    public CloseableIterable<ScanTaskGroup<ScanTask>> planTasks() {
        return TableScanUtil.planTaskGroups(this.planFiles(), this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
    }

    private List<ManifestFile> findMatchingDataManifests(Snapshot snapshot) {
        List dataManifests = snapshot.dataManifests(this.io());
        this.scanMetrics().totalDataManifests().increment(dataManifests.size());
        List<ManifestFile> matchingDataManifests = this.filterManifests(dataManifests);
        int skippedDataManifestsCount = dataManifests.size() - matchingDataManifests.size();
        this.scanMetrics().skippedDataManifests().increment(skippedDataManifestsCount);
        return matchingDataManifests;
    }

    private List<ManifestFile> findMatchingDeleteManifests(Snapshot snapshot) {
        List deleteManifests = snapshot.deleteManifests(this.io());
        this.scanMetrics().totalDeleteManifests().increment(deleteManifests.size());
        List<ManifestFile> matchingDeleteManifests = this.filterManifests(deleteManifests);
        int skippedDeleteManifestsCount = deleteManifests.size() - matchingDeleteManifests.size();
        this.scanMetrics().skippedDeleteManifests().increment(skippedDeleteManifestsCount);
        return matchingDeleteManifests;
    }

    private List<ManifestFile> filterManifests(List<ManifestFile> manifests) {
        Map<Integer, ManifestEvaluator> evalCache = this.specCache(this::newManifestEvaluator);
        return manifests.stream().filter((? super T manifest) -> manifest.hasAddedFiles() || manifest.hasExistingFiles()).filter((? super T manifest) -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval(manifest)).collect(Collectors.toList());
    }

    private boolean shouldPlanDeletesLocally(List<ManifestFile> deleteManifests, boolean mayHaveEqualityDeletes) {
        PlanningMode mode = this.deletePlanningMode();
        return mode == PlanningMode.AUTO && mayHaveEqualityDeletes || this.shouldPlanLocally(mode, deleteManifests);
    }

    private boolean shouldPlanDataLocally(List<ManifestFile> dataManifests, boolean loadColumnStats) {
        PlanningMode mode = this.dataPlanningMode();
        return mode == PlanningMode.AUTO && loadColumnStats || this.shouldPlanLocally(mode, dataManifests);
    }

    private boolean shouldPlanLocally(PlanningMode mode, List<ManifestFile> manifests) {
        if (this.context().planWithCustomizedExecutor()) {
            return true;
        }
        switch (mode) {
            case LOCAL: {
                return true;
            }
            case DISTRIBUTED: {
                return manifests.isEmpty();
            }
            case AUTO: {
                return this.remoteParallelism() <= this.localParallelism || manifests.size() <= 2 * this.localParallelism || this.totalSize(manifests) <= this.localPlanningSizeThreshold;
            }
        }
        throw new IllegalArgumentException("Unknown planning mode: " + String.valueOf((Object)mode));
    }

    private long totalSize(List<ManifestFile> manifests) {
        return manifests.stream().mapToLong(ManifestFile::length).sum();
    }

    private boolean shouldCopyDataFiles(boolean planDataLocally, boolean loadColumnStats) {
        return planDataLocally || this.shouldCopyRemotelyPlannedDataFiles() || loadColumnStats && !this.shouldReturnColumnStats();
    }

    private CloseableIterable<ScanTask> planFileTasksLocally(List<ManifestFile> dataManifests, List<ManifestFile> deleteManifests) {
        LOG.info("Planning file tasks locally for table {}", (Object)this.table().name());
        ManifestGroup manifestGroup = this.newManifestGroup(dataManifests, deleteManifests);
        CloseableIterable<FileScanTask> fileTasks = manifestGroup.planFiles();
        return fileTasks;
    }

    private CompletableFuture<DeleteFileIndex> newDeletesFuture(List<ManifestFile> deleteManifests, boolean planLocally, ExecutorService monitorPool) {
        return CompletableFuture.supplyAsync(() -> {
            if (planLocally) {
                LOG.info("Planning deletes locally for table {}", (Object)this.table().name());
                return this.planDeletesLocally(deleteManifests);
            }
            LOG.info("Planning deletes remotely for table {}", (Object)this.table().name());
            return this.planDeletesRemotely(deleteManifests);
        }, monitorPool);
    }

    private DeleteFileIndex planDeletesLocally(List<ManifestFile> deleteManifests) {
        DeleteFileIndex.Builder builder = DeleteFileIndex.builderFor(this.io(), deleteManifests);
        if (this.shouldPlanWithExecutor() && deleteManifests.size() > 1) {
            builder.planWith(this.planExecutor());
        }
        return builder.specsById(this.table().specs()).filterData(this.filter()).caseSensitive(this.isCaseSensitive()).scanMetrics(this.scanMetrics()).build();
    }

    private CompletableFuture<Iterable<CloseableIterable<DataFile>>> newDataFuture(List<ManifestFile> dataManifests, boolean planLocally, boolean withColumnStats, ExecutorService monitorPool) {
        return CompletableFuture.supplyAsync(() -> {
            if (planLocally) {
                LOG.info("Planning data locally for table {}", (Object)this.table().name());
                ManifestGroup manifestGroup = this.newManifestGroup(dataManifests, withColumnStats);
                return manifestGroup.fileGroups();
            }
            LOG.info("Planning data remotely for table {}", (Object)this.table().name());
            return this.planDataRemotely(dataManifests, withColumnStats);
        }, monitorPool);
    }

    private Iterable<CloseableIterable<ScanTask>> toFileTasks(CompletableFuture<Iterable<CloseableIterable<DataFile>>> dataFuture, CompletableFuture<DeleteFileIndex> deletesFuture, boolean copyDataFiles) {
        String schemaString = SchemaParser.toJson(this.tableSchema());
        Map<Integer, String> specStringCache = this.specCache(PartitionSpecParser::toJson);
        Map<Integer, ResidualEvaluator> residualCache = this.specCache(this::newResidualEvaluator);
        Iterable<CloseableIterable<DataFile>> dataFileGroups = dataFuture.join();
        return Iterables.transform(dataFileGroups, dataFiles -> this.toFileTasks((CloseableIterable<DataFile>)dataFiles, deletesFuture, copyDataFiles, schemaString, specStringCache, residualCache));
    }

    private CloseableIterable<ScanTask> toFileTasks(CloseableIterable<DataFile> dataFiles, CompletableFuture<DeleteFileIndex> deletesFuture, boolean copyDataFiles, String schemaString, Map<Integer, String> specStringCache, Map<Integer, ResidualEvaluator> residualCache) {
        return CloseableIterable.transform(dataFiles, dataFile -> {
            DeleteFile[] deleteFiles = ((DeleteFileIndex)deletesFuture.join()).forDataFile((DataFile)dataFile);
            String specString = (String)specStringCache.get(dataFile.specId());
            ResidualEvaluator residuals = (ResidualEvaluator)residualCache.get(dataFile.specId());
            ScanMetricsUtil.fileTask(this.scanMetrics(), dataFile, deleteFiles);
            return new BaseFileScanTask(copyDataFiles ? this.copy(dataFile) : dataFile, deleteFiles, schemaString, specString, residuals);
        });
    }

    private <F extends ContentFile<F>> F copy(F file) {
        return (F)((ContentFile)ContentFileUtil.copy(file, this.shouldReturnColumnStats(), this.columnsToKeepStats()));
    }

    private ManifestEvaluator newManifestEvaluator(PartitionSpec spec) {
        Expression projection = Projections.inclusive((PartitionSpec)spec, (boolean)this.isCaseSensitive()).project(this.filter());
        return ManifestEvaluator.forPartitionFilter((Expression)projection, (PartitionSpec)spec, (boolean)this.isCaseSensitive());
    }

    private ResidualEvaluator newResidualEvaluator(PartitionSpec spec) {
        return ResidualEvaluator.of((PartitionSpec)spec, (Expression)this.residualFilter(), (boolean)this.isCaseSensitive());
    }

    private <R> Map<Integer, R> specCache(Function<PartitionSpec, R> load) {
        HashMap cache = Maps.newHashMap();
        this.table().specs().forEach((specId, spec) -> cache.put(specId, load.apply((PartitionSpec)spec)));
        return cache;
    }

    private boolean mayHaveEqualityDeletes(Snapshot snapshot) {
        String count = (String)snapshot.summary().get("total-equality-deletes");
        return count == null || !count.equals("0");
    }

    private ExecutorService newMonitorPool() {
        return ThreadPools.newFixedThreadPool("iceberg-planning-monitor-service", 2);
    }
}

