/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;

@ApiModel(description="A policy in Apache Polaris defines a set of rules for governing access, data usage, and operational consistency across various catalog resources.  Policies are stored within Polaris and can be attached to catalogs, namespaces, tables, or views. For example, they can be used for fine-grained control over who can perform specific actions on certain resources.  The policy object includes - **policy-type:** The type of the policy, which determines the expected format and semantics of the policy content. - **inheritable:** A boolean flag indicating whether the policy is inheritable.  - **name:**  A human-readable name for the policy, which must be unique within a given namespace. - **description:** Detailed description of the purpose and functionalities of the policy. - **content:** Policy content, which can be validated against predefined schemas of a policy type. - **version:** Indicates the current version of the policy. Versions increased monotonically, the default value is 0  Policies stored in Polaris serve as the persistent definition for access control and governance rules. ")
public class Policy {
    @NotNull
    private final String policyType;
    @NotNull
    private final Boolean inheritable;
    @NotNull
    @Pattern(regexp="^[A-Za-z0-9\\-_]+$")
    private final @NotNull @Pattern(regexp="^[A-Za-z0-9\\-_]+$") String name;
    private final String description;
    private final String content;
    @NotNull
    private final Integer version;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="policy-type", required=true)
    public String getPolicyType() {
        return this.policyType;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="inheritable", required=true)
    public Boolean getInheritable() {
        return this.inheritable;
    }

    @ApiModelProperty(example="compaction", required=true, value="A policy name. A valid policy name should only consist of uppercase and lowercase letters (A-Z, a-z), digits (0-9), hyphens (-), underscores (_).")
    @JsonProperty(value="name", required=true)
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="version", required=true)
    public Integer getVersion() {
        return this.version;
    }

    @JsonCreator
    public Policy(@JsonProperty(value="policy-type", required=true) String policyType, @JsonProperty(value="inheritable", required=true) Boolean inheritable, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="description") String description, @JsonProperty(value="content") String content, @JsonProperty(value="version", required=true) Integer version) {
        this.policyType = policyType;
        this.inheritable = inheritable;
        this.name = name;
        this.description = description;
        this.content = content;
        this.version = version;
    }

    public Policy(String policyType, Boolean inheritable, String name, Integer version) {
        this.policyType = policyType;
        this.inheritable = inheritable;
        this.name = name;
        this.description = null;
        this.content = null;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String policyType, Boolean inheritable, String name, Integer version) {
        return new Builder(policyType, inheritable, name, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return Objects.equals(this.policyType, policy.policyType) && Objects.equals(this.inheritable, policy.inheritable) && Objects.equals(this.name, policy.name) && Objects.equals(this.description, policy.description) && Objects.equals(this.content, policy.content) && Objects.equals(this.version, policy.version);
    }

    public int hashCode() {
        return Objects.hash(this.policyType, this.inheritable, this.name, this.description, this.content, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Policy {\n");
        sb.append("    policyType: ").append(this.toIndentedString(this.policyType)).append("\n");
        sb.append("    inheritable: ").append(this.toIndentedString(this.inheritable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String policyType;
        private Boolean inheritable;
        private String name;
        private String description;
        private String content;
        private Integer version;

        private Builder() {
        }

        private Builder(String policyType, Boolean inheritable, String name, Integer version) {
            this.policyType = policyType;
            this.inheritable = inheritable;
            this.name = name;
            this.version = version;
        }

        public Builder setPolicyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public Builder setInheritable(Boolean inheritable) {
            this.inheritable = inheritable;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setVersion(Integer version) {
            this.version = version;
            return this;
        }

        public Policy build() {
            Policy inst = new Policy(this.policyType, this.inheritable, this.name, this.description, this.content, this.version);
            return inst;
        }
    }
}

