/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.List;
import org.apache.polaris.core.admin.model.StorageConfigInfo;

@ApiModel(description="file storage configuration info")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FileStorageConfigInfo
extends StorageConfigInfo {
    @JsonCreator
    public FileStorageConfigInfo(@JsonProperty(value="storageType") StorageConfigInfo.StorageTypeEnum storageType, @JsonProperty(value="allowedLocations") List<String> allowedLocations) {
        super(storageType, allowedLocations);
    }

    public FileStorageConfigInfo(StorageConfigInfo.StorageTypeEnum storageType) {
        super(storageType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StorageConfigInfo.StorageTypeEnum storageType) {
        return new Builder(storageType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileStorageConfigInfo fileStorageConfigInfo = (FileStorageConfigInfo)o;
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileStorageConfigInfo {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private StorageConfigInfo.StorageTypeEnum storageType;
        private List<String> allowedLocations;

        private Builder() {
        }

        private Builder(StorageConfigInfo.StorageTypeEnum storageType) {
            this.storageType = storageType;
        }

        public Builder setStorageType(StorageConfigInfo.StorageTypeEnum storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder setAllowedLocations(List<String> allowedLocations) {
            this.allowedLocations = allowedLocations;
            return this;
        }

        public FileStorageConfigInfo build() {
            FileStorageConfigInfo inst = new FileStorageConfigInfo(this.storageType, this.allowedLocations);
            return inst;
        }
    }
}

