/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.BucketsCopier;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDirectoryBucketsResponse
extends S3Response
implements ToCopyableBuilder<Builder, ListDirectoryBucketsResponse> {
    private static final SdkField<List<Bucket>> BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Buckets").getter(ListDirectoryBucketsResponse.getter(ListDirectoryBucketsResponse::buckets)).setter(ListDirectoryBucketsResponse.setter(Builder::buckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Buckets").unmarshallLocationName("Buckets").build(), ListTrait.builder().memberLocationName("Bucket").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Bucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build()).build()}).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContinuationToken").getter(ListDirectoryBucketsResponse.getter(ListDirectoryBucketsResponse::continuationToken)).setter(ListDirectoryBucketsResponse.setter(Builder::continuationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuationToken").unmarshallLocationName("ContinuationToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKETS_FIELD, CONTINUATION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDirectoryBucketsResponse.memberNameToFieldInitializer();
    private final List<Bucket> buckets;
    private final String continuationToken;

    private ListDirectoryBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.buckets = builder.buckets;
        this.continuationToken = builder.continuationToken;
    }

    public final boolean hasBuckets() {
        return this.buckets != null && !(this.buckets instanceof SdkAutoConstructList);
    }

    public final List<Bucket> buckets() {
        return this.buckets;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuckets() ? this.buckets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDirectoryBucketsResponse)) {
            return false;
        }
        ListDirectoryBucketsResponse other = (ListDirectoryBucketsResponse)((Object)obj);
        return this.hasBuckets() == other.hasBuckets() && Objects.equals(this.buckets(), other.buckets()) && Objects.equals(this.continuationToken(), other.continuationToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDirectoryBucketsResponse").add("Buckets", this.hasBuckets() ? this.buckets() : null).add("ContinuationToken", (Object)this.continuationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Buckets": {
                return Optional.ofNullable(clazz.cast(this.buckets()));
            }
            case "ContinuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Buckets", BUCKETS_FIELD);
        map.put("ContinuationToken", CONTINUATION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDirectoryBucketsResponse, T> g) {
        return obj -> g.apply((ListDirectoryBucketsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private List<Bucket> buckets = DefaultSdkAutoConstructList.getInstance();
        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDirectoryBucketsResponse model) {
            super(model);
            this.buckets(model.buckets);
            this.continuationToken(model.continuationToken);
        }

        public final List<Bucket.Builder> getBuckets() {
            List<Bucket.Builder> result = BucketsCopier.copyToBuilder(this.buckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuckets(Collection<Bucket.BuilderImpl> buckets) {
            this.buckets = BucketsCopier.copyFromBuilder(buckets);
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket ... buckets) {
            this.buckets(Arrays.asList(buckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Consumer<Bucket.Builder> ... buckets) {
            this.buckets(Stream.of(buckets).map(c -> (Bucket)((Bucket.Builder)Bucket.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        @Override
        public ListDirectoryBucketsResponse build() {
            return new ListDirectoryBucketsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDirectoryBucketsResponse> {
        public Builder buckets(Collection<Bucket> var1);

        public Builder buckets(Bucket ... var1);

        public Builder buckets(Consumer<Bucket.Builder> ... var1);

        public Builder continuationToken(String var1);
    }
}

