/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters;

import jakarta.ws.rs.core.Cookie;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;

public class CookieParamExtractor
implements ParameterExtractor {
    private final String name;
    private final String parameterTypeName;

    public CookieParamExtractor(String name, String parameterTypeName) {
        this.name = name;
        this.parameterTypeName = parameterTypeName;
    }

    @Override
    public Object extractParameter(ResteasyReactiveRequestContext context) {
        if (Cookie.class.getName().equals(this.parameterTypeName)) {
            Cookie cookie = context.getHttpHeaders().getCookies().get(this.name);
            return cookie != null ? cookie.toString() : null;
        }
        return context.getCookieParameter(this.name);
    }
}

