/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.exchange.sink;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeMPPDataExchangeServiceClient;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.exception.exchange.GetTsBlockFromClosedOrAbortedChannelException;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkChannel;
import org.apache.iotdb.db.queryengine.execution.memory.LocalMemoryManager;
import org.apache.iotdb.db.queryengine.metric.DataExchangeCostMetricSet;
import org.apache.iotdb.db.queryengine.metric.DataExchangeCountMetricSet;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TEndOfDataBlockEvent;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.mpp.rpc.thrift.TNewDataBlockEvent;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkChannel
implements ISinkChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinkChannel.class);
    public static final int MAX_ATTEMPT_TIMES = 3;
    private static final long DEFAULT_RETRY_INTERVAL_IN_MS = 1000L;
    private final TEndPoint remoteEndpoint;
    private final TFragmentInstanceId remoteFragmentInstanceId;
    private final String remotePlanNodeId;
    private final String localPlanNodeId;
    private final TFragmentInstanceId localFragmentInstanceId;
    private final String fullFragmentInstanceId;
    private final LocalMemoryManager localMemoryManager;
    private final ExecutorService executorService;
    private final TsBlockSerde serde;
    private final MPPDataExchangeManager.SinkListener sinkListener;
    private final String threadName;
    private long retryIntervalInMs;
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private final LinkedHashMap<Integer, Pair<TsBlock, Long>> sequenceIdToTsBlock = new LinkedHashMap();
    private long currentTsBlockSize;
    private final IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager;
    private volatile ListenableFuture<Void> blocked;
    private int nextSequenceId = 0;
    private long bufferRetainedSizeInBytes;
    private boolean aborted = false;
    private boolean closed = false;
    private boolean noMoreTsBlocks = false;
    private final AtomicBoolean invokedOnFinished = new AtomicBoolean(false);
    private long maxBytesCanReserve = IoTDBDescriptor.getInstance().getMemoryConfig().getMaxBytesPerFragmentInstance();
    private static final DataExchangeCostMetricSet DATA_EXCHANGE_COST_METRIC_SET = DataExchangeCostMetricSet.getInstance();
    private static final DataExchangeCountMetricSet DATA_EXCHANGE_COUNT_METRIC_SET = DataExchangeCountMetricSet.getInstance();
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SinkChannel.class) + RamUsageEstimator.shallowSizeOfInstance(TFragmentInstanceId.class) * 2L;

    public SinkChannel(TEndPoint remoteEndpoint, TFragmentInstanceId remoteFragmentInstanceId, String remotePlanNodeId, String localPlanNodeId, TFragmentInstanceId localFragmentInstanceId, LocalMemoryManager localMemoryManager, ExecutorService executorService, TsBlockSerde serde, MPPDataExchangeManager.SinkListener sinkListener, IClientManager<TEndPoint, SyncDataNodeMPPDataExchangeServiceClient> mppDataExchangeServiceClientManager) {
        this.remoteEndpoint = (TEndPoint)Validate.notNull((Object)remoteEndpoint, (String)"remoteEndPoint can not be null.", (Object[])new Object[0]);
        this.remoteFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)remoteFragmentInstanceId, (String)"remoteFragmentInstanceId can not be null.", (Object[])new Object[0]);
        this.remotePlanNodeId = (String)Validate.notNull((Object)remotePlanNodeId, (String)"remotePlanNodeId can not be null.", (Object[])new Object[0]);
        this.localPlanNodeId = (String)Validate.notNull((Object)localPlanNodeId, (String)"localPlanNodeId can not be null.", (Object[])new Object[0]);
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId, (String)"localFragmentInstanceId can not be null.", (Object[])new Object[0]);
        this.fullFragmentInstanceId = FragmentInstanceId.createFragmentInstanceIdFromTFragmentInstanceId(localFragmentInstanceId);
        this.localMemoryManager = (LocalMemoryManager)Validate.notNull((Object)localMemoryManager, (String)"localMemoryManager can not be null.", (Object[])new Object[0]);
        this.executorService = (ExecutorService)Validate.notNull((Object)executorService, (String)"executorService can not be null.", (Object[])new Object[0]);
        this.serde = (TsBlockSerde)Validate.notNull((Object)serde, (String)"serde can not be null.", (Object[])new Object[0]);
        this.sinkListener = (MPPDataExchangeManager.SinkListener)Validate.notNull((Object)sinkListener, (String)"sinkListener can not be null.", (Object[])new Object[0]);
        this.mppDataExchangeServiceClientManager = mppDataExchangeServiceClientManager;
        this.retryIntervalInMs = 1000L;
        this.threadName = FragmentInstanceId.createFullId(localFragmentInstanceId.queryId, localFragmentInstanceId.fragmentId, localFragmentInstanceId.instanceId);
        this.bufferRetainedSizeInBytes = 0L;
        this.currentTsBlockSize = DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
        localMemoryManager.getQueryPool().registerPlanNodeIdToQueryMemoryMap(localFragmentInstanceId.queryId, this.fullFragmentInstanceId, localPlanNodeId);
    }

    @Override
    public synchronized ListenableFuture<?> isFull() {
        this.checkState();
        if (this.closed) {
            return Futures.immediateVoidFuture();
        }
        return Futures.nonCancellationPropagating(this.blocked);
    }

    private void submitSendNewDataBlockEventTask(int startSequenceId, List<Long> blockSizes) {
        this.executorService.submit(new SendNewDataBlockEventTask(startSequenceId, blockSizes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(TsBlock tsBlock) {
        long startTime = System.nanoTime();
        try {
            Validate.notNull((Object)tsBlock, (String)"tsBlocks is null", (Object[])new Object[0]);
            if (this.closed) {
                return;
            }
            this.checkState();
            if (!this.blocked.isDone()) {
                throw new IllegalStateException("Sink handle is blocked.");
            }
            if (this.noMoreTsBlocks) {
                return;
            }
            long sizeInBytes = tsBlock.getSizeInBytes();
            int startSequenceId = this.nextSequenceId;
            this.blocked = (ListenableFuture)this.localMemoryManager.getQueryPool().reserve((String)this.localFragmentInstanceId.getQueryId(), (String)this.fullFragmentInstanceId, (String)this.localPlanNodeId, (long)sizeInBytes, (long)this.maxBytesCanReserve).left;
            this.bufferRetainedSizeInBytes += sizeInBytes;
            this.sequenceIdToTsBlock.put(this.nextSequenceId, (Pair<TsBlock, Long>)new Pair((Object)tsBlock, (Object)this.currentTsBlockSize));
            ++this.nextSequenceId;
            this.currentTsBlockSize = sizeInBytes;
            this.submitSendNewDataBlockEventTask(startSequenceId, (List<Long>)ImmutableList.of((Object)sizeInBytes));
        }
        finally {
            DATA_EXCHANGE_COST_METRIC_SET.recordDataExchangeCost("sink_handle_send_tsblock_remote", System.nanoTime() - startTime);
        }
    }

    @Override
    public synchronized void setNoMoreTsBlocks() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[StartSetNoMoreTsBlocks]");
        }
        if (this.aborted || this.closed) {
            return;
        }
        this.executorService.submit(new SendEndOfDataBlockEventTask());
    }

    @Override
    public synchronized boolean abort() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[StartAbortSinkChannel]");
        }
        if (this.aborted || this.closed) {
            return false;
        }
        this.sequenceIdToTsBlock.clear();
        if (this.blocked != null) {
            this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blocked);
        }
        if (this.bufferRetainedSizeInBytes > 0L) {
            this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, this.bufferRetainedSizeInBytes);
            this.bufferRetainedSizeInBytes = 0L;
        }
        this.sinkListener.onAborted(this);
        this.aborted = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[EndAbortSinkChannel]");
        }
        return true;
    }

    @Override
    public synchronized boolean close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[StartCloseSinkChannel]");
        }
        if (this.closed || this.aborted) {
            return false;
        }
        this.sequenceIdToTsBlock.clear();
        if (this.blocked != null) {
            this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blocked);
        }
        if (this.bufferRetainedSizeInBytes > 0L) {
            this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, this.bufferRetainedSizeInBytes);
            this.bufferRetainedSizeInBytes = 0L;
        }
        this.invokeOnFinished();
        this.closed = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[EndCloseSinkChannel]");
        }
        return true;
    }

    private void invokeOnFinished() {
        if (this.invokedOnFinished.compareAndSet(false, true)) {
            this.sinkListener.onFinish(this);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized boolean isAborted() {
        return this.aborted;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.noMoreTsBlocks && this.sequenceIdToTsBlock.isEmpty();
    }

    @Override
    public synchronized long getBufferRetainedSizeInBytes() {
        return this.bufferRetainedSizeInBytes;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOf((String)this.threadName) + RamUsageEstimator.sizeOf((String)this.localPlanNodeId) + RamUsageEstimator.sizeOf((String)this.remotePlanNodeId) + RamUsageEstimator.sizeOf((String)this.fullFragmentInstanceId);
    }

    public ByteBuffer getSerializedTsBlock(int partition, int sequenceId) {
        throw new UnsupportedOperationException();
    }

    public synchronized ByteBuffer getSerializedTsBlock(int sequenceId) throws IOException {
        if (this.aborted || this.closed) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SinkChannel still receive getting TsBlock request after being aborted={} or closed={}", (Object)this.aborted, (Object)this.closed);
            }
            throw new GetTsBlockFromClosedOrAbortedChannelException("SinkChannel is aborted or closed. ");
        }
        Pair<TsBlock, Long> pair = this.sequenceIdToTsBlock.get(sequenceId);
        if (pair == null || pair.left == null) {
            LOGGER.warn("The TsBlock doesn't exist. Sequence ID is {}, remaining map is {}", (Object)sequenceId, this.sequenceIdToTsBlock.entrySet());
            throw new IllegalStateException("The data block doesn't exist. Sequence ID: " + sequenceId);
        }
        return this.serde.serialize((TsBlock)pair.left);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeTsBlock(int startSequenceId, int endSequenceId) {
        long freedBytes = 0L;
        SinkChannel sinkChannel = this;
        synchronized (sinkChannel) {
            if (this.aborted || this.closed) {
                return;
            }
            Iterator<Map.Entry<Integer, Pair<TsBlock, Long>>> iterator = this.sequenceIdToTsBlock.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, Pair<TsBlock, Long>> entry = iterator.next();
                if (entry.getKey() < startSequenceId) continue;
                if (entry.getKey() >= endSequenceId) break;
                freedBytes += ((Long)entry.getValue().right).longValue();
                this.bufferRetainedSizeInBytes -= ((Long)entry.getValue().right).longValue();
                iterator.remove();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("[ACKTsBlock] {}.", (Object)entry.getKey());
            }
            if (freedBytes > 0L) {
                this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, freedBytes);
            }
        }
        if (this.isFinished()) {
            this.invokeOnFinished();
        }
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    @Override
    public void setMaxBytesCanReserve(long maxBytesCanReserve) {
        this.maxBytesCanReserve = Math.min(this.maxBytesCanReserve, maxBytesCanReserve);
    }

    public String toString() {
        return String.format("Query[%s]-[%s-%s-SinkChannel]:", this.localFragmentInstanceId.queryId, this.localFragmentInstanceId.fragmentId, this.localFragmentInstanceId.instanceId);
    }

    @Override
    public void checkState() {
        if (this.aborted) {
            throw new IllegalStateException("SinkChannel is aborted.");
        }
    }

    @Override
    public synchronized void open() {
        if (this.aborted || this.closed) {
            return;
        }
        this.blocked = (ListenableFuture)this.localMemoryManager.getQueryPool().reserve((String)this.localFragmentInstanceId.getQueryId(), (String)this.fullFragmentInstanceId, (String)this.localPlanNodeId, (long)((long)SinkChannel.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES), (long)this.maxBytesCanReserve).left;
        this.bufferRetainedSizeInBytes = DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public boolean isNoMoreTsBlocks() {
        return this.noMoreTsBlocks;
    }

    @Override
    public int getNumOfBufferedTsBlocks() {
        return this.sequenceIdToTsBlock.size();
    }

    @TestOnly
    public void setRetryIntervalInMs(long retryIntervalInMs) {
        this.retryIntervalInMs = retryIntervalInMs;
    }

    class SendNewDataBlockEventTask
    implements Runnable {
        private final int startSequenceId;
        private final List<Long> blockSizes;

        SendNewDataBlockEventTask(int startSequenceId, List<Long> blockSizes) {
            Validate.isTrue((startSequenceId >= 0 ? 1 : 0) != 0, (String)("Start sequence ID should be greater than or equal to zero, but was: " + startSequenceId + "."), (Object[])new Object[0]);
            this.startSequenceId = startSequenceId;
            this.blockSizes = (List)Validate.notNull(blockSizes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try (SetThreadName sinkChannelName = new SetThreadName(SinkChannel.this.threadName);){
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[NotifyNewTsBlock] [{}, {}) to {}.{}", new Object[]{this.startSequenceId, this.startSequenceId + this.blockSizes.size(), SinkChannel.this.remoteFragmentInstanceId, SinkChannel.this.remotePlanNodeId});
                }
                int attempt = 0;
                TNewDataBlockEvent newDataBlockEvent = new TNewDataBlockEvent(SinkChannel.this.remoteFragmentInstanceId, SinkChannel.this.remotePlanNodeId, SinkChannel.this.localFragmentInstanceId, this.startSequenceId, this.blockSizes);
                while (attempt < 3) {
                    long startTime;
                    block19: {
                        ++attempt;
                        startTime = System.nanoTime();
                        SyncDataNodeMPPDataExchangeServiceClient client = (SyncDataNodeMPPDataExchangeServiceClient)SinkChannel.this.mppDataExchangeServiceClientManager.borrowClient((Object)SinkChannel.this.remoteEndpoint);
                        try {
                            client.onNewDataBlockEvent(newDataBlockEvent);
                            if (client == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    if (client == null) throw throwable;
                                    try {
                                        client.close();
                                        throw throwable;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    LOGGER.warn("Failed to send new data block event, attempt times: {}", (Object)attempt, (Object)e);
                                    if (attempt == 3) {
                                        SinkChannel.this.sinkListener.onFailure(SinkChannel.this, e);
                                    }
                                    try {
                                        Thread.sleep(SinkChannel.this.retryIntervalInMs);
                                    }
                                    catch (InterruptedException ex) {
                                        Thread.currentThread().interrupt();
                                        SinkChannel.this.sinkListener.onFailure(SinkChannel.this, e);
                                    }
                                    DATA_EXCHANGE_COST_METRIC_SET.recordDataExchangeCost("send_new_data_block_event_task_caller", System.nanoTime() - startTime);
                                    DATA_EXCHANGE_COUNT_METRIC_SET.recordDataBlockNum("send_new_data_block_num_caller", this.blockSizes.size());
                                    continue;
                                }
                            }
                            catch (Throwable throwable3) {
                                DATA_EXCHANGE_COST_METRIC_SET.recordDataExchangeCost("send_new_data_block_event_task_caller", System.nanoTime() - startTime);
                                DATA_EXCHANGE_COUNT_METRIC_SET.recordDataBlockNum("send_new_data_block_num_caller", this.blockSizes.size());
                                throw throwable3;
                                return;
                            }
                        }
                        client.close();
                    }
                    DATA_EXCHANGE_COST_METRIC_SET.recordDataExchangeCost("send_new_data_block_event_task_caller", System.nanoTime() - startTime);
                    DATA_EXCHANGE_COUNT_METRIC_SET.recordDataBlockNum("send_new_data_block_num_caller", this.blockSizes.size());
                    return;
                }
            }
        }
    }

    class SendEndOfDataBlockEventTask
    implements Runnable {
        SendEndOfDataBlockEventTask() {
        }

        @Override
        public void run() {
            block20: {
                SetThreadName sinkChannelName = new SetThreadName(SinkChannel.this.threadName);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[NotifyNoMoreTsBlock]");
                }
                int attempt = 0;
                TEndOfDataBlockEvent endOfDataBlockEvent = new TEndOfDataBlockEvent(SinkChannel.this.remoteFragmentInstanceId, SinkChannel.this.remotePlanNodeId, SinkChannel.this.localFragmentInstanceId, SinkChannel.this.nextSequenceId - 1);
                while (attempt < 3) {
                    ++attempt;
                    try (SyncDataNodeMPPDataExchangeServiceClient client = (SyncDataNodeMPPDataExchangeServiceClient)SinkChannel.this.mppDataExchangeServiceClientManager.borrowClient((Object)SinkChannel.this.remoteEndpoint);){
                        client.onEndOfDataBlockEvent(endOfDataBlockEvent);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to send end of data block event, attempt times: {}", (Object)attempt, (Object)e);
                        if (attempt == 3) {
                            LOGGER.warn("Failed to send end of data block event after all retry", (Throwable)e);
                            SinkChannel.this.sinkListener.onFailure(SinkChannel.this, e);
                            sinkChannelName.close();
                            return;
                        }
                        try {
                            Thread.sleep(SinkChannel.this.retryIntervalInMs);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            SinkChannel.this.sinkListener.onFailure(SinkChannel.this, e);
                        }
                    }
                }
                SinkChannel.this.noMoreTsBlocks = true;
                if (SinkChannel.this.isFinished()) {
                    SinkChannel.this.invokeOnFinished();
                }
                break block20;
                finally {
                    try {
                        sinkChannelName.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
            SinkChannel.this.sinkListener.onEndOfBlocks(SinkChannel.this);
        }
    }
}

