/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.BitwiseUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class BitCountColumnTransformer
extends UnaryColumnTransformer {
    private final long bits;

    public BitCountColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, long bits) {
        super(returnType, childColumnTransformer);
        this.bits = bits;
        BitwiseUtils.bitCountCheckBits(bits);
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    private void transform(Column column, ColumnBuilder columnBuilder, int i) {
        long num = column.getLong(i);
        long currentValue = BitwiseUtils.bitCountTransform(num, this.bits);
        columnBuilder.writeLong(currentValue);
    }
}

