/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.common.conf;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.fileSystem.FSType;
import org.apache.tsfile.utils.FSUtils;

public class TSFileConfig
implements Serializable {
    public static final int RLE_MIN_REPEATED_NUM = 8;
    public static final int RLE_MAX_REPEATED_NUM = Short.MAX_VALUE;
    public static final int RLE_MAX_BIT_PACKED_NUM = 63;
    public static final int FLOAT_VALUE_LENGTH = 6;
    public static final int DOUBLE_VALUE_LENGTH = 7;
    public static final int VALUE_BITS_LENGTH_32BIT = 32;
    public static final int LEADING_ZERO_BITS_LENGTH_32BIT = 5;
    public static final int MEANINGFUL_XOR_BITS_LENGTH_32BIT = 5;
    public static final int VALUE_BITS_LENGTH_64BIT = 64;
    public static final int LEADING_ZERO_BITS_LENGTH_64BIT = 6;
    public static final int MEANINGFUL_XOR_BITS_LENGTH_64BIT = 6;
    public static final int GORILLA_ENCODING_ENDING_INTEGER = Integer.MIN_VALUE;
    public static final long GORILLA_ENCODING_ENDING_LONG = Long.MIN_VALUE;
    public static final float GORILLA_ENCODING_ENDING_FLOAT = Float.NaN;
    public static final double GORILLA_ENCODING_ENDING_DOUBLE = Double.NaN;
    public static final int BYTE_SIZE_PER_CHAR = 4;
    public static final String STRING_ENCODING = "UTF-8";
    public static final Charset STRING_CHARSET = StandardCharsets.UTF_8;
    public static final String CONFIG_FILE_NAME = "iotdb-system.properties";
    public static final String MAGIC_STRING = "TsFile";
    public static final String VERSION_NUMBER_V2 = "000002";
    public static final String VERSION_NUMBER_V1 = "000001";
    public static final byte VERSION_NUMBER_V3 = 3;
    public static final byte VERSION_NUMBER = 4;
    public static final double MIN_BLOOM_FILTER_ERROR_RATE = 0.01;
    public static final double MAX_BLOOM_FILTER_ERROR_RATE = 0.1;
    public static final int ARRAY_CAPACITY_THRESHOLD = 1000;
    public static int DEFAULT_SEGMENT_NUM_FOR_TABLE_NAME = 3;
    private int groupSizeInByte = 0x8000000;
    private int pageSizeInByte = 65536;
    private int maxNumberOfPointsInPage = 10000;
    private int maxDegreeOfIndexNode = 256;
    private TSDataType timeSeriesDataType = TSDataType.INT64;
    private int maxStringLength = 128;
    private int floatPrecision = 2;
    private String timeEncoding = "TS_2DIFF";
    private String booleanEncoding = "RLE";
    private String int32Encoding = "TS_2DIFF";
    private String int64Encoding = "TS_2DIFF";
    private String floatEncoding = "GORILLA";
    private String doubleEncoding = "GORILLA";
    private String textEncoding = "PLAIN";
    private String booleanCompression = null;
    private String int32Compression = null;
    private String int64Compression = null;
    private String floatCompression = null;
    private String doubleCompression = null;
    private String textCompression = null;
    private String valueEncoder = "PLAIN";
    private int rleBitWidth = 8;
    private int deltaBlockSize = 128;
    private String freqType = "SINGLE_FREQ";
    private double plaMaxError = 100.0;
    private double sdtMaxError = 100.0;
    private double dftSatisfyRate = 0.1;
    private CompressionType compressor = CompressionType.LZ4;
    private byte[] encryptKey;
    private String encryptType = "UNENCRYPTED";
    private byte[] encryptSalt = EncryptUtils.generateSalt();
    private int pageCheckSizeThreshold = 100;
    private String endian = "BIG_ENDIAN";
    private FSType[] tSFileStorageFs = new FSType[]{FSType.LOCAL};
    private String coreSitePath = "/etc/hadoop/conf/core-site.xml";
    private String hdfsSitePath = "/etc/hadoop/conf/hdfs-site.xml";
    private String hdfsIp = "localhost";
    private String hdfsPort = "9000";
    private String dfsNameServices = "hdfsnamespace.";
    private String dfsHaNamenodes = "nn1,nn2";
    private boolean dfsHaAutomaticFailoverEnabled = true;
    private String dfsClientFailoverProxyProvider = "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider";
    private boolean useKerberos = false;
    private String kerberosKeytabFilePath = "/path";
    private String kerberosPrincipal = "principal";
    private double bloomFilterErrorRate = 0.05;
    private int batchSize = 1000;
    private int maxTsBlockSizeInBytes = 131072;
    private int maxTsBlockLineNumber = 1000;
    private int patternMatchingThreshold = 1000000;
    private String hdfsFile = "org.apache.iotdb.hadoop.fileSystem.HDFSFile";
    private String hdfsTsFileInput = "org.apache.iotdb.hadoop.fileSystem.HDFSInput";
    private String hdfsTsFileOutput = "org.apache.iotdb.hadoop.fileSystem.HDFSOutput";
    private String objectStorageFile = "org.apache.iotdb.os.fileSystem.OSFile";
    private String objectStorageTsFileInput = "org.apache.iotdb.os.fileSystem.OSTsFileInput";
    private String objectStorageTsFileOutput = "org.apache.iotdb.os.fileSystem.OSTsFileOutput";
    private boolean lz4UseJni = true;
    private Properties customizedProperties = new Properties();

    public String getEncryptType() {
        return this.encryptType;
    }

    public void setEncryptType(String encryptType) {
        this.encryptType = encryptType;
    }

    public byte[] getEncryptKey() {
        return this.encryptKey;
    }

    public void setEncryptKey(byte[] encryptKey) {
        this.encryptKey = encryptKey;
    }

    public void setEncryptKeyFromToken(String token) {
        this.encryptKey = EncryptUtils.getEncryptKeyFromToken(token, this.encryptSalt);
    }

    public void setEncryptSalt(byte[] encryptSalt) {
        this.encryptSalt = encryptSalt;
    }

    public byte[] getEncryptSalt() {
        return this.encryptSalt;
    }

    public int getGroupSizeInByte() {
        return this.groupSizeInByte;
    }

    public void setGroupSizeInByte(int groupSizeInByte) {
        this.groupSizeInByte = groupSizeInByte;
    }

    public int getPageSizeInByte() {
        return this.pageSizeInByte;
    }

    public void setPageSizeInByte(int pageSizeInByte) {
        this.pageSizeInByte = pageSizeInByte;
    }

    public int getMaxNumberOfPointsInPage() {
        return this.maxNumberOfPointsInPage;
    }

    public void setMaxNumberOfPointsInPage(int maxNumberOfPointsInPage) {
        this.maxNumberOfPointsInPage = maxNumberOfPointsInPage;
    }

    public int getMaxDegreeOfIndexNode() {
        return this.maxDegreeOfIndexNode;
    }

    public void setMaxDegreeOfIndexNode(int maxDegreeOfIndexNode) {
        this.maxDegreeOfIndexNode = maxDegreeOfIndexNode;
    }

    public TSDataType getTimeSeriesDataType() {
        return this.timeSeriesDataType;
    }

    public void setTimeSeriesDataType(TSDataType timeSeriesDataType) {
        this.timeSeriesDataType = timeSeriesDataType;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public int getFloatPrecision() {
        return this.floatPrecision;
    }

    public void setFloatPrecision(int floatPrecision) {
        this.floatPrecision = floatPrecision;
    }

    public String getTimeEncoder() {
        return this.timeEncoding;
    }

    public void setTimeEncoder(String timeEncoder) {
        this.timeEncoding = timeEncoder;
    }

    @Deprecated
    public String getValueEncoder() {
        return this.valueEncoder;
    }

    public String getValueEncoder(TSDataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return this.booleanEncoding;
            }
            case INT32: 
            case DATE: {
                return this.int32Encoding;
            }
            case INT64: 
            case TIMESTAMP: {
                return this.int64Encoding;
            }
            case FLOAT: {
                return this.floatEncoding;
            }
            case DOUBLE: {
                return this.doubleEncoding;
            }
        }
        return this.textEncoding;
    }

    public CompressionType getCompressor(TSDataType dataType) {
        String compressionName;
        switch (dataType) {
            case BOOLEAN: {
                compressionName = this.booleanCompression;
                break;
            }
            case INT32: 
            case DATE: {
                compressionName = this.int32Compression;
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                compressionName = this.int64Compression;
                break;
            }
            case FLOAT: {
                compressionName = this.floatCompression;
                break;
            }
            case DOUBLE: {
                compressionName = this.doubleCompression;
                break;
            }
            case STRING: 
            case BLOB: 
            case TEXT: {
                compressionName = this.textCompression;
                break;
            }
            default: {
                compressionName = null;
            }
        }
        CompressionType compressionType = compressionName != null ? CompressionType.valueOf(compressionName) : this.compressor;
        return compressionType;
    }

    public void setValueEncoder(String valueEncoder) {
        this.valueEncoder = valueEncoder;
    }

    public String getBooleanEncoding() {
        return this.booleanEncoding;
    }

    public void setBooleanEncoding(String booleanEncoding) {
        this.booleanEncoding = booleanEncoding;
    }

    public String getInt32Encoding() {
        return this.int32Encoding;
    }

    public void setInt32Encoding(String int32Encoding) {
        this.int32Encoding = int32Encoding;
    }

    public String getInt64Encoding() {
        return this.int64Encoding;
    }

    public void setInt64Encoding(String int64Encoding) {
        this.int64Encoding = int64Encoding;
    }

    public String getFloatEncoding() {
        return this.floatEncoding;
    }

    public void setFloatEncoding(String floatEncoding) {
        this.floatEncoding = floatEncoding;
    }

    public String getDoubleEncoding() {
        return this.doubleEncoding;
    }

    public void setDoubleEncoding(String doubleEncoding) {
        this.doubleEncoding = doubleEncoding;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
    }

    public int getRleBitWidth() {
        return this.rleBitWidth;
    }

    public void setRleBitWidth(int rleBitWidth) {
        this.rleBitWidth = rleBitWidth;
    }

    public int getDeltaBlockSize() {
        return this.deltaBlockSize;
    }

    public void setDeltaBlockSize(int deltaBlockSize) {
        this.deltaBlockSize = deltaBlockSize;
    }

    public String getFreqType() {
        return this.freqType;
    }

    public void setFreqType(String freqType) {
        this.freqType = freqType;
    }

    public double getPlaMaxError() {
        return this.plaMaxError;
    }

    public void setPlaMaxError(double plaMaxError) {
        this.plaMaxError = plaMaxError;
    }

    public double getSdtMaxError() {
        return this.sdtMaxError;
    }

    public void setSdtMaxError(double sdtMaxError) {
        this.sdtMaxError = sdtMaxError;
    }

    public double getDftSatisfyRate() {
        return this.dftSatisfyRate;
    }

    public void setDftSatisfyRate(double dftSatisfyRate) {
        this.dftSatisfyRate = dftSatisfyRate;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public void setCompressor(String compressor) {
        this.compressor = CompressionType.valueOf(compressor);
    }

    public int getPageCheckSizeThreshold() {
        return this.pageCheckSizeThreshold;
    }

    public void setPageCheckSizeThreshold(int pageCheckSizeThreshold) {
        this.pageCheckSizeThreshold = pageCheckSizeThreshold;
    }

    public String getEndian() {
        return this.endian;
    }

    public void setEndian(String endian) {
        this.endian = endian;
    }

    public boolean isUseKerberos() {
        return this.useKerberos;
    }

    public void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    public String getKerberosKeytabFilePath() {
        return this.kerberosKeytabFilePath;
    }

    public void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public double getBloomFilterErrorRate() {
        return this.bloomFilterErrorRate;
    }

    public void setBloomFilterErrorRate(double bloomFilterErrorRate) {
        this.bloomFilterErrorRate = bloomFilterErrorRate;
    }

    public FSType[] getTSFileStorageFs() {
        return this.tSFileStorageFs;
    }

    public void setTSFileStorageFs(FSType[] fileStorageFs) {
        this.tSFileStorageFs = fileStorageFs;
        FSUtils.reload();
    }

    public String getCoreSitePath() {
        return this.coreSitePath;
    }

    public void setCoreSitePath(String coreSitePath) {
        this.coreSitePath = coreSitePath;
    }

    public String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    public void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public String[] getHdfsIp() {
        return this.hdfsIp.split(",");
    }

    public void setHdfsIp(String[] hdfsIp) {
        this.hdfsIp = String.join((CharSequence)",", hdfsIp);
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public String getDfsNameServices() {
        return this.dfsNameServices;
    }

    public void setDfsNameServices(String dfsNameServices) {
        this.dfsNameServices = dfsNameServices;
    }

    public String[] getDfsHaNamenodes() {
        return this.dfsHaNamenodes.split(",");
    }

    public void setDfsHaNamenodes(String[] dfsHaNamenodes) {
        this.dfsHaNamenodes = String.join((CharSequence)",", dfsHaNamenodes);
    }

    public boolean isDfsHaAutomaticFailoverEnabled() {
        return this.dfsHaAutomaticFailoverEnabled;
    }

    public void setDfsHaAutomaticFailoverEnabled(boolean dfsHaAutomaticFailoverEnabled) {
        this.dfsHaAutomaticFailoverEnabled = dfsHaAutomaticFailoverEnabled;
    }

    public String getDfsClientFailoverProxyProvider() {
        return this.dfsClientFailoverProxyProvider;
    }

    public void setDfsClientFailoverProxyProvider(String dfsClientFailoverProxyProvider) {
        this.dfsClientFailoverProxyProvider = dfsClientFailoverProxyProvider;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxTsBlockSizeInBytes() {
        return this.maxTsBlockSizeInBytes;
    }

    public void setMaxTsBlockSizeInBytes(int maxTsBlockSizeInBytes) {
        this.maxTsBlockSizeInBytes = maxTsBlockSizeInBytes;
    }

    public int getMaxTsBlockLineNumber() {
        return this.maxTsBlockLineNumber;
    }

    public void setMaxTsBlockLineNumber(int maxTsBlockLineNumber) {
        this.maxTsBlockLineNumber = maxTsBlockLineNumber;
    }

    public int getPatternMatchingThreshold() {
        return this.patternMatchingThreshold;
    }

    public void setPatternMatchingThreshold(int patternMatchingThreshold) {
        this.patternMatchingThreshold = patternMatchingThreshold;
    }

    public Properties getCustomizedProperties() {
        return this.customizedProperties;
    }

    public void setCustomizedProperties(Properties customizedProperties) {
        this.customizedProperties = customizedProperties;
    }

    public String getSprintzPredictScheme() {
        return "fire";
    }

    public String getHdfsFile() {
        return this.hdfsFile;
    }

    public void setHdfsFile(String hdfsFile) {
        this.hdfsFile = hdfsFile;
    }

    public String getHdfsTsFileInput() {
        return this.hdfsTsFileInput;
    }

    public void setHdfsTsFileInput(String hdfsTsFileInput) {
        this.hdfsTsFileInput = hdfsTsFileInput;
    }

    public String getHdfsTsFileOutput() {
        return this.hdfsTsFileOutput;
    }

    public void setHdfsTsFileOutput(String hdfsTsFileOutput) {
        this.hdfsTsFileOutput = hdfsTsFileOutput;
    }

    public String getObjectStorageFile() {
        return this.objectStorageFile;
    }

    public void setObjectStorageFile(String objectStorageFile) {
        this.objectStorageFile = objectStorageFile;
    }

    public String getObjectStorageTsFileInput() {
        return this.objectStorageTsFileInput;
    }

    public void setObjectStorageTsFileInput(String objectStorageTsFileInput) {
        this.objectStorageTsFileInput = objectStorageTsFileInput;
    }

    public String getObjectStorageTsFileOutput() {
        return this.objectStorageTsFileOutput;
    }

    public void setObjectStorageTsFileOutput(String objectStorageTsFileOutput) {
        this.objectStorageTsFileOutput = objectStorageTsFileOutput;
    }

    public boolean isLz4UseJni() {
        return this.lz4UseJni;
    }

    public void setLz4UseJni(boolean lz4UseJni) {
        this.lz4UseJni = lz4UseJni;
    }

    public void setBooleanCompression(String booleanCompression) {
        this.booleanCompression = booleanCompression;
    }

    public void setInt32Compression(String int32Compression) {
        this.int32Compression = int32Compression;
    }

    public void setInt64Compression(String int64Compression) {
        this.int64Compression = int64Compression;
    }

    public void setFloatCompression(String floatCompression) {
        this.floatCompression = floatCompression;
    }

    public void setDoubleCompression(String doubleCompression) {
        this.doubleCompression = doubleCompression;
    }

    public void setTextCompression(String textCompression) {
        this.textCompression = textCompression;
    }
}

