/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.iotv2.container.IoTV2GlobalComponentContainer;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeSinkRetryTimesConfigurableException;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.sink.protocol.IoTDBSink;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeSink;
import org.apache.iotdb.consensus.pipe.metric.PipeConsensusSyncLagManager;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.consensus.ReplicateProgressDataNodeManager;
import org.apache.iotdb.db.pipe.consensus.metric.PipeConsensusSinkMetrics;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.PipeConsensusSyncSink;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.handler.PipeConsensusDeleteEventHandler;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.handler.PipeConsensusTabletBatchEventHandler;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.handler.PipeConsensusTabletInsertNodeEventHandler;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.handler.PipeConsensusTsFileInsertionEventHandler;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.builder.PipeConsensusAsyncBatchReqBuilder;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusDeleteNodeReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTabletBinaryReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTabletInsertNodeReq;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
@TableModel
public class PipeConsensusAsyncSink
extends IoTDBSink
implements ConsensusPipeSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusAsyncSink.class);
    private static final String ENQUEUE_EXCEPTION_MSG = "Timeout: PipeConsensusConnector offers an event into transferBuffer failed, because transferBuffer is full.";
    private static final String THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT = "Failed to borrow client from client pool or exception occurred when sending to receiver.";
    private static final String THRIFT_ERROR_FORMATTER_WITH_ENDPOINT = "Failed to borrow client from client pool or exception occurred when sending to receiver %s:%s.";
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final long PIPE_CONSENSUS_EVENT_ENQUEUE_TIMEOUT_IN_MS = IOTDB_CONFIG.getConnectionTimeoutInMS() / 6;
    private final Queue<EnrichedEvent> retryEventQueue = new PriorityBlockingQueue<EnrichedEvent>(IOTDB_CONFIG.getIotConsensusV2PipelineSize(), Comparator.comparingLong(EnrichedEvent::getReplicateIndexForIoTV2));
    private final BlockingQueue<EnrichedEvent> transferBuffer = new LinkedBlockingDeque<EnrichedEvent>(IOTDB_CONFIG.getIotConsensusV2PipelineSize());
    private ScheduledExecutorService backgroundTaskService;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final int thisDataNodeId = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
    private PipeConsensusSinkMetrics pipeConsensusSinkMetrics;
    private String consensusPipeName;
    private int consensusGroupId;
    private PipeConsensusSyncSink retryConnector;
    private IClientManager<TEndPoint, AsyncPipeConsensusServiceClient> asyncTransferClientManager;
    private PipeConsensusAsyncBatchReqBuilder tabletBatchBuilder;
    private volatile long currentReplicateProgress = 0L;

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false, String.format("One of %s, %s must be specified in consensus pipe", "connector.consensus.group-id", "connector.consensus.pipe-name"), new Object[]{parameters.hasAttribute("connector.consensus.group-id"), parameters.hasAttribute("connector.consensus.pipe-name")});
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        this.consensusGroupId = parameters.getInt("connector.consensus.group-id");
        this.consensusPipeName = parameters.getString("connector.consensus.pipe-name");
        this.pipeConsensusSinkMetrics = new PipeConsensusSinkMetrics(this);
        PipeConsensusSyncLagManager.getInstance((String)this.getConsensusGroupIdStr()).addConsensusPipeConnector(new ConsensusPipeName(this.consensusPipeName), (ConsensusPipeSink)this);
        MetricService.getInstance().addMetricSet((IMetricSet)this.pipeConsensusSinkMetrics);
        this.retryConnector = new PipeConsensusSyncSink(this.nodeUrls, this.consensusGroupId, this.thisDataNodeId, this.pipeConsensusSinkMetrics);
        this.retryConnector.customize(parameters, configuration);
        this.asyncTransferClientManager = IoTV2GlobalComponentContainer.getInstance().getGlobalAsyncClientManager();
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder = new PipeConsensusAsyncBatchReqBuilder(parameters, new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId), this.thisDataNodeId);
        }
        this.isTabletBatchModeEnabled = false;
        this.backgroundTaskService = IoTV2GlobalComponentContainer.getInstance().getBackgroundTaskService();
    }

    private boolean addEvent2Buffer(EnrichedEvent event) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("PipeConsensus-ConsensusGroup-{}: no.{} event-{} added to connector buffer", new Object[]{this.consensusGroupId, event.getReplicateIndexForIoTV2(), event});
            }
            if (this.transferBuffer.contains(event)) {
                return true;
            }
            long currentTime = System.nanoTime();
            boolean result = this.transferBuffer.offer(event, PIPE_CONSENSUS_EVENT_ENQUEUE_TIMEOUT_IN_MS, TimeUnit.MILLISECONDS);
            long duration = System.nanoTime() - currentTime;
            this.pipeConsensusSinkMetrics.recordConnectorEnqueueTimer(duration);
            if (result) {
                event.increaseReferenceCount(PipeConsensusAsyncSink.class.getName());
            }
            if (this.isClosed.get()) {
                event.clearReferenceCount(PipeConsensusAsyncSink.class.getName());
            }
            return result;
        }
        catch (InterruptedException e) {
            LOGGER.info("PipeConsensusConnector transferBuffer queue offer is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public synchronized void removeEventFromBuffer(EnrichedEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PipeConsensus-ConsensusGroup-{}: one event-{} successfully received by the follower, will be removed from queue, queue size = {}, limit size = {}", new Object[]{this.consensusGroupId, event, this.transferBuffer.size(), IOTDB_CONFIG.getIotConsensusV2PipelineSize()});
        }
        if (this.transferBuffer.isEmpty()) {
            LOGGER.info("PipeConsensus-ConsensusGroup-{}: try to remove event-{} after pipeConsensusAsyncConnector being closed. Ignore it.", (Object)this.consensusGroupId, (Object)event);
            return;
        }
        Iterator iterator = this.transferBuffer.iterator();
        EnrichedEvent current = (EnrichedEvent)iterator.next();
        while (!current.equalsInPipeConsensus((Object)event) && iterator.hasNext()) {
            current = (EnrichedEvent)iterator.next();
        }
        iterator.remove();
        this.currentReplicateProgress = Math.max(this.currentReplicateProgress, event.getReplicateIndexForIoTV2());
        event.decreaseReferenceCount(PipeConsensusAsyncSink.class.getName(), true);
    }

    public void handshake() throws Exception {
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        this.asyncTransferQueuedEventsIfNecessary();
        boolean enqueueResult = this.addEvent2Buffer((EnrichedEvent)tabletInsertionEvent);
        if (!enqueueResult) {
            throw new PipeRuntimeSinkRetryTimesConfigurableException(ENQUEUE_EXCEPTION_MSG, Integer.MAX_VALUE);
        }
        if (this.isTabletBatchModeEnabled) {
            if (this.tabletBatchBuilder.onEvent(tabletInsertionEvent)) {
                PipeConsensusTabletBatchEventHandler pipeConsensusTabletBatchEventHandler = new PipeConsensusTabletBatchEventHandler(this.tabletBatchBuilder, this, this.pipeConsensusSinkMetrics);
                this.transfer(pipeConsensusTabletBatchEventHandler);
                this.tabletBatchBuilder.onSuccess();
            }
        } else {
            this.transferInEventWithoutCheck((PipeInsertionEvent)tabletInsertionEvent);
        }
    }

    private void transfer(PipeConsensusTabletBatchEventHandler pipeConsensusTabletBatchEventHandler) {
        AsyncPipeConsensusServiceClient client = null;
        try {
            client = (AsyncPipeConsensusServiceClient)this.asyncTransferClientManager.borrowClient((Object)this.getFollowerUrl());
            pipeConsensusTabletBatchEventHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeConsensusTabletBatchEventHandler.onError(ex);
        }
    }

    private boolean transferInEventWithoutCheck(PipeInsertionEvent tabletInsertionEvent) throws Exception {
        PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent;
        if (!pipeInsertNodeTabletInsertionEvent.increaseReferenceCount(PipeConsensusAsyncSink.class.getName())) {
            return false;
        }
        TConsensusGroupId tConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId);
        TCommitId tCommitId = new TCommitId(pipeInsertNodeTabletInsertionEvent.getReplicateIndexForIoTV2(), pipeInsertNodeTabletInsertionEvent.getCommitterKey().getRestartTimes(), pipeInsertNodeTabletInsertionEvent.getRebootTimes());
        InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNode();
        ProgressIndex progressIndex = pipeInsertNodeTabletInsertionEvent.getProgressIndex();
        TPipeConsensusTransferReq pipeConsensusTransferReq = Objects.isNull(insertNode) ? PipeConsensusTabletBinaryReq.toTPipeConsensusTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer(), tCommitId, tConsensusGroupId, progressIndex, this.thisDataNodeId) : PipeConsensusTabletInsertNodeReq.toTPipeConsensusTransferReq(insertNode, tCommitId, tConsensusGroupId, progressIndex, this.thisDataNodeId);
        PipeConsensusTabletInsertNodeEventHandler pipeConsensusInsertNodeReqHandler = new PipeConsensusTabletInsertNodeEventHandler(pipeInsertNodeTabletInsertionEvent, pipeConsensusTransferReq, this, this.pipeConsensusSinkMetrics);
        this.transfer(pipeConsensusInsertNodeReqHandler);
        return true;
    }

    private void transfer(PipeConsensusTabletInsertNodeEventHandler pipeConsensusInsertNodeReqHandler) {
        AsyncPipeConsensusServiceClient client = null;
        try {
            client = (AsyncPipeConsensusServiceClient)this.asyncTransferClientManager.borrowClient((Object)this.getFollowerUrl());
            pipeConsensusInsertNodeReqHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeConsensusInsertNodeReqHandler.onError(ex);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        this.asyncTransferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("PipeConsensusAsyncConnector only support PipeTsFileInsertionEvent. Current event: {}.", (Object)tsFileInsertionEvent);
            return;
        }
        boolean enqueueResult = this.addEvent2Buffer((EnrichedEvent)tsFileInsertionEvent);
        if (!enqueueResult) {
            throw new PipeRuntimeSinkRetryTimesConfigurableException(ENQUEUE_EXCEPTION_MSG, Integer.MAX_VALUE);
        }
        this.transferWithoutCheck(tsFileInsertionEvent);
    }

    private boolean transferWithoutCheck(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
        if (!pipeTsFileInsertionEvent.increaseReferenceCount(PipeConsensusAsyncSink.class.getName())) {
            return false;
        }
        TCommitId tCommitId = new TCommitId(pipeTsFileInsertionEvent.getReplicateIndexForIoTV2(), pipeTsFileInsertionEvent.getCommitterKey().getRestartTimes(), pipeTsFileInsertionEvent.getRebootTimes());
        TConsensusGroupId tConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId);
        try {
            if (!pipeTsFileInsertionEvent.getTsFile().exists()) {
                throw new FileNotFoundException(pipeTsFileInsertionEvent.getTsFile().getAbsolutePath());
            }
            PipeConsensusTsFileInsertionEventHandler pipeConsensusTsFileInsertionEventHandler = new PipeConsensusTsFileInsertionEventHandler(pipeTsFileInsertionEvent, this, tCommitId, tConsensusGroupId, this.consensusPipeName, this.thisDataNodeId, this.pipeConsensusSinkMetrics);
            this.transfer(pipeConsensusTsFileInsertionEventHandler);
            return true;
        }
        catch (Exception e) {
            pipeTsFileInsertionEvent.decreaseReferenceCount(PipeConsensusAsyncSink.class.getName(), false);
            throw e;
        }
    }

    private void transfer(PipeConsensusTsFileInsertionEventHandler pipeConsensusTsFileInsertionEventHandler) {
        AsyncPipeConsensusServiceClient client = null;
        try {
            client = (AsyncPipeConsensusServiceClient)this.asyncTransferClientManager.borrowClient((Object)this.getFollowerUrl());
            pipeConsensusTsFileInsertionEventHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeConsensusTsFileInsertionEventHandler.onError(ex);
        }
    }

    public void transfer(Event event) throws Exception {
        this.asyncTransferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (event instanceof PipeDeleteDataNodeEvent) {
            PipeDeleteDataNodeEvent deleteDataNodeEvent = (PipeDeleteDataNodeEvent)event;
            boolean enqueueResult = this.addEvent2Buffer(deleteDataNodeEvent);
            if (!enqueueResult) {
                throw new PipeRuntimeSinkRetryTimesConfigurableException(ENQUEUE_EXCEPTION_MSG, Integer.MAX_VALUE);
            }
            this.transferDeletion(deleteDataNodeEvent);
            return;
        }
        if (!(event instanceof PipeHeartbeatEvent)) {
            LOGGER.warn("PipeConsensusAsyncConnector does not support transferring generic event: {}.", (Object)event);
        }
    }

    private boolean transferDeletion(PipeDeleteDataNodeEvent pipeDeleteDataNodeEvent) {
        if (!pipeDeleteDataNodeEvent.increaseReferenceCount(PipeConsensusSyncSink.class.getName())) {
            return false;
        }
        ProgressIndex progressIndex = pipeDeleteDataNodeEvent.getProgressIndex();
        TCommitId tCommitId = new TCommitId(pipeDeleteDataNodeEvent.getReplicateIndexForIoTV2(), pipeDeleteDataNodeEvent.getCommitterKey().getRestartTimes(), pipeDeleteDataNodeEvent.getRebootTimes());
        TConsensusGroupId tConsensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, this.consensusGroupId);
        PipeConsensusDeleteNodeReq pipeConsensusTransferReq = PipeConsensusDeleteNodeReq.toTPipeConsensusTransferReq(pipeDeleteDataNodeEvent.getDeleteDataNode(), tCommitId, tConsensusGroupId, progressIndex, this.thisDataNodeId);
        PipeConsensusDeleteEventHandler pipeConsensusDeleteEventHandler = new PipeConsensusDeleteEventHandler(pipeDeleteDataNodeEvent, pipeConsensusTransferReq, this, this.pipeConsensusSinkMetrics);
        this.transfer(pipeConsensusDeleteEventHandler);
        return true;
    }

    private void transfer(PipeConsensusDeleteEventHandler pipeConsensusDeleteEventHandler) {
        AsyncPipeConsensusServiceClient client = null;
        try {
            client = (AsyncPipeConsensusServiceClient)this.asyncTransferClientManager.borrowClient((Object)this.getFollowerUrl());
            pipeConsensusDeleteEventHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeConsensusDeleteEventHandler.onError(ex);
        }
    }

    private void transferBatchedEventsIfNecessary() throws IOException {
        if (!this.isTabletBatchModeEnabled || this.tabletBatchBuilder.isEmpty()) {
            return;
        }
        this.transfer(new PipeConsensusTabletBatchEventHandler(this.tabletBatchBuilder, this, this.pipeConsensusSinkMetrics));
        this.tabletBatchBuilder.onSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncTransferQueuedEventsIfNecessary() {
        long retryStartTime = System.currentTimeMillis();
        while (!this.retryEventQueue.isEmpty()) {
            PipeConsensusAsyncSink pipeConsensusAsyncSink = this;
            synchronized (pipeConsensusAsyncSink) {
                if (this.isClosed.get() || this.retryEventQueue.isEmpty()) {
                    return;
                }
                if (System.currentTimeMillis() - retryStartTime > TimeUnit.SECONDS.toMillis(20L)) {
                    LOGGER.warn("PipeConsensus-ConsensusGroup-{}: retryEventQueue is not empty after 20 seconds. retryQueue size: {}", (Object)this.consensusGroupId, (Object)this.retryEventQueue.size());
                    return;
                }
                EnrichedEvent peekedEvent = this.retryEventQueue.poll();
                long retryInterval = peekedEvent.getRetryInterval() > 500L ? peekedEvent.getRetryInterval() : 0L;
                LOGGER.info("PipeConsensus-ConsensusGroup-{}: retry with interval {} for index {} {}", new Object[]{this.consensusGroupId, retryInterval, peekedEvent.getReplicateIndexForIoTV2(), peekedEvent});
                this.backgroundTaskService.schedule(() -> {
                    if (peekedEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                        this.retryTransfer((PipeInsertNodeTabletInsertionEvent)peekedEvent);
                    } else if (peekedEvent instanceof PipeTsFileInsertionEvent) {
                        this.retryTransfer((PipeTsFileInsertionEvent)peekedEvent);
                    } else if (peekedEvent instanceof PipeDeleteDataNodeEvent) {
                        this.retryTransfer((PipeDeleteDataNodeEvent)peekedEvent);
                    } else if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("PipeConsensusAsyncConnector does not support transfer generic event: {}.", (Object)peekedEvent);
                    }
                }, retryInterval, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void retryTransfer(PipeInsertionEvent tabletInsertionEvent) {
        try {
            if (this.transferInEventWithoutCheck(tabletInsertionEvent)) {
                tabletInsertionEvent.decreaseReferenceCount(PipeConsensusAsyncSink.class.getName(), false);
            } else {
                this.addFailureEventToRetryQueue(tabletInsertionEvent);
            }
        }
        catch (Exception e) {
            tabletInsertionEvent.decreaseReferenceCount(PipeConsensusAsyncSink.class.getName(), false);
            this.addFailureEventToRetryQueue(tabletInsertionEvent);
        }
    }

    private void retryTransfer(PipeTsFileInsertionEvent tsFileInsertionEvent) {
        try {
            if (this.transferWithoutCheck(tsFileInsertionEvent)) {
                tsFileInsertionEvent.decreaseReferenceCount(PipeConsensusAsyncSink.class.getName(), false);
            } else {
                this.addFailureEventToRetryQueue(tsFileInsertionEvent);
            }
        }
        catch (Exception e) {
            tsFileInsertionEvent.decreaseReferenceCount(PipeConsensusAsyncSink.class.getName(), false);
            this.addFailureEventToRetryQueue(tsFileInsertionEvent);
        }
    }

    private void retryTransfer(PipeDeleteDataNodeEvent deleteDataNodeEvent) {
        try {
            if (this.transferDeletion(deleteDataNodeEvent)) {
                deleteDataNodeEvent.decreaseReferenceCount(PipeConsensusAsyncSink.class.getName(), false);
            } else {
                this.addFailureEventToRetryQueue(deleteDataNodeEvent);
            }
        }
        catch (Exception e) {
            deleteDataNodeEvent.decreaseReferenceCount(PipeConsensusAsyncSink.class.getName(), false);
            this.addFailureEventToRetryQueue(deleteDataNodeEvent);
        }
    }

    public synchronized void addFailureEventToRetryQueue(EnrichedEvent event) {
        if (event.isReleased()) {
            return;
        }
        if (this.isClosed.get()) {
            event.clearReferenceCount(PipeConsensusAsyncSink.class.getName());
            return;
        }
        if (this.retryEventQueue.contains(event)) {
            return;
        }
        boolean res = this.retryEventQueue.offer(event);
        if (res) {
            LOGGER.info("PipeConsensus-ConsensusGroup-{}: Event {} replicate index {} transfer failed, will be added to retry queue.", new Object[]{this.consensusGroupId, event, event.getReplicateIndexForIoTV2()});
        } else {
            LOGGER.warn("PipeConsensus-ConsensusGroup-{}: Event {} replicate index {} transfer failed, added to retry queue failed, this event will be ignored.", new Object[]{this.consensusGroupId, event, event.getReplicateIndexForIoTV2()});
        }
        if (this.isClosed.get()) {
            event.clearReferenceCount(PipeConsensusAsyncSink.class.getName());
        }
    }

    public void addFailureEventsToRetryQueue(Iterable<EnrichedEvent> events) {
        for (EnrichedEvent event : events) {
            this.addFailureEventToRetryQueue(event);
        }
    }

    public synchronized void clearRetryEventsReferenceCount() {
        while (!this.retryEventQueue.isEmpty()) {
            EnrichedEvent event = this.retryEventQueue.poll();
            event.clearReferenceCount(PipeConsensusAsyncSink.class.getName());
        }
    }

    public synchronized void clearTransferBufferReferenceCount() {
        while (!this.transferBuffer.isEmpty()) {
            EnrichedEvent event = (EnrichedEvent)this.transferBuffer.poll();
            event.clearReferenceCount(PipeConsensusAsyncSink.class.getName());
        }
    }

    private void logOnClientException(AsyncPipeConsensusServiceClient client, Exception e) {
        if (client == null) {
            LOGGER.warn(THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT, (Throwable)e);
        } else {
            LOGGER.warn(String.format(THRIFT_ERROR_FORMATTER_WITH_ENDPOINT, client.getTEndpoint().getIp(), client.getTEndpoint().getPort()), (Throwable)e);
        }
    }

    private TEndPoint getFollowerUrl() {
        return (TEndPoint)this.nodeUrls.get(0);
    }

    public synchronized void close() {
        super.close();
        this.isClosed.set(true);
        this.retryConnector.close();
        this.clearRetryEventsReferenceCount();
        this.clearTransferBufferReferenceCount();
        if (this.tabletBatchBuilder != null) {
            this.tabletBatchBuilder.close();
        }
        PipeConsensusSyncLagManager.getInstance((String)this.getConsensusGroupIdStr()).removeConsensusPipeConnector(new ConsensusPipeName(this.consensusPipeName));
        MetricService.getInstance().removeMetricSet((IMetricSet)this.pipeConsensusSinkMetrics);
    }

    public int getTransferBufferSize() {
        return this.transferBuffer.size();
    }

    public int getRetryBufferSize() {
        return this.retryEventQueue.size();
    }

    public long getLeaderReplicateProgress() {
        return ReplicateProgressDataNodeManager.getReplicateIndexForIoTV2(this.consensusPipeName);
    }

    public long getFollowerApplyProgress() {
        return this.currentReplicateProgress;
    }

    public String getConsensusGroupIdStr() {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.create((int)TConsensusGroupType.DataRegion.getValue(), (int)this.consensusGroupId);
        return groupId.toString();
    }
}

