/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FrameBound;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class WindowFrame
extends Node {
    private final Type type;
    private final FrameBound start;
    private final Optional<FrameBound> end;

    public WindowFrame(NodeLocation location, Type type, FrameBound start, Optional<FrameBound> end) {
        super(Objects.requireNonNull(location));
        this.type = Objects.requireNonNull(type, "type is null");
        this.start = Objects.requireNonNull(start, "start is null");
        this.end = Objects.requireNonNull(end, "end is null");
    }

    public Type getType() {
        return this.type;
    }

    public FrameBound getStart() {
        return this.start;
    }

    public Optional<FrameBound> getEnd() {
        return this.end;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowFrame(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.start);
        this.end.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowFrame o = (WindowFrame)obj;
        return this.type == o.type && Objects.equals(this.start, o.start) && Objects.equals(this.end, o.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.start, this.end});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("start", (Object)this.start).add("end", this.end).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!WindowFrame.sameClass(this, other)) {
            return false;
        }
        WindowFrame otherNode = (WindowFrame)other;
        return this.type == otherNode.type;
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((byte)((byte)this.type.ordinal()), (ByteBuffer)buffer);
        this.start.serialize(buffer);
        if (this.end.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
            this.end.get().serialize(buffer);
        } else {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)((byte)this.type.ordinal()), (OutputStream)stream);
        this.start.serialize(stream);
        if (this.end.isPresent()) {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.end.get().serialize(stream);
        } else {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        }
    }

    public WindowFrame(ByteBuffer byteBuffer) {
        super(null);
        this.type = Type.values()[ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)];
        this.start = new FrameBound(byteBuffer);
        this.end = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1 ? Optional.of(new FrameBound(byteBuffer)) : Optional.empty();
    }

    public static enum Type {
        RANGE,
        ROWS,
        GROUPS;

    }
}

