/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.arp1.impl;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdfxml.arp1.ARPErrorNumbers;
import org.apache.jena.rdfxml.arp1.impl.Names;
import org.apache.jena.rdfxml.arp1.impl.Taint;
import org.apache.jena.rdfxml.arp1.states.Frame;
import org.xml.sax.SAXParseException;

public abstract class QNameLexer
implements Names,
ARPErrorNumbers {
    final int bad;
    final int select;
    final Frame frame;
    static final Set<String> knownRDFProperties = new HashSet<String>();
    static final Set<String> knownRDFTypes = knownRDFProperties;

    public QNameLexer(Frame f, int good, int bad) {
        this.bad = bad &= ~good;
        this.select = good | bad;
        this.frame = f;
    }

    private int xml(String wanted, int fl) {
        return (fl & this.select) == fl && wanted.equals(this.getLocalName()) && this.getUri().equals(xmlns) ? fl : 0;
    }

    abstract boolean isInRdfns(Taint var1) throws SAXParseException;

    abstract void error(Taint var1, int var2) throws SAXParseException;

    abstract void deprecatedAttribute(Taint var1, int var2) throws SAXParseException;

    abstract String getLocalName();

    abstract String getUri();

    abstract String getQName();

    private int rdf(Taint taintMe, String wanted, int fl) throws SAXParseException {
        if ((fl & this.select) == fl && wanted.equals(this.getLocalName())) {
            if (this.isInRdfns(taintMe)) {
                return fl;
            }
            if (this.getQName().toLowerCase().startsWith("rdf:")) {
                this.frame.warning(taintMe, 135, this.getQName() + " is not special. The namespace binding of the RDF namespace is incorrect. It should be <" + rdfns + "> not <" + this.getUri() + ">");
            }
        }
        return 0;
    }

    int lookup(Taint taintMe) throws SAXParseException {
        int rslt = this.lookupNoMsg(taintMe);
        if ((rslt & this.bad) != 0) {
            switch (rslt) {
                case 1024: {
                    this.deprecatedAttribute(taintMe, rslt);
                    break;
                }
                case 16384: {
                    this.bagIDAttribute(taintMe, rslt);
                    break;
                }
                default: {
                    this.error(taintMe, rslt);
                }
            }
        }
        return rslt;
    }

    abstract void bagIDAttribute(Taint var1, int var2) throws SAXParseException;

    private int lookupNoMsg(Taint taintMe) throws SAXParseException {
        char firstChar;
        try {
            firstChar = this.getLocalName().charAt(0);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (this.getUri().equals("http://www.w3.org/2000/xmlns/")) {
                return 32768;
            }
            throw e;
        }
        switch (firstChar) {
            case 'b': {
                switch (this.getLocalName().length()) {
                    case 4: {
                        return this.xml("base", 1);
                    }
                    case 5: {
                        return this.rdf(taintMe, "bagID", 16384);
                    }
                }
                break;
            }
            case 'l': {
                switch (this.getLocalName().length()) {
                    case 2: {
                        return this.rdf(taintMe, "li", 2048);
                    }
                    case 4: {
                        return this.xml("lang", 2);
                    }
                }
                break;
            }
            case 's': {
                return this.xml("space", 4);
            }
            case 'i': {
                return this.xml("id", 4);
            }
            case 'I': {
                return this.rdf(taintMe, "ID", 8);
            }
            case 'n': {
                return this.rdf(taintMe, "nodeID", 32);
            }
            case 'a': {
                switch (this.getLocalName().length()) {
                    case 5: {
                        return this.rdf(taintMe, "about", 16);
                    }
                    case 9: {
                        return this.rdf(taintMe, "aboutEach", 1024);
                    }
                    case 15: {
                        return this.rdf(taintMe, "aboutEachPrefix", 1024);
                    }
                }
                break;
            }
            case 'r': {
                return this.rdf(taintMe, "resource", 64);
            }
            case 'R': {
                return this.rdf(taintMe, "RDF", 4096);
            }
            case 'd': {
                return this.rdf(taintMe, "datatype", 256);
            }
            case 't': {
                return this.rdf(taintMe, "type", 512);
            }
            case 'p': {
                return this.rdf(taintMe, "parseType", 128);
            }
            case 'D': {
                return this.rdf(taintMe, "Description", 8192);
            }
        }
        return 0;
    }

    protected static boolean isMemberProperty(String name) {
        if (name.startsWith("_")) {
            String number = name.substring(1);
            if (number.startsWith("-") || number.startsWith("0")) {
                return false;
            }
            try {
                Integer.parseInt(number);
                return true;
            }
            catch (NumberFormatException e) {
                try {
                    new BigInteger(number);
                    return true;
                }
                catch (NumberFormatException ee) {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean isKnownRDFProperty(String name) {
        return knownRDFProperties.contains(name) || QNameLexer.isMemberProperty(name);
    }

    public static boolean isKnownNonMemberRDFProperty(String name) {
        return knownRDFProperties.contains(name);
    }

    static {
        knownRDFTypes.add("Bag");
        knownRDFTypes.add("Seq");
        knownRDFTypes.add("Alt");
        knownRDFTypes.add("List");
        knownRDFTypes.add("XMLLiteral");
        knownRDFTypes.add("Property");
        knownRDFProperties.add("type");
        knownRDFTypes.add("Statement");
        knownRDFProperties.add("subject");
        knownRDFProperties.add("predicate");
        knownRDFProperties.add("object");
        knownRDFProperties.add("value");
        knownRDFProperties.add("first");
        knownRDFProperties.add("rest");
        knownRDFProperties.add("nil");
    }
}

