/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="jaas", name="group-list", description="List groups in a realm")
@Service
public class ListGroupsCommand
extends JaasCommandSupport {
    private static final String GROUP_LIST_FORMAT = "%-10s  %-80s";

    @Override
    public Object execute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (realm == null || entry == null) {
            System.err.println("No JAAS Realm / Module has been selected.");
            return null;
        }
        BackingEngine engine = this.getBackingEngine(entry);
        if (engine == null) {
            System.err.println("Can't get the list of users (no backing engine service registered)");
            return null;
        }
        return this.doExecute(engine);
    }

    @Override
    protected Object doExecute(BackingEngine engine) throws Exception {
        System.out.println(String.format(GROUP_LIST_FORMAT, "Group", "Roles"));
        for (GroupPrincipal group : engine.listGroups().keySet()) {
            System.out.println(String.format(GROUP_LIST_FORMAT, group.getName(), engine.listGroups().get(group)));
        }
        return null;
    }
}

