/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.WarnStatus;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;
import java.util.Properties;

public class VersionUtil {
    public static String getVersionOfArtifact(Class<?> aClass) {
        String moduleVersion = VersionUtil.getVersionOfClassByModule(aClass);
        if (moduleVersion != null) {
            return moduleVersion;
        }
        Package pkg = aClass.getPackage();
        if (pkg == null) {
            return null;
        }
        return pkg.getImplementationVersion();
    }

    public static String nonNull(String input) {
        if (input == null) {
            return "?";
        }
        return input;
    }

    private static String getVersionOfClassByModule(Class<?> aClass) {
        Module module = aClass.getModule();
        if (module == null) {
            return null;
        }
        ModuleDescriptor md = module.getDescriptor();
        if (md == null) {
            return null;
        }
        Optional<String> opt = md.rawVersion();
        return opt.orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getArtifactVersionBySelfDeclaredProperties(Class<?> aClass, String moduleName) {
        Properties props = new Properties();
        String propertiesFileName = moduleName + "-version.properties";
        String propertyKey = moduleName + "-version";
        try (InputStream is = aClass.getResourceAsStream(propertiesFileName);){
            if (is != null) {
                props.load(is);
                String string2 = props.getProperty(propertyKey);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getExpectedVersionOfDependencyByProperties(Class<?> dependerClass, String propertiesFileName, String dependencyNameAsKey) {
        Properties props = new Properties();
        try (InputStream is = dependerClass.getClassLoader().getResourceAsStream(propertiesFileName);){
            if (is != null) {
                props.load(is);
                String string2 = props.getProperty(dependencyNameAsKey);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void checkForVersionEquality(Context context, Class<?> dependerClass, Class<?> dependencyClass, String dependerName, String dependencyName) {
        String dependerVersion = VersionUtil.nonNull(VersionUtil.getVersionOfArtifact(dependerClass));
        String dependencyVersion = VersionUtil.nonNull(VersionUtil.getVersionOfArtifact(dependencyClass));
        VersionUtil.checkForVersionEquality(context, dependerVersion, dependencyVersion, dependerName, dependencyName);
    }

    public static void checkForVersionEquality(Context context, Class<?> dependerClass, String dependencyVersion, String dependerName, String dependencyName) {
        String dependerVersion = VersionUtil.nonNull(VersionUtil.getVersionOfArtifact(dependerClass));
        VersionUtil.checkForVersionEquality(context, dependerVersion, dependencyVersion, dependerName, dependencyName);
    }

    public static void checkForVersionEquality(Context context, String dependerVersion, String dependencyVersion, String dependerName, String dependencyName) {
        VersionUtil.addFoundVersionStatus(context, dependerName, dependerVersion);
        dependerVersion = VersionUtil.nonNull(dependerVersion);
        if (dependerVersion.equals("?") || !dependerVersion.equals(dependencyVersion)) {
            VersionUtil.addFoundVersionStatus(context, dependencyName, dependencyVersion);
            String discrepancyMsg = String.format("Versions of %s and %s are different or unknown.", dependencyName, dependerVersion);
            context.getStatusManager().add(new WarnStatus(discrepancyMsg, context));
        }
    }

    private static void addFoundVersionStatus(Context context, String name, String version) {
        String foundDependent = String.format("Found %s version %s", name, VersionUtil.nonNull(version));
        context.getStatusManager().add(new InfoStatus(foundDependent, context));
    }

    private static String nameToPropertiesFilename(String name) {
        return name + "-dependencies.properties";
    }

    public static void compareExpectedAndFoundVersion(Context context, String actualDependencyVersion, Class<?> dependerClass, String dependerVersion, String dependerName, String dependencyName) {
        String expectedDependencyVersion = VersionUtil.nonNull(VersionUtil.getExpectedVersionOfDependencyByProperties(dependerClass, VersionUtil.nameToPropertiesFilename(dependerName), dependencyName));
        VersionUtil.addFoundVersionStatus(context, dependencyName, actualDependencyVersion);
        VersionUtil.addFoundVersionStatus(context, dependerName, dependerVersion);
        if (!expectedDependencyVersion.equals(actualDependencyVersion)) {
            String discrepancyMsg = String.format("Expected version of %s is %s but found %s", dependencyName, expectedDependencyVersion, actualDependencyVersion);
            context.getStatusManager().add(new WarnStatus(discrepancyMsg, context));
        }
    }
}

