/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.context;

import io.micrometer.context.ThreadLocalAccessor;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public final class SecurityContextHolderThreadLocalAccessor
implements ThreadLocalAccessor<SecurityContext> {
    public Object key() {
        return SecurityContext.class.getName();
    }

    public @Nullable SecurityContext getValue() {
        SecurityContext emptyContext;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return !securityContext.equals(emptyContext = SecurityContextHolder.createEmptyContext()) ? securityContext : null;
    }

    public void setValue(SecurityContext securityContext) {
        Assert.notNull((Object)securityContext, (String)"securityContext cannot be null");
        SecurityContextHolder.setContext(securityContext);
    }

    public void setValue() {
        SecurityContextHolder.clearContext();
    }
}

