/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.customProperties;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitor;
import com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitorDecorator;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import com.fasterxml.jackson.module.jsonSchema.validation.AnnotationConstraintResolver;
import com.fasterxml.jackson.module.jsonSchema.validation.ValidationConstraintResolver;

public class ValidationSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    private ValidationConstraintResolver constraintResolver;

    public ValidationSchemaFactoryWrapper() {
        this(new AnnotationConstraintResolver());
    }

    public ValidationSchemaFactoryWrapper(ValidationConstraintResolver constraintResolver) {
        super(new ValidationSchemaFactoryWrapperFactory());
        this.constraintResolver = constraintResolver;
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        return new ObjectVisitorDecorator((ObjectVisitor)super.expectObjectFormat(convertedType)){

            private JsonSchema getPropertySchema(BeanProperty writer) {
                return ((ObjectSchema)this.getSchema()).getProperties().get(writer.getName());
            }

            @Override
            public void optionalProperty(BeanProperty writer) throws JsonMappingException {
                super.optionalProperty(writer);
                ValidationSchemaFactoryWrapper.this.addValidationConstraints(this.getPropertySchema(writer), writer);
            }

            @Override
            public void property(BeanProperty writer) throws JsonMappingException {
                super.property(writer);
                ValidationSchemaFactoryWrapper.this.addValidationConstraints(this.getPropertySchema(writer), writer);
            }
        };
    }

    protected JsonSchema addValidationConstraints(JsonSchema schema, BeanProperty prop) {
        Boolean required = this.constraintResolver.getRequired(prop);
        if (required != null) {
            schema.setRequired(required);
        }
        if (schema.isArraySchema()) {
            ArraySchema arraySchema = schema.asArraySchema();
            arraySchema.setMaxItems(this.constraintResolver.getArrayMaxItems(prop));
            arraySchema.setMinItems(this.constraintResolver.getArrayMinItems(prop));
        } else if (schema.isNumberSchema()) {
            NumberSchema numberSchema = schema.asNumberSchema();
            numberSchema.setMaximum(this.constraintResolver.getNumberMaximum(prop));
            numberSchema.setMinimum(this.constraintResolver.getNumberMinimum(prop));
        } else if (schema.isStringSchema()) {
            StringSchema stringSchema = schema.asStringSchema();
            stringSchema.setMaxLength(this.constraintResolver.getStringMaxLength(prop));
            stringSchema.setMinLength(this.constraintResolver.getStringMinLength(prop));
            stringSchema.setPattern(this.constraintResolver.getStringPattern(prop));
        }
        return schema;
    }

    private static class ValidationSchemaFactoryWrapperFactory
    extends WrapperFactory {
        private ValidationSchemaFactoryWrapperFactory() {
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p) {
            ValidationSchemaFactoryWrapper wrapper = new ValidationSchemaFactoryWrapper();
            wrapper.setProvider(p);
            return wrapper;
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p, VisitorContext rvc) {
            ValidationSchemaFactoryWrapper wrapper = new ValidationSchemaFactoryWrapper();
            wrapper.setProvider(p);
            wrapper.setVisitorContext(rvc);
            return wrapper;
        }
    }
}

