/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.registry;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.SpectatorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.servicecomb.foundation.metrics.PolledEvent;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;

public class GlobalRegistry {
    private final Clock clock;
    private final List<Registry> registries = new CopyOnWriteArrayList<Registry>();
    private Registry defaultRegistry;

    public GlobalRegistry() {
        this(Clock.SYSTEM);
    }

    public GlobalRegistry(Clock clock) {
        this.clock = clock;
    }

    public Clock getClock() {
        return this.clock;
    }

    public List<Registry> getRegistries() {
        return this.registries;
    }

    public Registry getDefaultRegistry() {
        return this.defaultRegistry;
    }

    public synchronized void add(Registry registry) {
        if (this.registries.isEmpty()) {
            this.defaultRegistry = registry;
        }
        this.registries.add(registry);
    }

    public synchronized void remove(Registry registry) {
        this.registries.remove(registry);
        if (registry != this.defaultRegistry) {
            return;
        }
        if (this.registries.isEmpty()) {
            this.defaultRegistry = null;
            return;
        }
        this.defaultRegistry = this.registries.get(0);
    }

    public synchronized void removeAll() {
        this.registries.clear();
        this.defaultRegistry = null;
    }

    public <T extends Registry> T find(Class<T> cls) {
        for (Registry registry : this.registries) {
            if (!cls.isAssignableFrom(registry.getClass())) continue;
            return (T)registry;
        }
        return null;
    }

    public PolledEvent poll(long secondInterval) {
        long msNow = this.clock.wallTime();
        ArrayList<Meter> meters = new ArrayList<Meter>();
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        for (Registry registry : this.registries) {
            SpectatorUtils.removeExpiredMeters(registry);
            for (Meter meter : registry) {
                if (meter instanceof PeriodMeter) {
                    ((PeriodMeter)meter).calcMeasurements(msNow, secondInterval);
                }
                meters.add(meter);
                meter.measure().forEach(measurements::add);
            }
        }
        return new PolledEvent(meters, measurements);
    }
}

