/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.lang.invoke.LambdaMetafactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.pending.jdk.JDK16;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.util.FactoryException;

final class EPSGCodeFinder
extends IdentifiedObjectFinder {
    private final EPSGDataAccess dao;
    private Class<? extends IdentifiedObject> declaredType;

    EPSGCodeFinder(EPSGDataAccess dao) {
        super(dao.owner);
        this.dao = dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IdentifiedObject> find(IdentifiedObject object) throws FactoryException {
        boolean old = this.dao.quiet;
        this.dao.quiet = true;
        try {
            Set<IdentifiedObject> set = super.find(object);
            return set;
        }
        finally {
            this.dao.quiet = old;
        }
    }

    private static String getName(IdentifiedObject object) {
        String name = IdentifiedObjects.getName(object, (Citation)Citations.EPSG);
        if (name == null) {
            name = IdentifiedObjects.getName(object, null);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IdentifiedObject> Condition dependencies(String column, Class<T> type, T dependency, boolean ignoreAxes) throws FactoryException {
        if (dependency != null) {
            try {
                Set<IdentifiedObject> find;
                Class<? extends IdentifiedObject> previousType = this.declaredType;
                boolean previousAxes = this.isIgnoringAxes();
                try {
                    this.setIgnoringAxes(ignoreAxes | previousAxes);
                    this.declaredType = type;
                    find = this.find(dependency);
                }
                finally {
                    this.declaredType = previousType;
                    this.setIgnoringAxes(previousAxes);
                }
                LinkedHashSet filters = JDK19.newLinkedHashSet((int)find.size());
                for (IdentifiedObject dep : find) {
                    Identifier id = IdentifiedObjects.getIdentifier(dep, (Citation)Citations.EPSG);
                    if (id == null) continue;
                    try {
                        filters.add(Integer.valueOf(id.getCode()));
                    }
                    catch (NumberFormatException e) {
                        Logging.recoverableException((Logger)EPSGDataAccess.LOGGER, EPSGCodeFinder.class, (String)"getCodeCandidates", (Throwable)e);
                    }
                }
                if (!filters.isEmpty()) {
                    return new Condition(column, filters);
                }
            }
            catch (BackingStoreException e) {
                throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
            }
        }
        return null;
    }

    private boolean isInstance(Class<? extends IdentifiedObject> type, IdentifiedObject object) {
        return (this.declaredType == null || type.isAssignableFrom(this.declaredType)) && type.isInstance(object);
    }

    /*
     * Unable to fully structure code
     */
    private boolean searchCodesFromProperties(IdentifiedObject object, boolean all, Collection<Integer> addTo) throws FactoryException {
        block65: {
            block67: {
                block66: {
                    if (!this.isInstance(CoordinateReferenceSystem.class, object)) break block66;
                    source = TableInfo.CRS;
                    if (!this.isInstance(CompoundCRS.class, object) || (components = ((CompoundCRS)object).getComponents()) == null) ** GOTO lbl-1000
                    switch (components.size()) {
                        case 1: {
                            return this.searchCodesFromProperties((IdentifiedObject)components.get(0), all, addTo);
                        }
                        case 2: {
                            filters = new Condition[2];
                            for (i = 0; i <= 1; ++i) {
                                column = i == 0 ? "CMPD_HORIZCRS_CODE" : "CMPD_VERTCRS_CODE";
                                filters[i] = this.dependencies(column, CoordinateReferenceSystem.class, component = (CoordinateReferenceSystem)components.get(i), false);
                                if (filters[i] != null) continue;
                                return false;
                            }
                            break block67;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            if (object instanceof GeneralDerivedCRS) {
                                filter = this.dependencies("BASE_CRS_CODE", CoordinateReferenceSystem.class, ((GeneralDerivedCRS)object).getBaseCRS(), true);
                            } else if (object instanceof GeodeticCRS) {
                                filter = this.dependencies("DATUM_CODE", GeodeticDatum.class, DatumOrEnsemble.asDatum((GeodeticCRS)object), true);
                            } else if (object instanceof VerticalCRS) {
                                filter = this.dependencies("DATUM_CODE", VerticalDatum.class, DatumOrEnsemble.asDatum((VerticalCRS)object), true);
                            } else if (object instanceof TemporalCRS) {
                                filter = this.dependencies("DATUM_CODE", TemporalDatum.class, DatumOrEnsemble.asDatum((TemporalCRS)object), true);
                            } else if (object instanceof DefaultParametricCRS) {
                                filter = this.dependencies("DATUM_CODE", DefaultParametricDatum.class, ((DefaultParametricCRS)object).getDatum(), true);
                            } else if (object instanceof EngineeringCRS) {
                                filter = this.dependencies("DATUM_CODE", EngineeringDatum.class, DatumOrEnsemble.asDatum((EngineeringCRS)object), true);
                            } else if (object instanceof SingleCRS) {
                                filter = this.dependencies("DATUM_CODE", Datum.class, ((SingleCRS)object).getDatum(), true);
                            } else {
                                return false;
                            }
                            if (filter == null) {
                                return false;
                            }
                            filters = new Condition[]{filter};
                            break;
                        }
                    }
                    break block67;
                }
                if (this.isInstance(Datum.class, object)) {
                    source = TableInfo.DATUM;
                    if (this.isInstance(GeodeticDatum.class, object)) {
                        filter = this.dependencies("ELLIPSOID_CODE", Ellipsoid.class, ((GeodeticDatum)object).getEllipsoid(), true);
                        if (filter == null) {
                            return false;
                        }
                        filters = new Condition[]{filter, Condition.NAME};
                    } else {
                        filters = new Condition[]{Condition.NAME};
                    }
                } else if (this.isInstance(Ellipsoid.class, object)) {
                    source = TableInfo.ELLIPSOID;
                    filters = new Condition[]{new FloatCondition("SEMI_MAJOR_AXIS", ((Ellipsoid)object).getSemiMajorAxis())};
                } else {
                    try {
                        return this.dao.getAuthorityCodes(object, addTo);
                    }
                    catch (SQLException exception) {
                        throw EPSGCodeFinder.databaseFailure(exception);
                    }
                }
            }
            buffer = new StringBuilder(350);
            if (ArraysExt.containsIdentity((Object[])filters, (Object)Condition.NAME)) {
                namePatterns = new LinkedHashSet<String>();
                namePatterns.add(EPSGCodeFinder.toDatumPattern(EPSGCodeFinder.getName(object), buffer));
                for (Object[] id : object.getAlias()) {
                    namePatterns.add(EPSGCodeFinder.toDatumPattern(id.tip().toString(), buffer));
                }
                buffer.setLength(0);
                buffer.append("SELECT OBJECT_CODE FROM \"Alias\" WHERE OBJECT_TABLE_NAME='").append(this.dao.translator.toActualTableName(source.table)).append("' AND ");
                EPSGCodeFinder.appendLikeNames(namePatterns, "ALIAS", buffer);
                aliasSQL = this.dao.translator.apply(buffer.toString());
                buffer.setLength(0);
            } else {
                namePatterns = null;
                aliasSQL = null;
            }
            buffer.append("SELECT ").append(source.codeColumn).append(" FROM ").append(source.fromClause);
            source.appendWhere(this.dao, object, buffer);
            isNext = false;
            for (Object filter : filters) {
                isNext |= filter.appendToWhere(buffer, isNext);
            }
            stmt = this.dao.connection.createStatement();
            try {
                if (namePatterns != null) {
                    if (isNext) {
                        buffer.append(" AND ");
                    }
                    isNext = false;
                    EPSGCodeFinder.appendLikeNames(namePatterns, source.nameColumn, buffer);
                    result = stmt.executeQuery(aliasSQL);
                    try {
                        while (result.next()) {
                            code = result.getInt(1);
                            if (result.wasNull()) continue;
                            if (!isNext) {
                                isNext = true;
                                buffer.append(" OR ").append(source.codeColumn).append(" IN (");
                            } else {
                                buffer.append(',');
                            }
                            buffer.append(code);
                        }
                    }
                    finally {
                        if (result != null) {
                            result.close();
                        }
                    }
                    if (isNext) {
                        buffer.append(')');
                    }
                }
                if (!all) {
                    buffer.append(" AND DEPRECATED=FALSE");
                }
                buffer.append(" ORDER BY ");
                if (all) {
                    buffer.append(this.dao.translator.useBoolean() != false ? "DEPRECATED" : "ABS(DEPRECATED)").append(", ");
                }
                for (Object filter : filters) {
                    filter.appendToOrderBy(buffer);
                }
                buffer.append(source.codeColumn);
                result = stmt.executeQuery(this.dao.translator.apply(buffer.toString()));
                try {
                    while (result.next()) {
                        code = result.getInt(1);
                        if (result.wasNull()) continue;
                        addTo.add(code);
                    }
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
                this.dao.sort(source, addTo, (ToIntFunction<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, intValue(), (Ljava/lang/Integer;)I)()).ifPresent((Consumer<IntStream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$searchCodesFromProperties$0(java.util.Collection java.util.stream.IntStream ), (Ljava/util/stream/IntStream;)V)(addTo));
                var11_18 = true;
                if (stmt == null) break block65;
            }
            catch (Throwable var11_19) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable var12_23) {
                            var11_19.addSuppressed(var12_23);
                        }
                    }
                    throw var11_19;
                }
                catch (SQLException exception) {
                    throw this.dao.databaseFailure(Identifier.class, (Comparable<?>)String.valueOf(Containers.peekFirst(filters[0].values)), exception);
                }
            }
            stmt.close();
        }
        return var11_18;
    }

    private static FactoryException databaseFailure(SQLException exception) {
        return new FactoryException(exception.getLocalizedMessage(), (Throwable)Exceptions.unwrap((Exception)exception));
    }

    private static String toDatumPattern(String name, StringBuilder buffer) {
        int end;
        int start = 0;
        if (name.startsWith("D_")) {
            start = "D_".length();
        }
        if ((end = name.indexOf(40)) < 0) {
            end = name.length();
        }
        end = CharSequences.skipTrailingWhitespaces((CharSequence)name, (int)start, (int)end);
        buffer.setLength(0);
        while (start < end) {
            int c = name.codePointAt(start);
            if (Character.isLetterOrDigit(c)) {
                buffer.appendCodePoint(c);
            } else {
                int length = buffer.length();
                if (length > 0 && buffer.charAt(length - 1) != '%') {
                    buffer.append('%');
                }
            }
            start += Character.charCount(c);
        }
        int length = buffer.length();
        if (length == 0 || buffer.charAt(length - 1) != '%') {
            buffer.append('%');
        }
        return buffer.toString();
    }

    private static void appendLikeNames(Set<String> namePatterns, String column, StringBuilder buffer) {
        String separator = "(";
        for (String pattern : namePatterns) {
            buffer.append(separator).append(column).append(" LIKE '").append(pattern).append('\'');
            separator = " OR ";
        }
        buffer.append(')');
    }

    @Override
    protected Iterable<String> getCodeCandidates(IdentifiedObject object) throws FactoryException {
        for (TableInfo source : TableInfo.values()) {
            if (!source.isSpecificEnough() || !source.type.isInstance(object)) continue;
            try {
                return new CodeCandidates(object, source);
            }
            catch (SQLException exception) {
                throw EPSGCodeFinder.databaseFailure(exception);
            }
        }
        return Set.of();
    }

    private static /* synthetic */ void lambda$searchCodesFromProperties$0(Collection addTo, IntStream sorted) {
        addTo.clear();
        addTo.addAll(JDK16.toList(sorted.mapToObj(Integer::valueOf)));
    }

    private static class Condition {
        static final Condition NAME = new Condition("NAME", Set.of());
        final String column;
        final Set<Number> values;

        Condition(String column, Set<Number> values) {
            this.column = column;
            this.values = values;
        }

        boolean appendToWhere(StringBuilder buffer, boolean isNext) {
            if (this.values.isEmpty()) {
                return false;
            }
            if (isNext) {
                buffer.append(" AND ");
            }
            buffer.append(this.column);
            if (this.values.size() == 1) {
                buffer.append('=').append(Containers.peekFirst(this.values));
            } else {
                buffer.append(" IN (");
                for (Number code : this.values) {
                    buffer.append(code).append(',');
                }
                buffer.setCharAt(buffer.length() - 1, ')');
            }
            return true;
        }

        void appendToOrderBy(StringBuilder buffer) {
        }

        public final String toString() {
            StringBuilder buffer = new StringBuilder(50);
            this.appendToWhere(buffer, false);
            return buffer.toString();
        }
    }

    private static final class FloatCondition
    extends Condition {
        FloatCondition(String column, double value) {
            super(column, Set.of(Double.valueOf(value)));
        }

        @Override
        boolean appendToWhere(StringBuilder buffer, boolean isNext) {
            if (isNext) {
                buffer.append(" AND ");
            }
            double value = ((Number)this.values.iterator().next()).doubleValue();
            double tolerance = Math.abs(1.5696105811844188E-9 * value);
            buffer.append(this.column).append(">=").append(value - tolerance).append(" AND ").append(this.column).append("<=").append(value + tolerance);
            return true;
        }

        @Override
        void appendToOrderBy(StringBuilder buffer) {
            double value = ((Number)this.values.iterator().next()).doubleValue();
            buffer.append("ABS(").append(this.column).append('-').append(value).append("), ");
        }
    }

    private final class CodeCandidates
    implements Iterable<String>,
    Disposable {
        private final IdentifiedObject object;
        private String name;
        private final TableInfo source;
        private final Set<Integer> codes;
        private final IdentifiedObjectFinder.Domain domain;
        private byte searchMethod;

        CodeCandidates(IdentifiedObject object, TableInfo source) throws SQLException, FactoryException {
            this.object = object;
            this.source = source;
            this.domain = EPSGCodeFinder.this.getSearchDomain();
            this.codes = new LinkedHashSet<Integer>();
            if (this.domain != IdentifiedObjectFinder.Domain.EXHAUSTIVE_VALID_DATASET) {
                for (ReferenceIdentifier id : object.getIdentifiers()) {
                    if (!"EPSG".equalsIgnoreCase(id.getCodeSpace())) continue;
                    try {
                        this.codes.add(Integer.valueOf(id.getCode()));
                    }
                    catch (NumberFormatException exception) {
                        Logging.ignorableException((Logger)EPSGDataAccess.LOGGER, IdentifiedObjectFinder.class, (String)"find", (Throwable)exception);
                    }
                }
            }
            if (this.codes.isEmpty()) {
                this.fetchMoreCodes(this.codes);
            }
        }

        public void dispose() {
            this.searchMethod = (byte)3;
        }

        private boolean fetchMoreCodes(Collection<Integer> addTo) throws SQLException, FactoryException {
            do {
                switch (this.searchMethod) {
                    case 0: {
                        if (this.domain == IdentifiedObjectFinder.Domain.EXHAUSTIVE_VALID_DATASET) break;
                        this.name = EPSGCodeFinder.getName(this.object);
                        EPSGCodeFinder.this.dao.findCodesFromName(this.source, TableInfo.toCacheKey(this.object), this.name, addTo);
                        break;
                    }
                    case 1: {
                        if (this.domain == IdentifiedObjectFinder.Domain.EXHAUSTIVE_VALID_DATASET || this.name == null) break;
                        EPSGCodeFinder.this.dao.findCodesFromAlias(this.source, this.name, addTo);
                        break;
                    }
                    case 2: {
                        if (this.domain == IdentifiedObjectFinder.Domain.DECLARATION) break;
                        EPSGCodeFinder.this.searchCodesFromProperties(this.object, this.domain == IdentifiedObjectFinder.Domain.ALL_DATASET, addTo);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                this.searchMethod = (byte)(this.searchMethod + 1);
            } while (addTo.isEmpty());
            return true;
        }

        private Iterator<Integer> fetchMoreCodes() {
            ArrayList<Integer> addTo = new ArrayList<Integer>();
            do {
                try {
                    if (!this.fetchMoreCodes(addTo)) {
                        break;
                    }
                }
                catch (SQLException | FactoryException exception) {
                    throw new BackingStoreException(exception);
                }
                Iterator<Integer> it = addTo.iterator();
                while (it.hasNext()) {
                    if (this.codes.add(it.next())) continue;
                    it.remove();
                }
            } while (addTo.isEmpty());
            return addTo.iterator();
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private Iterator<Integer> sources;
                {
                    this.sources = CodeCandidates.this.codes.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.sources.hasNext()) {
                        return true;
                    }
                    this.sources = CodeCandidates.this.fetchMoreCodes();
                    return this.sources.hasNext();
                }

                @Override
                public String next() {
                    if (!this.sources.hasNext()) {
                        this.sources = CodeCandidates.this.fetchMoreCodes();
                    }
                    return this.sources.next().toString();
                }
            };
        }

        public String toString() {
            return Strings.toString(this.getClass(), (Object[])new Object[]{"object", EPSGCodeFinder.getName(this.object), "source", this.source, "domain", this.domain, "size", this.codes.size()});
        }
    }
}

