/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.spring;

import java.lang.reflect.Constructor;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;

public class ClassReloadingInstantiationStrategy
extends SimpleInstantiationStrategy {
    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
        if (beanDefinition.getMethodOverrides().isEmpty()) {
            Class clazz = beanDefinition.getBeanClass();
            if (clazz.isInterface()) {
                throw new BeanInstantiationException(clazz, "Specified class is an interface");
            }
            try {
                Constructor constructor = clazz.getDeclaredConstructor(null);
                return BeanUtils.instantiateClass(constructor, null);
            }
            catch (Exception ex) {
                throw new BeanInstantiationException(clazz, "No default constructor found", (Throwable)ex);
            }
        }
        return this.instantiateWithMethodInjection(beanDefinition, beanName, owner);
    }
}

