/*
 * Decompiled with CFR 0.152.
 */
package org.javatuples;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tuple
implements Iterable<Object>,
Serializable,
Comparable<Tuple> {
    private static final long serialVersionUID = 5431085632328343101L;
    private final Object[] valueArray;
    private final List<Object> valueList;

    @Deprecated
    protected Tuple(int size, Object ... values) {
        this.valueArray = values;
        this.valueList = Arrays.asList(values);
    }

    protected Tuple(Object ... values) {
        this.valueArray = values;
        this.valueList = Arrays.asList(values);
    }

    public abstract int getSize();

    public final Object getValue(int pos) {
        if (pos >= this.getSize()) {
            throw new IllegalArgumentException("Cannot retrieve position " + pos + " in " + this.getClass().getSimpleName() + ". Positions for this class start with 0 and end with " + (this.getSize() - 1));
        }
        return this.valueArray[pos];
    }

    @Override
    public final Iterator<Object> iterator() {
        return this.valueList.iterator();
    }

    public final String toString() {
        return this.valueList.toString();
    }

    public final boolean contains(Object value) {
        for (Object val : this.valueList) {
            if (!(val == null ? value == null : val.equals(value))) continue;
            return true;
        }
        return false;
    }

    public final boolean containsAll(Collection<?> collection) {
        for (Object value : collection) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Values array cannot be null");
        }
        for (Object value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public final int indexOf(Object value) {
        int i = 0;
        for (Object val : this.valueList) {
            if (val == null ? value == null : val.equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int lastIndexOf(Object value) {
        for (int i = this.getSize() - 1; i >= 0; --i) {
            Object val = this.valueList.get(i);
            if (!(val == null ? value == null : val.equals(value))) continue;
            return i;
        }
        return -1;
    }

    public final List<Object> toList() {
        return Collections.unmodifiableList(new ArrayList<Object>(this.valueList));
    }

    public final Object[] toArray() {
        return (Object[])this.valueArray.clone();
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.valueList == null ? 0 : ((Object)this.valueList).hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return ((Object)this.valueList).equals(other.valueList);
    }

    @Override
    public int compareTo(Tuple o) {
        int tLen = this.valueArray.length;
        Object[] oValues = o.valueArray;
        int oLen = oValues.length;
        for (int i = 0; i < tLen && i < oLen; ++i) {
            Comparable tElement = (Comparable)this.valueArray[i];
            Comparable oElement = (Comparable)oValues[i];
            int comparison = tElement.compareTo(oElement);
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.valueOf(tLen).compareTo(oLen);
    }
}

