/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v3;

import io.netty.channel.ChannelHandlerContext;
import lombok.Generated;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.mqtt.handler.IMQTTProtocolHelper;
import org.apache.bifromq.mqtt.handler.MQTTTransientSessionHandler;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.Condition;
import org.apache.bifromq.mqtt.handler.v3.MQTT3ProtocolHelper;
import org.apache.bifromq.type.ClientInfo;

public final class MQTT3TransientSessionHandler
extends MQTTTransientSessionHandler {
    private final IMQTTProtocolHelper helper;

    public MQTT3TransientSessionHandler(TenantSettings settings, ITenantMeter tenantMeter, Condition oomCondition, String userSessionId, int keepAliveTimeSeconds, ClientInfo clientInfo, LWT willMessage, ChannelHandlerContext ctx) {
        super(settings, tenantMeter, oomCondition, userSessionId, keepAliveTimeSeconds, clientInfo, willMessage, ctx);
        this.helper = new MQTT3ProtocolHelper(settings, clientInfo, this.sessionCtx.userPropsCustomizer);
    }

    @Override
    protected IMQTTProtocolHelper helper() {
        return this.helper;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.memUsage.addAndGet(this.estBaseMemSize());
    }

    @Override
    public void doTearDown(ChannelHandlerContext ctx) {
        super.doTearDown(ctx);
        this.memUsage.addAndGet(-this.estBaseMemSize());
    }

    private int estBaseMemSize() {
        int s = 368;
        s += this.userSessionId.length();
        s += this.clientInfo.getSerializedSize();
        if (this.willMessage() != null) {
            s += this.willMessage().getSerializedSize();
        }
        return s;
    }

    @Generated
    public static MQTT3TransientSessionHandlerBuilder builder() {
        return new MQTT3TransientSessionHandlerBuilder();
    }

    @Generated
    public static class MQTT3TransientSessionHandlerBuilder {
        @Generated
        private TenantSettings settings;
        @Generated
        private ITenantMeter tenantMeter;
        @Generated
        private Condition oomCondition;
        @Generated
        private String userSessionId;
        @Generated
        private int keepAliveTimeSeconds;
        @Generated
        private ClientInfo clientInfo;
        @Generated
        private LWT willMessage;
        @Generated
        private ChannelHandlerContext ctx;

        @Generated
        MQTT3TransientSessionHandlerBuilder() {
        }

        @Generated
        public MQTT3TransientSessionHandlerBuilder settings(TenantSettings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        public MQTT3TransientSessionHandlerBuilder tenantMeter(ITenantMeter tenantMeter) {
            this.tenantMeter = tenantMeter;
            return this;
        }

        @Generated
        public MQTT3TransientSessionHandlerBuilder oomCondition(Condition oomCondition) {
            this.oomCondition = oomCondition;
            return this;
        }

        @Generated
        public MQTT3TransientSessionHandlerBuilder userSessionId(String userSessionId) {
            this.userSessionId = userSessionId;
            return this;
        }

        @Generated
        public MQTT3TransientSessionHandlerBuilder keepAliveTimeSeconds(int keepAliveTimeSeconds) {
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
            return this;
        }

        @Generated
        public MQTT3TransientSessionHandlerBuilder clientInfo(ClientInfo clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        @Generated
        public MQTT3TransientSessionHandlerBuilder willMessage(LWT willMessage) {
            this.willMessage = willMessage;
            return this;
        }

        @Generated
        public MQTT3TransientSessionHandlerBuilder ctx(ChannelHandlerContext ctx) {
            this.ctx = ctx;
            return this;
        }

        @Generated
        public MQTT3TransientSessionHandler build() {
            return new MQTT3TransientSessionHandler(this.settings, this.tenantMeter, this.oomCondition, this.userSessionId, this.keepAliveTimeSeconds, this.clientInfo, this.willMessage, this.ctx);
        }

        @Generated
        public String toString() {
            return "MQTT3TransientSessionHandler.MQTT3TransientSessionHandlerBuilder(settings=" + String.valueOf(this.settings) + ", tenantMeter=" + String.valueOf(this.tenantMeter) + ", oomCondition=" + String.valueOf(this.oomCondition) + ", userSessionId=" + this.userSessionId + ", keepAliveTimeSeconds=" + this.keepAliveTimeSeconds + ", clientInfo=" + String.valueOf(this.clientInfo) + ", willMessage=" + String.valueOf(this.willMessage) + ", ctx=" + String.valueOf(this.ctx) + ")";
        }
    }
}

