/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.config.persistenceunit;

import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.config.xml.MappingsImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.jpa.config.Mappings;
import org.eclipse.persistence.jpa.config.PersistenceUnit;

public class PersistenceUnitImpl
implements PersistenceUnit {
    private SEPersistenceUnitInfo puInfo;
    private List<Mappings> mappings = new ArrayList<Mappings>();

    public PersistenceUnitImpl(String name, ClassLoader cl) {
        this.puInfo = new SEPersistenceUnitInfo();
        this.puInfo.setClassLoader(cl == null ? Thread.currentThread().getContextClassLoader() : cl);
        String persistenceFactoryResource = PersistenceUnitImpl.class.getName().replace('.', '/') + ".class";
        URL puURL = PersistenceUnitImpl.class.getClassLoader().getResource(persistenceFactoryResource);
        try {
            puURL = PersistenceUnitProcessor.computePURootURL(puURL, persistenceFactoryResource);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
        this.puInfo.setPersistenceUnitRootUrl(puURL);
        this.puInfo.setProperties(new Properties());
        this.setName(name);
        this.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        this.setProperty("eclipselink.session-name", name);
    }

    public PersistenceUnitImpl(String name) {
        this(name, null);
    }

    @Override
    public Mappings addMappings() {
        MappingsImpl mappings = new MappingsImpl();
        this.mappings.add(mappings);
        return mappings;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.puInfo.getClassLoader();
    }

    @Override
    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.puInfo;
    }

    public XMLEntityMappings getMappings() {
        return (XMLEntityMappings)((MappingsImpl)this.mappings.get(0)).getMetadata();
    }

    @Override
    public String getName() {
        return this.puInfo.getPersistenceUnitName();
    }

    @Override
    public PersistenceUnit setClass(String cls) {
        this.puInfo.getManagedClassNames().add(cls);
        return this;
    }

    @Override
    public PersistenceUnit setExcludeUnlistedClasses(Boolean excludeUnlistedClasses) {
        this.puInfo.setExcludeUnlistedClasses(excludeUnlistedClasses);
        return this;
    }

    @Override
    public PersistenceUnit setJarFile(String jarFile) {
        this.puInfo.getJarFiles().add(jarFile);
        return this;
    }

    @Override
    public PersistenceUnit setJtaDataSource(String jtaDataSource) {
        this.setProperty("jakarta.persistence.jtaDataSource", jtaDataSource);
        return this;
    }

    @Override
    public PersistenceUnit setMappingFile(String mappingFile) {
        this.puInfo.getMappingFileNames().add(mappingFile);
        return this;
    }

    @Override
    public PersistenceUnit setName(String name) {
        this.puInfo.setPersistenceUnitName(name);
        return this;
    }

    @Override
    public PersistenceUnit setNonJtaDataSource(String nonJtaDataSource) {
        this.setProperty("jakarta.persistence.nonJtaDataSource", nonJtaDataSource);
        return this;
    }

    @Override
    public PersistenceUnit setProperty(String name, Object value) {
        this.puInfo.getProperties().put(name, value);
        return this;
    }

    @Override
    public PersistenceUnit setProvider(String provider) {
        this.puInfo.setPersistenceProviderClassName(provider);
        return this;
    }

    @Override
    public PersistenceUnit setSharedCacheMode(String sharedCacheMode) {
        this.puInfo.setSharedCacheMode(sharedCacheMode);
        return this;
    }

    @Override
    public PersistenceUnit setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.puInfo.setTransactionType(transactionType);
        return this;
    }

    @Override
    public PersistenceUnit setValidationMode(String validationMode) {
        this.puInfo.setValidationMode(validationMode);
        return this;
    }
}

