/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.WrrLocalityLoadBalancer;
import java.util.List;
import java.util.Map;

@Internal
public final class WrrLocalityLoadBalancerProvider
extends LoadBalancerProvider {
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new WrrLocalityLoadBalancer(helper);
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "wrr_locality_experimental";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            NameResolver.ConfigOrError childConfig = GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig((List)JsonUtil.getListOfObjects(rawConfig, (String)"childPolicy"));
            if (childConfig.getError() != null) {
                return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("Failed to parse child policy in wrr_locality LB policy: " + rawConfig).withCause((Throwable)childConfig.getError().asRuntimeException()));
            }
            return NameResolver.ConfigOrError.fromConfig((Object)new WrrLocalityLoadBalancer.WrrLocalityConfig(childConfig.getConfig()));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withCause((Throwable)e).withDescription("Failed to parse wrr_locality LB config: " + rawConfig));
        }
    }
}

