/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.Response;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.TracingExecutionInterceptor;
import io.opentelemetry.instrumentation.awssdk.v2_2.internal.TracingIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.services.sqs.model.Message;

public final class TracingList
extends ArrayList<Message> {
    private static final long serialVersionUID = 1L;
    private final Instrumenter<SqsProcessRequest, Response> instrumenter;
    private final ExecutionAttributes request;
    private final Response response;
    private final TracingExecutionInterceptor config;
    private final Context receiveContext;
    private boolean firstIterator = true;

    private TracingList(List<Message> list, Instrumenter<SqsProcessRequest, Response> instrumenter, ExecutionAttributes request, Response response, TracingExecutionInterceptor config, Context receiveContext) {
        super(list);
        this.instrumenter = instrumenter;
        this.request = request;
        this.response = response;
        this.config = config;
        this.receiveContext = receiveContext;
    }

    public static TracingList wrap(List<Message> list, Instrumenter<SqsProcessRequest, Response> instrumenter, ExecutionAttributes request, Response response, TracingExecutionInterceptor config, Context receiveContext) {
        return new TracingList(list, instrumenter, request, response, config, receiveContext);
    }

    public void disableTracing() {
        this.firstIterator = false;
    }

    @Override
    public Iterator<Message> iterator() {
        Iterator<Message> it;
        if (this.firstIterator) {
            it = TracingIterator.wrap(super.iterator(), this.instrumenter, this.request, this.response, this.config, this.receiveContext);
            this.firstIterator = false;
        } else {
            it = super.iterator();
        }
        return it;
    }

    @Override
    public void forEach(Consumer<? super Message> action) {
        for (Message message : this) {
            action.accept((Message)message);
        }
    }

    public Instrumenter<SqsProcessRequest, Response> getInstrumenter() {
        return this.instrumenter;
    }

    public ExecutionAttributes getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public TracingExecutionInterceptor getConfig() {
        return this.config;
    }

    public Context getReceiveContext() {
        return this.receiveContext;
    }
}

