/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExecutionStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryDestination;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryDestinationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TriggerHistoryRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TriggerHistoryRecord> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryId").getter(TriggerHistoryRecord.getter(TriggerHistoryRecord::queryId)).setter(TriggerHistoryRecord.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryId").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStatus").getter(TriggerHistoryRecord.getter(TriggerHistoryRecord::executionStatusAsString)).setter(TriggerHistoryRecord.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final SdkField<Long> TRIGGERED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("triggeredTimestamp").getter(TriggerHistoryRecord.getter(TriggerHistoryRecord::triggeredTimestamp)).setter(TriggerHistoryRecord.setter(Builder::triggeredTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggeredTimestamp").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(TriggerHistoryRecord.getter(TriggerHistoryRecord::errorMessage)).setter(TriggerHistoryRecord.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<List<ScheduledQueryDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinations").getter(TriggerHistoryRecord.getter(TriggerHistoryRecord::destinations)).setter(TriggerHistoryRecord.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledQueryDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, EXECUTION_STATUS_FIELD, TRIGGERED_TIMESTAMP_FIELD, ERROR_MESSAGE_FIELD, DESTINATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TriggerHistoryRecord.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryId;
    private final String executionStatus;
    private final Long triggeredTimestamp;
    private final String errorMessage;
    private final List<ScheduledQueryDestination> destinations;

    private TriggerHistoryRecord(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.executionStatus = builder.executionStatus;
        this.triggeredTimestamp = builder.triggeredTimestamp;
        this.errorMessage = builder.errorMessage;
        this.destinations = builder.destinations;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public final Long triggeredTimestamp() {
        return this.triggeredTimestamp;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<ScheduledQueryDestination> destinations() {
        return this.destinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggeredTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerHistoryRecord)) {
            return false;
        }
        TriggerHistoryRecord other = (TriggerHistoryRecord)obj;
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.triggeredTimestamp(), other.triggeredTimestamp()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations());
    }

    public final String toString() {
        return ToString.builder((String)"TriggerHistoryRecord").add("QueryId", (Object)this.queryId()).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("TriggeredTimestamp", (Object)this.triggeredTimestamp()).add("ErrorMessage", (Object)this.errorMessage()).add("Destinations", this.hasDestinations() ? this.destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "triggeredTimestamp": {
                return Optional.ofNullable(clazz.cast(this.triggeredTimestamp()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queryId", QUERY_ID_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("triggeredTimestamp", TRIGGERED_TIMESTAMP_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TriggerHistoryRecord, T> g) {
        return obj -> g.apply((TriggerHistoryRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryId;
        private String executionStatus;
        private Long triggeredTimestamp;
        private String errorMessage;
        private List<ScheduledQueryDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerHistoryRecord model) {
            this.queryId(model.queryId);
            this.executionStatus(model.executionStatus);
            this.triggeredTimestamp(model.triggeredTimestamp);
            this.errorMessage(model.errorMessage);
            this.destinations(model.destinations);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final Long getTriggeredTimestamp() {
            return this.triggeredTimestamp;
        }

        public final void setTriggeredTimestamp(Long triggeredTimestamp) {
            this.triggeredTimestamp = triggeredTimestamp;
        }

        @Override
        public final Builder triggeredTimestamp(Long triggeredTimestamp) {
            this.triggeredTimestamp = triggeredTimestamp;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final List<ScheduledQueryDestination.Builder> getDestinations() {
            List<ScheduledQueryDestination.Builder> result = ScheduledQueryDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<ScheduledQueryDestination.BuilderImpl> destinations) {
            this.destinations = ScheduledQueryDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<ScheduledQueryDestination> destinations) {
            this.destinations = ScheduledQueryDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(ScheduledQueryDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<ScheduledQueryDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (ScheduledQueryDestination)((ScheduledQueryDestination.Builder)ScheduledQueryDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TriggerHistoryRecord build() {
            return new TriggerHistoryRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TriggerHistoryRecord> {
        public Builder queryId(String var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        public Builder triggeredTimestamp(Long var1);

        public Builder errorMessage(String var1);

        public Builder destinations(Collection<ScheduledQueryDestination> var1);

        public Builder destinations(ScheduledQueryDestination ... var1);

        public Builder destinations(Consumer<ScheduledQueryDestination.Builder> ... var1);
    }
}

