/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ProcessorClient;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorRunStatusEntity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;

public class JerseyProcessorClient
extends AbstractJerseyClient
implements ProcessorClient {
    private volatile WebTarget processGroupTarget;
    private volatile WebTarget processorTarget;

    public JerseyProcessorClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyProcessorClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.processGroupTarget = baseTarget.path("/process-groups/{pgId}");
        this.processorTarget = baseTarget.path("/processors/{id}");
    }

    @Override
    public void acknowledgeDisconnectedNode() {
        this.processGroupTarget = this.processGroupTarget.queryParam("disconnectedNodeAcknowledged", new Object[]{true});
        this.processorTarget = this.processorTarget.queryParam("disconnectedNodeAcknowledged", new Object[]{true});
    }

    @Override
    public ProcessorEntity createProcessor(String parentGroupdId, ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupdId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (processorEntity == null) {
            throw new IllegalArgumentException("Processor entity cannot be null");
        }
        return this.executeAction("Error creating Processor", () -> {
            WebTarget target = this.processGroupTarget.path("/processors").resolveTemplate("pgId", (Object)parentGroupdId);
            return (ProcessorEntity)this.getRequestBuilder(target).post(Entity.entity((Object)processorEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessorEntity.class);
        });
    }

    @Override
    public ProcessorEntity getProcessor(String processorId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processorId)) {
            throw new IllegalArgumentException("Processor ID cannot be null");
        }
        return this.executeAction("Error retrieving status of Processor", () -> {
            WebTarget target = this.processorTarget.resolveTemplate("id", (Object)processorId);
            return (ProcessorEntity)this.getRequestBuilder(target).get(ProcessorEntity.class);
        });
    }

    @Override
    public ProcessorEntity updateProcessor(ProcessorEntity entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Processor entity cannot be null");
        }
        return this.executeAction("Error updating Processor", () -> {
            WebTarget target = this.processorTarget.resolveTemplate("id", (Object)entity.getId());
            return (ProcessorEntity)this.getRequestBuilder(target).put(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessorEntity.class);
        });
    }

    @Override
    public ProcessorEntity startProcessor(String processorId, String clientId, long version) throws NiFiClientException, IOException {
        return this.updateProcessorState(processorId, "RUNNING", clientId, version, false);
    }

    @Override
    public ProcessorEntity startProcessor(ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        return this.updateProcessorState(processorEntity.getId(), "RUNNING", processorEntity.getRevision().getClientId(), processorEntity.getRevision().getVersion(), processorEntity.isDisconnectedNodeAcknowledged());
    }

    @Override
    public ProcessorEntity runProcessorOnce(String processorId, String clientId, long version) throws NiFiClientException, IOException {
        return this.updateProcessorState(processorId, "RUN_ONCE", clientId, version, false);
    }

    @Override
    public ProcessorEntity runProcessorOnce(ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        return this.runProcessorOnce(processorEntity.getId(), processorEntity.getRevision().getClientId(), processorEntity.getRevision().getVersion());
    }

    @Override
    public ProcessorEntity stopProcessor(String processorId, String clientId, long version) throws NiFiClientException, IOException {
        return this.updateProcessorState(processorId, "STOPPED", clientId, version, false);
    }

    @Override
    public ProcessorEntity stopProcessor(ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        return this.updateProcessorState(processorEntity.getId(), "STOPPED", processorEntity.getRevision().getClientId(), processorEntity.getRevision().getVersion(), processorEntity.isDisconnectedNodeAcknowledged());
    }

    @Override
    public ProcessorEntity disableProcessor(String processorId, String clientId, long version) throws NiFiClientException, IOException {
        return this.updateProcessorState(processorId, "DISABLED", clientId, version, false);
    }

    @Override
    public ProcessorEntity disableProcessor(ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        return this.disableProcessor(processorEntity.getId(), processorEntity.getRevision().getClientId(), processorEntity.getRevision().getVersion());
    }

    @Override
    public ProcessorEntity deleteProcessor(String processorId, String clientId, long version) throws NiFiClientException, IOException {
        return this.deleteProcessor(processorId, clientId, version, false);
    }

    public ProcessorEntity deleteProcessor(String processorId, String clientId, long version, Boolean acknowledgeDisconnect) throws NiFiClientException, IOException {
        if (processorId == null) {
            throw new IllegalArgumentException("Processor ID cannot be null");
        }
        return this.executeAction("Error deleting Processor", () -> {
            WebTarget target = this.processorTarget.queryParam("version", new Object[]{version}).queryParam("clientId", new Object[]{clientId}).resolveTemplate("id", (Object)processorId);
            if (acknowledgeDisconnect == Boolean.TRUE) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{"true"});
            }
            return (ProcessorEntity)this.getRequestBuilder(target).delete(ProcessorEntity.class);
        });
    }

    @Override
    public ProcessorEntity deleteProcessor(ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        return this.deleteProcessor(processorEntity.getId(), processorEntity.getRevision().getClientId(), processorEntity.getRevision().getVersion(), processorEntity.isDisconnectedNodeAcknowledged());
    }

    private ProcessorEntity updateProcessorState(String processorId, String desiredState, String clientId, long version, Boolean disconnectedNodeAcknowledged) throws NiFiClientException, IOException {
        if (processorId == null) {
            throw new IllegalArgumentException("Processor ID cannot be null");
        }
        return this.executeAction("Error starting Processor", () -> {
            WebTarget target = this.processorTarget.path("/run-status").resolveTemplate("id", (Object)processorId);
            ProcessorRunStatusEntity runStatusEntity = new ProcessorRunStatusEntity();
            runStatusEntity.setState(desiredState);
            runStatusEntity.setDisconnectedNodeAcknowledged(disconnectedNodeAcknowledged);
            RevisionDTO revisionDto = new RevisionDTO();
            revisionDto.setClientId(clientId);
            revisionDto.setVersion(Long.valueOf(version));
            runStatusEntity.setRevision(revisionDto);
            return (ProcessorEntity)this.getRequestBuilder(target).put(Entity.entity((Object)runStatusEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessorEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity submitConfigVerificationRequest(VerifyConfigRequestEntity configRequestEntity) throws NiFiClientException, IOException {
        if (configRequestEntity == null) {
            throw new IllegalArgumentException("Config Request Entity cannot be null");
        }
        if (configRequestEntity.getRequest() == null) {
            throw new IllegalArgumentException("Config Request DTO cannot be null");
        }
        if (configRequestEntity.getRequest().getComponentId() == null) {
            throw new IllegalArgumentException("Processor ID cannot be null");
        }
        if (configRequestEntity.getRequest().getProperties() == null) {
            throw new IllegalArgumentException("Processor properties cannot be null");
        }
        return this.executeAction("Error submitting Config Verification Request", () -> {
            WebTarget target = this.processorTarget.path("/config/verification-requests").resolveTemplate("id", (Object)configRequestEntity.getRequest().getComponentId());
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)configRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity getConfigVerificationRequest(String processorId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error retrieving Config Verification Request", () -> {
            WebTarget target = this.processorTarget.path("/config/verification-requests/{requestId}").resolveTemplate("id", (Object)processorId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).get(VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity deleteConfigVerificationRequest(String processorId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error deleting Config Verification Request", () -> {
            WebTarget target = this.processorTarget.path("/config/verification-requests/{requestId}").resolveTemplate("id", (Object)processorId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).delete(VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public PropertyDescriptorEntity getPropertyDescriptor(String processorId, String propertyName, Boolean sensitive) throws NiFiClientException, IOException {
        Objects.requireNonNull(processorId, "Processor ID required");
        Objects.requireNonNull(propertyName, "Property Name required");
        return this.executeAction("Error retrieving Property Descriptor", () -> {
            WebTarget target = this.processorTarget.path("/descriptors").resolveTemplate("id", (Object)processorId).queryParam("propertyName", new Object[]{propertyName}).queryParam("sensitive", new Object[]{sensitive});
            return (PropertyDescriptorEntity)this.getRequestBuilder(target).get(PropertyDescriptorEntity.class);
        });
    }

    @Override
    public ProcessorEntity terminateProcessor(String processorId) throws NiFiClientException, IOException {
        Objects.requireNonNull(processorId, "Processor ID required");
        return this.executeAction("Error terminating Processor", () -> {
            WebTarget target = this.processorTarget.path("/threads").resolveTemplate("id", (Object)processorId);
            return (ProcessorEntity)this.getRequestBuilder(target).delete(ProcessorEntity.class);
        });
    }

    @Override
    public ComponentStateEntity clearProcessorState(String processorId, ComponentStateEntity componentStateEntity) throws NiFiClientException, IOException {
        Objects.requireNonNull(processorId, "Processor ID required");
        return this.executeAction("Error clearing state of the Processor", () -> {
            WebTarget target = this.processorTarget.path("/state/clear-requests").resolveTemplate("id", (Object)processorId);
            return (ComponentStateEntity)this.getRequestBuilder(target).post(Entity.entity((Object)componentStateEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ComponentStateEntity.class);
        });
    }

    @Override
    public ComponentStateEntity getProcessorState(String processorId) throws NiFiClientException, IOException {
        Objects.requireNonNull(processorId, "Processor ID required");
        return this.executeAction("Error getting state of the Processor", () -> {
            WebTarget target = this.processorTarget.path("/state").resolveTemplate("id", (Object)processorId);
            return (ComponentStateEntity)this.getRequestBuilder(target).get(ComponentStateEntity.class);
        });
    }
}

