/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.provenance.lineage;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name="lineageRequest")
public class LineageRequestDTO {
    private Long eventId;
    private LineageRequestType lineageRequestType;
    private String uuid;
    private String clusterNodeId;

    @Schema(description="The event id that was used to generate this lineage, if applicable.\nThe event id is allowed for any type of lineageRequestType.\nIf the lineageRequestType is FLOWFILE and the flowfile uuid is also included in the request, the event id will be ignored.\n")
    public Long getEventId() {
        return this.eventId;
    }

    public void setEventId(Long eventId) {
        this.eventId = eventId;
    }

    @Schema(description="The type of lineage request. PARENTS will return the lineage for the flowfiles that are parents of the specified event. CHILDREN will return the lineage for the flowfiles that are children of the specified event. FLOWFILE will return the lineage for the specified flowfile.", implementation=LineageRequestType.class)
    public LineageRequestType getLineageRequestType() {
        return this.lineageRequestType;
    }

    public void setLineageRequestType(LineageRequestType lineageRequestType) {
        this.lineageRequestType = lineageRequestType;
    }

    @Schema(description="The id of the node where this lineage originated if clustered.")
    public String getClusterNodeId() {
        return this.clusterNodeId;
    }

    public void setClusterNodeId(String clusterNodeId) {
        this.clusterNodeId = clusterNodeId;
    }

    @Schema(description="The flowfile uuid that was used to generate the lineage. The flowfile uuid is only allowed when the lineageRequestType is FLOWFILE and will take precedence over event id.")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @XmlType(name="lineageRequestType")
    @XmlEnum
    public static enum LineageRequestType {
        PARENTS,
        CHILDREN,
        FLOWFILE;

    }
}

